/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tlv;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluator;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import org.apache.taglibs.standard.resources.Resources;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class JstlBaseTLV
extends TagLibraryValidator {
    private final String EXP_ATT_PARAM = "expressionAttributes";
    protected static final String VAR = "var";
    protected static final String SCOPE = "scope";
    protected static final String PAGE_SCOPE = "page";
    protected static final String REQUEST_SCOPE = "request";
    protected static final String SESSION_SCOPE = "session";
    protected static final String APPLICATION_SCOPE = "application";
    protected final String JSP = "http://java.sun.com/JSP/Page";
    private final String CORE = "http://java.sun.com/jsp/jstl/core";
    private final String FMT = "http://java.sun.com/jsp/jstl/fmt";
    private final String SQL = "http://java.sun.com/jsp/jstl/sql";
    private final String XML = "http://java.sun.com/jsp/jstl/xml";
    private final String CORE_EL = "http://java.sun.com/jstl/core";
    private final String FMT_EL = "http://java.sun.com/jstl/fmt";
    private final String SQL_EL = "http://java.sun.com/jstl/sql";
    private final String XML_EL = "http://java.sun.com/jstl/xml";
    private final String CORE_RT = "http://java.sun.com/jstl/core_rt";
    private final String FMT_RT = "http://java.sun.com/jstl/fmt_rt";
    private final String SQL_RT = "http://java.sun.com/jstl/sql_rt";
    private final String XML_RT = "http://java.sun.com/jstl/xml_rt";
    protected String prefix;
    protected Vector messageVector;
    protected Map config;
    protected boolean failed;
    protected String lastElementId;

    protected abstract DefaultHandler getHandler();

    public JstlBaseTLV() {
        this.init();
    }

    private void init() {
        this.messageVector = null;
        this.prefix = null;
        this.config = null;
    }

    public void release() {
        super.release();
        this.init();
    }

    public synchronized ValidationMessage[] validate(String string, String string2, PageData pageData) {
        try {
            this.messageVector = new Vector();
            this.prefix = string;
            try {
                if (this.config == null) {
                    this.configure((String)this.getInitParameters().get("expressionAttributes"));
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                return JstlBaseTLV.vmFromString(Resources.getMessage("TLV_PARAMETER_ERROR", "expressionAttributes"));
            }
            DefaultHandler defaultHandler = this.getHandler();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(pageData.getInputStream(), defaultHandler);
            if (this.messageVector.size() == 0) {
                return null;
            }
            return JstlBaseTLV.vmFromVector(this.messageVector);
        }
        catch (SAXException sAXException) {
            return JstlBaseTLV.vmFromString(sAXException.toString());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return JstlBaseTLV.vmFromString(parserConfigurationException.toString());
        }
        catch (IOException iOException) {
            return JstlBaseTLV.vmFromString(iOException.toString());
        }
    }

    protected String validateExpression(String string, String string2, String string3) {
        ExpressionEvaluator expressionEvaluator;
        try {
            expressionEvaluator = ExpressionEvaluatorManager.getEvaluatorByName("org.apache.taglibs.standard.lang.jstl.Evaluator");
        }
        catch (JspException jspException) {
            return jspException.getMessage();
        }
        String string4 = expressionEvaluator.validate(string2, string3);
        if (string4 == null) {
            return string4;
        }
        return "tag = '" + string + "' / attribute = '" + string2 + "': " + string4;
    }

    protected boolean isTag(String string, String string2, String string3, String string4) {
        if (string == null || string2 == null || string3 == null || string4 == null) {
            return false;
        }
        return string.equals(string3) && string2.equals(string4);
    }

    protected boolean isJspTag(String string, String string2, String string3) {
        return this.isTag(string, string2, "http://java.sun.com/JSP/Page", string3);
    }

    protected boolean isCoreTag(String string, String string2, String string3) {
        return this.isTag(string, string2, "http://java.sun.com/jsp/jstl/core", string3) || this.isTag(string, string2, "http://java.sun.com/jstl/core", string3) || this.isTag(string, string2, "http://java.sun.com/jstl/core_rt", string3);
    }

    protected boolean isFmtTag(String string, String string2, String string3) {
        return this.isTag(string, string2, "http://java.sun.com/jsp/jstl/fmt", string3) || this.isTag(string, string2, "http://java.sun.com/jstl/fmt", string3) || this.isTag(string, string2, "http://java.sun.com/jstl/fmt_rt", string3);
    }

    protected boolean isSqlTag(String string, String string2, String string3) {
        return this.isTag(string, string2, "http://java.sun.com/jsp/jstl/sql", string3) || this.isTag(string, string2, "http://java.sun.com/jstl/sql", string3) || this.isTag(string, string2, "http://java.sun.com/jstl/sql_rt", string3);
    }

    protected boolean isXmlTag(String string, String string2, String string3) {
        return this.isTag(string, string2, "http://java.sun.com/jsp/jstl/xml", string3) || this.isTag(string, string2, "http://java.sun.com/jstl/xml", string3) || this.isTag(string, string2, "http://java.sun.com/jstl/xml_rt", string3);
    }

    protected boolean hasAttribute(Attributes attributes, String string) {
        return attributes.getValue(string) != null;
    }

    protected void fail(String string) {
        this.failed = true;
        this.messageVector.add(new ValidationMessage(this.lastElementId, string));
    }

    protected boolean isSpecified(TagData tagData, String string) {
        return tagData.getAttribute(string) != null;
    }

    protected boolean hasNoInvalidScope(Attributes attributes) {
        String string = attributes.getValue(SCOPE);
        return string == null || string.equals(PAGE_SCOPE) || string.equals(REQUEST_SCOPE) || string.equals(SESSION_SCOPE) || string.equals(APPLICATION_SCOPE);
    }

    protected boolean hasEmptyVar(Attributes attributes) {
        return "".equals(attributes.getValue(VAR));
    }

    protected boolean hasDanglingScope(Attributes attributes) {
        return attributes.getValue(SCOPE) != null && attributes.getValue(VAR) == null;
    }

    protected String getLocalPart(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private void configure(String string) {
        this.config = new HashMap();
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ":");
            String string3 = stringTokenizer2.nextToken();
            String string4 = stringTokenizer2.nextToken();
            Object object = this.config.get(string3);
            if (object == null) {
                object = new HashSet();
                this.config.put(string3, object);
            }
            ((Set)object).add(string4);
        }
    }

    static ValidationMessage[] vmFromString(String string) {
        return new ValidationMessage[]{new ValidationMessage(null, string)};
    }

    static ValidationMessage[] vmFromVector(Vector vector) {
        ValidationMessage[] validationMessageArray = new ValidationMessage[vector.size()];
        for (int i = 0; i < validationMessageArray.length; ++i) {
            validationMessageArray[i] = (ValidationMessage)vector.get(i);
        }
        return validationMessageArray;
    }
}

