/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.common.SolrException;

class StringToDateParseFunction
extends DateValue.AbstractDateValue {
    private final StringValue param;
    public static final String name = "date";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    private boolean exists = false;

    public StringToDateParseFunction(StringValue param) throws SolrException {
        this.param = param;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
    }

    @Override
    public long getLong() {
        long value = 0L;
        try {
            String paramStr = this.param.getString();
            this.exists = this.param.exists();
            if (this.exists) {
                value = Instant.parse(paramStr).toEpochMilli();
            }
        }
        catch (DateTimeParseException e) {
            this.exists = false;
        }
        return value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

