/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class ThreadDumpHandler
extends RequestHandlerBase {
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        NamedList lst;
        ThreadInfo[] tinfos;
        SimpleOrderedMap system = new SimpleOrderedMap();
        rsp.add("system", system);
        ThreadMXBean tmbean = ManagementFactory.getThreadMXBean();
        SimpleOrderedMap nl = new SimpleOrderedMap();
        nl.add("current", (Object)tmbean.getThreadCount());
        nl.add("peak", (Object)tmbean.getPeakThreadCount());
        nl.add("daemon", (Object)tmbean.getDaemonThreadCount());
        system.add("threadCount", (Object)nl);
        long[] tids = tmbean.findDeadlockedThreads();
        if (tids != null) {
            tinfos = tmbean.getThreadInfo(tids, Integer.MAX_VALUE);
            lst = new NamedList();
            for (ThreadInfo ti : tinfos) {
                if (ti == null) continue;
                lst.add("thread", ThreadDumpHandler.getThreadInfo(ti, tmbean));
            }
            system.add("deadlocks", (Object)lst);
        }
        tinfos = tmbean.dumpAllThreads(true, true);
        lst = new NamedList();
        for (ThreadInfo ti : tinfos) {
            if (ti == null) continue;
            lst.add("thread", ThreadDumpHandler.getThreadInfo(ti, tmbean));
        }
        system.add("threadDump", (Object)lst);
        rsp.setHttpCaching(false);
    }

    private static SimpleOrderedMap<Object> getThreadInfo(ThreadInfo ti, ThreadMXBean tmbean) {
        MonitorInfo[] monitors;
        ArrayList<String> locks;
        LockInfo[] synchronizers;
        LockInfo lockInfo;
        SimpleOrderedMap info = new SimpleOrderedMap();
        long tid = ti.getThreadId();
        info.add("id", (Object)tid);
        info.add("name", (Object)ti.getThreadName());
        info.add("state", (Object)ti.getThreadState().toString());
        if (ti.getLockName() != null) {
            info.add("lock", (Object)ti.getLockName());
        }
        if (null != (lockInfo = ti.getLockInfo())) {
            SimpleOrderedMap lock = new SimpleOrderedMap();
            info.add("lock-waiting", (Object)lock);
            lock.add("name", (Object)lockInfo.toString());
            if (-1L == ti.getLockOwnerId() && null == ti.getLockOwnerName()) {
                lock.add("owner", null);
            } else {
                SimpleOrderedMap owner = new SimpleOrderedMap();
                lock.add("owner", (Object)owner);
                owner.add("name", (Object)ti.getLockOwnerName());
                owner.add("id", (Object)ti.getLockOwnerId());
            }
        }
        if (0 < (synchronizers = ti.getLockedSynchronizers()).length) {
            locks = new ArrayList<String>(synchronizers.length);
            info.add("synchronizers-locked", locks);
            for (LockInfo sync : synchronizers) {
                locks.add(sync.toString());
            }
        }
        if (0 < (monitors = ti.getLockedMonitors()).length) {
            locks = new ArrayList(monitors.length);
            info.add("monitors-locked", locks);
            for (MonitorInfo monitor : monitors) {
                locks.add(monitor.toString());
            }
        }
        if (ti.isSuspended()) {
            info.add("suspended", (Object)true);
        }
        if (ti.isInNative()) {
            info.add("native", (Object)true);
        }
        if (tmbean.isThreadCpuTimeSupported()) {
            info.add("cpuTime", (Object)ThreadDumpHandler.formatNanos(tmbean.getThreadCpuTime(tid)));
            info.add("userTime", (Object)ThreadDumpHandler.formatNanos(tmbean.getThreadUserTime(tid)));
        }
        int i = 0;
        String[] trace = new String[ti.getStackTrace().length];
        for (StackTraceElement ste : ti.getStackTrace()) {
            trace[i++] = ste.toString();
        }
        info.add("stackTrace", (Object)trace);
        return info;
    }

    private static String formatNanos(long ns) {
        return String.format(Locale.ROOT, "%.4fms", (double)ns / 1000000.0);
    }

    @Override
    public String getDescription() {
        return "Thread Dump";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }
}

