/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SpecProvider;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.JsonSchemaValidator;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.ConfigEditablePlugin;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecurityConfHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected CoreContainer cores;
    private Collection<Api> apis;
    private AuthenticationPlugin authcPlugin;
    private AuthorizationPlugin authzPlugin;

    public SecurityConfHandler(CoreContainer coreContainer) {
        this.cores = coreContainer;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        switch (ctx.getHttpMethod()) {
            case "GET": {
                return PermissionNameProvider.Name.SECURITY_READ_PERM;
            }
            case "POST": {
                return PermissionNameProvider.Name.SECURITY_EDIT_PERM;
            }
        }
        return null;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        RequestHandlerUtils.setWt(req, "json");
        String httpMethod = (String)req.getContext().get("httpMethod");
        String path = (String)req.getContext().get("path");
        String key = path.substring(path.lastIndexOf(47) + 1);
        if ("GET".equals(httpMethod)) {
            this.getConf(rsp, key);
        } else if ("POST".equals(httpMethod)) {
            Object plugin = this.getPlugin(key);
            this.doEdit(req, rsp, path, key, plugin);
        }
    }

    private void doEdit(SolrQueryRequest req, SolrQueryResponse rsp, String path, String key, Object plugin) throws IOException {
        ConfigEditablePlugin configEditablePlugin = null;
        if (plugin == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No " + key + " plugin configured");
        }
        if (!(plugin instanceof ConfigEditablePlugin)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, key + " plugin is not editable");
        }
        configEditablePlugin = (ConfigEditablePlugin)plugin;
        if (req.getContentStreams() == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No contentStream");
        }
        List ops = CommandOperation.readCommands(req.getContentStreams(), (NamedList)rsp.getValues());
        if (ops == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No commands");
        }
        for (int count = 1; count <= 3; ++count) {
            SecurityConfig securityConfig = this.getSecurityConfig(true);
            Map<String, Object> data = securityConfig.getData();
            Map latestConf = (Map)data.get(key);
            if (latestConf == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No configuration present for " + key);
            }
            List commandsCopy = CommandOperation.clone((List)ops);
            Map<String, Object> out = configEditablePlugin.edit(Utils.getDeepCopy((Map)latestConf, (int)4), commandsCopy);
            if (out == null) {
                List errs = CommandOperation.captureErrors((List)commandsCopy);
                if (!errs.isEmpty()) {
                    rsp.add("errorMessages", errs);
                    return;
                }
                log.debug("No edits made");
                return;
            }
            if (!Objects.equals(latestConf.get("class"), out.get("class"))) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "class cannot be modified");
            }
            Map<String, Object> meta = SecurityConfHandler.getMapValue(out, "");
            meta.put("v", securityConfig.getVersion() + 1);
            data.put(key, out);
            if (this.persistConf(securityConfig)) {
                this.securityConfEdited();
                return;
            }
            log.debug("Security edit operation failed {} time(s)", (Object)count);
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to persist security config after 3 attempts. Giving up");
    }

    protected void securityConfEdited() {
    }

    Object getPlugin(String key) {
        AutoCloseable plugin = null;
        if ("authentication".equals(key)) {
            plugin = this.cores.getAuthenticationPlugin();
        }
        if ("authorization".equals(key)) {
            plugin = this.cores.getAuthorizationPlugin();
        }
        return plugin;
    }

    protected abstract void getConf(SolrQueryResponse var1, String var2);

    public static Map<String, Object> getMapValue(Map<String, Object> lookupMap, String key) {
        LinkedHashMap m = (LinkedHashMap)lookupMap.get(key);
        if (m == null) {
            m = new LinkedHashMap();
            lookupMap.put(key, m);
        }
        return m;
    }

    public static List getListValue(Map<String, Object> lookupMap, String key) {
        ArrayList l = (ArrayList)lookupMap.get(key);
        if (l == null) {
            l = new ArrayList();
            lookupMap.put(key, l);
        }
        return l;
    }

    @Override
    public String getDescription() {
        return "Edit or read security configuration";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    public abstract SecurityConfig getSecurityConfig(boolean var1);

    protected abstract boolean persistConf(SecurityConfig var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Api> getApis() {
        if (this.apis == null) {
            SecurityConfHandler securityConfHandler = this;
            synchronized (securityConfHandler) {
                if (this.apis == null) {
                    ArrayList<ApiBag.ReqHandlerToApi> apis = new ArrayList<ApiBag.ReqHandlerToApi>();
                    SpecProvider authcCommands = Utils.getSpec((String)"cluster.security.authentication.Commands");
                    SpecProvider authzCommands = Utils.getSpec((String)"cluster.security.authorization.Commands");
                    apis.add(new ApiBag.ReqHandlerToApi(this, Utils.getSpec((String)"cluster.security.authentication")));
                    apis.add(new ApiBag.ReqHandlerToApi(this, Utils.getSpec((String)"cluster.security.authorization")));
                    SpecProvider authcSpecProvider = () -> {
                        AuthenticationPlugin authcPlugin = this.cores.getAuthenticationPlugin();
                        return authcPlugin != null && authcPlugin instanceof SpecProvider ? ((SpecProvider)authcPlugin).getSpec() : authcCommands.getSpec();
                    };
                    apis.add(new ApiBag.ReqHandlerToApi(this, authcSpecProvider){

                        @Override
                        public synchronized Map<String, JsonSchemaValidator> getCommandSchema() {
                            if (SecurityConfHandler.this.authcPlugin != SecurityConfHandler.this.cores.getAuthenticationPlugin()) {
                                this.commandSchema = null;
                            }
                            SecurityConfHandler.this.authcPlugin = SecurityConfHandler.this.cores.getAuthenticationPlugin();
                            return super.getCommandSchema();
                        }
                    });
                    SpecProvider authzSpecProvider = () -> {
                        AuthorizationPlugin authzPlugin = this.cores.getAuthorizationPlugin();
                        return authzPlugin != null && authzPlugin instanceof SpecProvider ? ((SpecProvider)authzPlugin).getSpec() : authzCommands.getSpec();
                    };
                    apis.add(new ApiBag.ReqHandlerToApi(this, authzSpecProvider){

                        @Override
                        public synchronized Map<String, JsonSchemaValidator> getCommandSchema() {
                            if (SecurityConfHandler.this.authzPlugin != SecurityConfHandler.this.cores.getAuthorizationPlugin()) {
                                this.commandSchema = null;
                            }
                            SecurityConfHandler.this.authzPlugin = SecurityConfHandler.this.cores.getAuthorizationPlugin();
                            return super.getCommandSchema();
                        }
                    });
                    this.apis = ImmutableList.copyOf(apis);
                }
            }
        }
        return this.apis;
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    public static class SecurityConfig {
        private Map<String, Object> data = Collections.EMPTY_MAP;
        private int version = -1;

        public SecurityConfig setData(Map<String, Object> data) {
            this.data = data;
            return this;
        }

        public SecurityConfig setData(Object data) {
            if (data instanceof Map) {
                this.data = (Map)data;
                return this;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Illegal format when parsing security.json, not object");
        }

        public SecurityConfig setVersion(int version) {
            this.version = version;
            return this;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public int getVersion() {
            return this.version;
        }

        public SecurityConfig setData(InputStream securityJsonInputStream) {
            return this.setData(Utils.fromJSON((InputStream)securityJsonInputStream));
        }

        public String toString() {
            return "SecurityConfig: version=" + this.version + ", data=" + Utils.toJSONString(this.data);
        }
    }
}

