/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.backup;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.core.backup.BackupId;
import org.apache.solr.core.backup.repository.BackupRepository;

public class BackupFilePaths {
    private static final Pattern BACKUP_PROPS_ID_PTN = Pattern.compile("backup_([0-9]+).properties");
    private BackupRepository repository;
    private URI backupLoc;

    public BackupFilePaths(BackupRepository repository, URI backupLoc) {
        this.repository = repository;
        this.backupLoc = backupLoc;
    }

    public URI getIndexDir() {
        return this.repository.resolveDirectory(this.backupLoc, "index");
    }

    public URI getShardBackupMetadataDir() {
        return this.repository.resolveDirectory(this.backupLoc, "shard_backup_metadata");
    }

    public URI getBackupLocation() {
        return this.backupLoc;
    }

    public void createIncrementalBackupFolders() throws IOException {
        this.repository.createDirectory(this.backupLoc);
        this.repository.createDirectory(this.getIndexDir());
        this.repository.createDirectory(this.getShardBackupMetadataDir());
    }

    public static String getZkStateDir(BackupId id) {
        if (id.id == -1) {
            return "zk_backup";
        }
        return String.format(Locale.ROOT, "%s_%d", "zk_backup", id.id);
    }

    public static String getBackupPropsName(BackupId id) {
        if (id.id == -1) {
            return "backup.properties";
        }
        return BackupFilePaths.getBackupPropsName(id.id);
    }

    public static List<BackupId> findAllBackupIdsFromFileListing(String[] listFiles) {
        ArrayList<BackupId> result = new ArrayList<BackupId>();
        for (String file : listFiles) {
            Matcher m = BACKUP_PROPS_ID_PTN.matcher(file);
            if (!m.find()) continue;
            result.add(new BackupId(Integer.parseInt(m.group(1))));
        }
        return result;
    }

    public static Optional<BackupId> findMostRecentBackupIdFromFileListing(String[] listFiles) {
        return BackupFilePaths.findAllBackupIdsFromFileListing(listFiles).stream().max(Comparator.comparingInt(o -> o.id));
    }

    public static URI buildExistingBackupLocationURI(BackupRepository repository, URI location, String backupName) throws IOException {
        boolean incremental;
        URI backupNameUri = repository.resolveDirectory(location, backupName);
        String[] entries = repository.listAll(backupNameUri);
        boolean bl = incremental = !Arrays.stream(entries).anyMatch(entry -> entry.equals("backup.properties"));
        if (incremental) {
            if (entries.length != 1) {
                throw new IllegalStateException("Incremental backup URI [" + backupNameUri + "] expected to hold a single directory. Number found: " + entries.length);
            }
            String collectionName = entries[0];
            return repository.resolveDirectory(backupNameUri, entries[0]);
        }
        return backupNameUri;
    }

    private static String getBackupPropsName(int id) {
        return String.format(Locale.ROOT, "backup_%d.properties", id);
    }
}

