/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.util;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;

public class Uncertainty {
    private int measurements;
    private double sumsquares;
    private double sum;
    private double stdev;
    private double mean;
    private double uncertainty;
    private CopyOnWriteArrayList<WaitForTargetUncertainty> waiting = new CopyOnWriteArrayList();

    public void update(double value) {
        ++this.measurements;
        this.sumsquares += value * value;
        this.sum += value;
        this.mean = this.sum / (double)this.measurements;
        this.stdev = Math.sqrt(this.sumsquares / (double)this.measurements - this.mean * this.mean);
        this.uncertainty = this.stdev / Math.sqrt(this.measurements) / this.mean;
        for (WaitForTargetUncertainty waiter : this.waiting) {
            if (!(this.uncertainty < waiter.targetUncertainty && this.measurements >= waiter.minMeasurements) && this.measurements < waiter.maxMeasurements) continue;
            waiter.latch.countDown();
            this.waiting.remove(waiter);
        }
    }

    public void await(double targetUncertainty, int minMeasurements, int maxMeasurements) throws InterruptedException {
        WaitForTargetUncertainty wait = new WaitForTargetUncertainty(targetUncertainty, minMeasurements, maxMeasurements);
        this.waiting.add(wait);
        wait.await();
    }

    public double getUncertainty() {
        return this.uncertainty;
    }

    public void wakeAll() {
        for (WaitForTargetUncertainty waiting : this.waiting) {
            waiting.latch.countDown();
            this.waiting.remove(waiting);
        }
    }

    private static final class WaitForTargetUncertainty {
        final double targetUncertainty;
        final int minMeasurements;
        final int maxMeasurements;
        final CountDownLatch latch = new CountDownLatch(1);

        private WaitForTargetUncertainty(double targetUncertainty, int minMeasurements, int maxMeasurements) {
            this.targetUncertainty = targetUncertainty;
            this.minMeasurements = minMeasurements;
            this.maxMeasurements = maxMeasurements;
        }

        void await() throws InterruptedException {
            this.latch.await();
        }
    }
}

