/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import org.codehaus.jackson.Base64Variant;
import org.codehaus.jackson.JsonLocation;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.impl.JsonReadContext;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.util.ByteArrayBuilder;
import org.codehaus.jackson.util.TextBuffer;

public abstract class JsonParserBase
extends JsonParser {
    static final int INT_TAB = 9;
    static final int INT_LF = 10;
    static final int INT_CR = 13;
    static final int INT_SPACE = 32;
    static final int INT_LBRACKET = 91;
    static final int INT_RBRACKET = 93;
    static final int INT_LCURLY = 123;
    static final int INT_RCURLY = 125;
    static final int INT_QUOTE = 34;
    static final int INT_BACKSLASH = 92;
    static final int INT_SLASH = 47;
    static final int INT_COLON = 58;
    static final int INT_COMMA = 44;
    static final int INT_ASTERISK = 42;
    static final int INT_b = 98;
    static final int INT_f = 102;
    static final int INT_n = 110;
    static final int INT_r = 114;
    static final int INT_t = 116;
    static final int INT_u = 117;
    protected final IOContext _ioContext;
    protected boolean _closed;
    protected int _inputPtr = 0;
    protected int _inputEnd = 0;
    protected long _currInputProcessed = 0L;
    protected int _currInputRow = 1;
    protected int _currInputRowStart = 0;
    protected long _tokenInputTotal = 0L;
    protected int _tokenInputRow = 1;
    protected int _tokenInputCol = 0;
    protected JsonReadContext _parsingContext;
    protected JsonToken _nextToken;
    protected boolean _tokenIncomplete = false;
    protected final TextBuffer _textBuffer;
    protected char[] _nameCopyBuffer = null;
    protected boolean _nameCopied = false;
    ByteArrayBuilder _byteArrayBuilder = null;
    protected byte[] _binaryValue;

    protected JsonParserBase(IOContext iOContext, int n) {
        this._ioContext = iOContext;
        this._features = n;
        this._textBuffer = iOContext.constructTextBuffer();
        this._parsingContext = JsonReadContext.createRootContext(this._tokenInputRow, this._tokenInputCol);
    }

    protected abstract void _finishString() throws IOException, JsonParseException;

    public abstract JsonToken nextToken() throws IOException, JsonParseException;

    public final JsonToken nextValue() throws IOException, JsonParseException {
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            jsonToken = this.nextToken();
        }
        return jsonToken;
    }

    public void skipChildren() throws IOException, JsonParseException {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return;
        }
        int n = 1;
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = this.nextToken()) == null) break;
            switch (jsonToken) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++n;
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    if (--n != 0) break;
                    return;
                }
            }
        }
        this._handleEOF();
    }

    public String getCurrentName() throws IOException, JsonParseException {
        return this._parsingContext.getCurrentName();
    }

    public void close() throws IOException {
        this._closed = true;
        this._closeInput();
        this._releaseBuffers();
    }

    public boolean isClosed() {
        return this._closed;
    }

    public JsonReadContext getParsingContext() {
        return this._parsingContext;
    }

    public JsonLocation getTokenLocation() {
        return new JsonLocation(this._ioContext.getSourceReference(), this.getTokenCharacterOffset(), this.getTokenLineNr(), this.getTokenColumnNr());
    }

    public JsonLocation getCurrentLocation() {
        int n = this._inputPtr - this._currInputRowStart + 1;
        return new JsonLocation(this._ioContext.getSourceReference(), this._currInputProcessed + (long)this._inputPtr - 1L, this._currInputRow, n);
    }

    public String getText() throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    return this._parsingContext.getCurrentName();
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.contentsAsString();
                }
            }
            return this._currToken.asString();
        }
        return null;
    }

    public char[] getTextCharacters() throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    if (!this._nameCopied) {
                        String string = this._parsingContext.getCurrentName();
                        int n = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n);
                        } else if (this._nameCopyBuffer.length < n) {
                            this._nameCopyBuffer = new char[n];
                        }
                        string.getChars(0, n, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    public int getTextLength() throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    return this._parsingContext.getCurrentName().length();
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.size();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    public int getTextOffset() throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    return 0;
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    public final byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        if (this._currToken != JsonToken.VALUE_STRING) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        }
        return this._binaryValue;
    }

    protected abstract byte[] _decodeBase64(Base64Variant var1) throws IOException, JsonParseException;

    public final long getTokenCharacterOffset() {
        return this._tokenInputTotal;
    }

    public final int getTokenLineNr() {
        return this._tokenInputRow;
    }

    public final int getTokenColumnNr() {
        return this._tokenInputCol + 1;
    }

    protected abstract boolean loadMore() throws IOException;

    protected final void loadMoreGuaranteed() throws IOException {
        if (!this.loadMore()) {
            this._reportInvalidEOF();
        }
    }

    protected abstract void _closeInput() throws IOException;

    protected void _releaseBuffers() throws IOException {
        this._textBuffer.releaseBuffers();
        char[] cArray = this._nameCopyBuffer;
        if (cArray != null) {
            this._nameCopyBuffer = null;
            this._ioContext.releaseNameCopyBuffer(cArray);
        }
    }

    protected void _handleEOF() throws JsonParseException {
        if (!this._parsingContext.inRoot()) {
            this._reportInvalidEOF(": expected close marker for " + this._parsingContext.getTypeDesc() + " (from " + this._parsingContext.getStartLocation(this._ioContext.getSourceReference()) + ")");
        }
    }

    protected void _reportUnexpectedChar(int n, String string) throws JsonParseException {
        String string2 = "Unexpected character (" + JsonParserBase._getCharDesc(n) + ")";
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        this._reportError(string2);
    }

    protected void _reportInvalidEOF() throws JsonParseException {
        this._reportInvalidEOF(" in " + (Object)((Object)this._currToken));
    }

    protected void _reportInvalidEOF(String string) throws JsonParseException {
        this._reportError("Unexpected end-of-input" + string);
    }

    protected void _throwInvalidSpace(int n) throws JsonParseException {
        char c = (char)n;
        String string = "Illegal character (" + JsonParserBase._getCharDesc(c) + "): only regular white space (\\r, \\n, \\t) is allowed between tokens";
        this._reportError(string);
    }

    protected void _throwUnquotedSpace(int n, String string) throws JsonParseException {
        char c = (char)n;
        String string2 = "Illegal unquoted character (" + JsonParserBase._getCharDesc(c) + "): has to be escaped using backslash to be included in " + string;
        this._reportError(string2);
    }

    protected void _reportMismatchedEndMarker(int n, char c) throws JsonParseException {
        String string = "" + this._parsingContext.getStartLocation(this._ioContext.getSourceReference());
        this._reportError("Unexpected close marker '" + (char)n + "': expected '" + c + "' (for " + this._parsingContext.getTypeDesc() + " starting at " + string + ")");
    }

    protected static final String _getCharDesc(int n) {
        char c = (char)n;
        if (Character.isISOControl(c)) {
            return "(CTRL-CHAR, code " + n + ")";
        }
        if (n > 255) {
            return "'" + c + "' (code " + n + " / 0x" + Integer.toHexString(n) + ")";
        }
        return "'" + c + "' (code " + n + ")";
    }

    protected final void _reportError(String string) throws JsonParseException {
        throw this._constructError(string);
    }

    protected final void _wrapError(String string, Throwable throwable) throws JsonParseException {
        throw this._constructError(string, throwable);
    }

    protected final void _throwInternal() {
        throw new RuntimeException("Internal error: this code path should never get executed");
    }

    protected final JsonParseException _constructError(String string) {
        return new JsonParseException(string, this.getCurrentLocation());
    }

    protected final JsonParseException _constructError(String string, Throwable throwable) {
        return new JsonParseException(string, this.getCurrentLocation(), throwable);
    }

    public ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }
}

