/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableReference
extends Expression
implements BindingReference {
    protected Binding binding = null;
    protected SequenceType staticType = null;
    protected GroundedValue constantValue = null;
    transient String displayName = null;
    private boolean flattened = false;
    private boolean inLoop = true;
    private boolean filtered = false;

    public VariableReference() {
    }

    public VariableReference(Binding binding) {
        this.displayName = binding.getVariableQName().getDisplayName();
        this.fixup(binding);
    }

    @Override
    public Expression copy() {
        if (this.binding == null) {
            throw new UnsupportedOperationException("Cannot copy a variable reference whose binding is unknown");
        }
        VariableReference ref = new VariableReference();
        ref.binding = this.binding;
        ref.staticType = this.staticType;
        ref.constantValue = this.constantValue;
        ref.displayName = this.displayName;
        this.binding.addReference(this.inLoop);
        ExpressionTool.copyLocationInfo(this, ref);
        return ref;
    }

    @Override
    public void setStaticType(SequenceType type, GroundedValue value, int properties) {
        if (type == null) {
            type = SequenceType.ANY_SEQUENCE;
        }
        this.staticType = type;
        this.constantValue = value;
        int dependencies = this.getDependencies();
        this.staticProperties = properties & 0xFFFEFFFF | 0x400000 | type.getCardinality() | dependencies;
    }

    @Override
    public void setFlattened(boolean flattened) {
        this.flattened = flattened;
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    @Override
    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public boolean isInLoop() {
        return this.inLoop;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (this.constantValue != null) {
            this.binding = null;
            return Literal.makeLiteral(this.constantValue);
        }
        this.inLoop = visitor.isLoopingReference(this.binding, this);
        if (this.binding != null) {
            this.binding.addReference(this.inLoop);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (this.constantValue != null) {
            this.binding = null;
            return Literal.makeLiteral(this.constantValue);
        }
        return this;
    }

    @Override
    public void fixup(Binding binding) {
        this.binding = binding;
        this.resetLocalStaticProperties();
    }

    public void refineVariableType(ItemType type, int cardinality, GroundedValue constantValue, int properties, ExpressionVisitor visitor) {
        int newcard;
        ItemType oldItemType;
        Executable exec = visitor.getExecutable();
        if (exec == null) {
            return;
        }
        TypeHierarchy th = exec.getConfiguration().getTypeHierarchy();
        ItemType newItemType = oldItemType = this.getItemType(th);
        if (th.isSubType(type, oldItemType)) {
            newItemType = type;
        }
        if (oldItemType instanceof NodeTest && type instanceof AtomicType) {
            newItemType = type;
        }
        if ((newcard = cardinality & this.getCardinality()) == 0) {
            newcard = this.getCardinality();
        }
        SequenceType seqType = SequenceType.makeSequenceType(newItemType, newcard);
        this.setStaticType(seqType, constantValue, properties);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.staticType == null || this.staticType.getPrimaryType() == AnyItemType.getInstance()) {
            if (this.binding != null) {
                return this.binding.getRequiredType().getPrimaryType();
            }
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        if (this.binding != null) {
            return this.binding.getIntegerBoundsForVariable();
        }
        return null;
    }

    @Override
    public int computeCardinality() {
        if (this.staticType == null) {
            if (this.binding == null) {
                return 57344;
            }
            if (this.binding instanceof LetExpression) {
                return this.binding.getRequiredType().getCardinality();
            }
            if (this.binding instanceof Assignation) {
                return 16384;
            }
            return this.binding.getRequiredType().getCardinality();
        }
        return this.staticType.getCardinality();
    }

    @Override
    public int computeSpecialProperties() {
        Expression exp;
        int p = super.computeSpecialProperties();
        if (this.binding == null || !this.binding.isAssignable()) {
            p |= 0x400000;
        }
        if (this.binding instanceof Assignation && (exp = ((Assignation)this.binding).getSequence()) != null) {
            p |= exp.getSpecialProperties() & 0x2000000;
        }
        if (this.staticType != null && !Cardinality.allowsMany(this.staticType.getCardinality()) && this.staticType.getPrimaryType() instanceof NodeTest) {
            p |= 0x800000;
        }
        return p;
    }

    public boolean equals(Object other) {
        return other instanceof VariableReference && this.binding == ((VariableReference)other).binding && this.binding != null;
    }

    public int hashCode() {
        return this.binding == null ? 73619830 : this.binding.hashCode();
    }

    @Override
    public int getIntrinsicDependencies() {
        int d = 0;
        if (this.binding == null) {
            d |= 0x680;
        } else if (this.binding.isGlobal()) {
            if (this.binding.isAssignable()) {
                d |= 0x200;
            }
            if (this.binding instanceof GlobalParam) {
                d |= 0x400;
            }
        } else {
            d |= 0x80;
        }
        return d;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp;
        if (offer.action == 12 && (exp = offer.accept(parent, this)) != null) {
            offer.accepted = true;
            return exp;
        }
        return this;
    }

    @Override
    public int getImplementationMethod() {
        return (Cardinality.allowsMany(this.getCardinality()) ? 0 : 1) | 2 | 4;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return pathMap.getPathForVariable(this.getBinding());
    }

    @Override
    public SequenceIterator<? extends Item> iterate(XPathContext c) throws XPathException {
        try {
            Sequence actual = this.evaluateVariable(c);
            return actual.iterate();
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
        catch (AssertionError err) {
            ((Throwable)((Object)err)).printStackTrace();
            String msg = ((Throwable)((Object)err)).getMessage() + ". Variable reference $" + this.getDisplayName() + " at line " + this.getLineNumber() + (this.getSystemId() == null ? "" : " of " + this.getSystemId());
            StandardErrorListener.printStackTrace(System.err, c);
            throw new AssertionError((Object)msg);
        }
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        try {
            Sequence actual = this.evaluateVariable(c);
            return actual.head();
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
    }

    @Override
    public void process(XPathContext c) throws XPathException {
        try {
            Item it;
            SequenceIterator<? extends Item> iter = this.evaluateVariable(c).iterate();
            SequenceReceiver out = c.getReceiver();
            int loc = this.getLocationId();
            while ((it = iter.next()) != null) {
                out.append(it, loc, 2);
            }
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
    }

    public Sequence evaluateVariable(XPathContext c) throws XPathException {
        try {
            return this.binding.evaluateVariable(c);
        }
        catch (NullPointerException err) {
            if (this.binding == null) {
                throw new IllegalStateException("Variable $" + this.displayName + " has not been fixed up");
            }
            throw err;
        }
    }

    public Binding getBinding() {
        return this.binding;
    }

    public String getDisplayName() {
        if (this.binding != null) {
            return this.binding.getVariableQName().getDisplayName();
        }
        return this.displayName;
    }

    public String getEQName() {
        if (this.binding != null) {
            StructuredQName q = this.binding.getVariableQName();
            if (q.isInNamespace("")) {
                return q.getLocalPart();
            }
            return q.getEQName();
        }
        return this.displayName;
    }

    @Override
    public String toString() {
        String d = this.getEQName();
        return "$" + (d == null ? "$" : d);
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("variableReference");
        String d = this.getEQName();
        destination.emitAttribute("name", d == null ? "null" : d);
        destination.emitAttribute("slot", "" + this.binding.getLocalSlotNumber());
        destination.endElement();
    }
}

