/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim.lexer;

import com.intellij.lexer.EmbeddedTokenTypesProvider;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.slim.SlimUtil;
import org.jetbrains.plugins.slim.lexer._SlimLexer;
import org.jetbrains.plugins.slim.psi.SlimLanguageLevel;
import org.jetbrains.plugins.slim.psi.SlimTokenTypes;

public final class SlimLexer
extends MergingLexerAdapter {
    private static final TokenSet TOKENS_2_MERGE = TokenSet.create((IElementType[])new IElementType[]{SlimTokenTypes.CODE_COMMENT, SlimTokenTypes.HTML_COMMENT, SlimTokenTypes.RUBY_CODE, SlimTokenTypes.STATIC_CONTENT, SlimTokenTypes.CONTROL_CODE_START, SlimTokenTypes.BAD_CHARACTER, SlimTokenTypes.FILTER_CONTENT, SlimTokenTypes.COFFEE_CODE, SlimTokenTypes.JAVASCRIPT_CODE, SlimTokenTypes.CSS_CODE, SlimTokenTypes.SASS_CODE, SlimTokenTypes.SCSS_CODE, SlimTokenTypes.LESS_CODE, SlimTokenTypes.STYLUS_CODE, SlimTokenTypes.STRING_LITERAL});
    private static final List<EmbeddedTokenTypesProvider> embeddedTokenTypesProviders = EmbeddedTokenTypesProvider.EXTENSION_POINT_NAME.getExtensionList();
    private IElementType myTokenType;
    private final boolean myLexEmbeddedElements;

    public SlimLexer(SlimLanguageLevel slimLanguageLevel, boolean lexEmbeddedElements) {
        super((Lexer)new FlexAdapter((FlexLexer)new _SlimLexer(null)), TOKENS_2_MERGE);
        ((_SlimLexer)((FlexAdapter)this.myDelegate).getFlex()).setSlimLanguageLevel(slimLanguageLevel);
        this.myLexEmbeddedElements = lexEmbeddedElements;
    }

    public void advance() {
        this.myTokenType = null;
        IElementType previousType = this.getTokenType();
        String previousText = this.getTokenText();
        super.advance();
        if (previousType == SlimTokenTypes.FILTER) {
            for (EmbeddedTokenTypesProvider embeddedTokenTypesProvider : embeddedTokenTypesProviders) {
                if (!previousText.startsWith(embeddedTokenTypesProvider.getName())) continue;
                this.myTokenType = embeddedTokenTypesProvider.getElementType();
            }
        } else if (super.getTokenType() == SlimTokenTypes.RUBY_CODE) {
            this.myTokenType = SlimLexer.getOuterLanguageTokenType();
        }
    }

    private static IElementType getOuterLanguageTokenType() {
        return SlimUtil.getOuterLanguageTokenType();
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            SlimLexer.$$$reportNull$$$0(0);
        }
        this.myTokenType = null;
        super.start(buffer, startOffset, endOffset, initialState);
        if (this.myDelegate.getTokenType() == SlimTokenTypes.RUBY_CODE) {
            this.myTokenType = SlimLexer.getOuterLanguageTokenType();
        }
    }

    public IElementType getTokenType() {
        if (this.myLexEmbeddedElements && this.myTokenType != null) {
            return this.myTokenType;
        }
        return super.getTokenType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/plugins/slim/lexer/SlimLexer", "start"));
    }
}

