/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.DeferredIconImpl;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.intellij.plugins.markdown.injection.CodeFenceLanguageProvider;
import org.intellij.plugins.markdown.injection.LanguageGuesser;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageListCompletionContributor
extends CompletionContributor {
    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            LanguageListCompletionContributor.$$$reportNull$$$0(0);
        }
        if (context.getFile() instanceof MarkdownFile) {
            context.setDummyIdentifier("IntellijIdeaRulezzz \n");
        }
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            LanguageListCompletionContributor.$$$reportNull$$$0(1);
        }
        return typeChar == '`' && position.getNode().getElementType() == MarkdownTokenTypes.CODE_FENCE_START;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        PsiElement completionElement;
        if (parameters == null) {
            LanguageListCompletionContributor.$$$reportNull$$$0(2);
        }
        if (result == null) {
            LanguageListCompletionContributor.$$$reportNull$$$0(3);
        }
        if (PsiUtilCore.getElementType((PsiElement)(completionElement = parameters.getPosition())) == MarkdownTokenTypes.FENCE_LANG) {
            LanguageListCompletionContributor.doFillVariants(parameters, result);
        }
    }

    private static void doFillVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            LanguageListCompletionContributor.$$$reportNull$$$0(4);
        }
        if (result == null) {
            LanguageListCompletionContributor.$$$reportNull$$$0(5);
        }
        for (CodeFenceLanguageProvider codeFenceLanguageProvider : LanguageGuesser.INSTANCE.getCodeFenceLanguageProviders()) {
            List<LookupElement> lookups = codeFenceLanguageProvider.getCompletionVariantsForInfoString(parameters);
            for (LookupElement lookupElement : lookups) {
                result.addElement((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)lookupElement, (context, item) -> {
                    if (parameters == null) {
                        LanguageListCompletionContributor.$$$reportNull$$$0(6);
                    }
                    new MyInsertHandler(parameters).handleInsert(context, item);
                    lookupElement.handleInsert(context);
                }));
            }
        }
        for (Map.Entry entry : LanguageGuesser.INSTANCE.getLangToLanguageMap().entrySet()) {
            Language language = (Language)entry.getValue();
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)((String)entry.getKey())).withIcon((Icon)new DeferredIconImpl(null, (Object)language, true, language1 -> {
                LanguageFileType fileType = language1.getAssociatedFileType();
                return fileType != null ? fileType.getIcon() : null;
            })).withTypeText(language.getDisplayName(), true).withInsertHandler((InsertHandler)new MyInsertHandler(parameters));
            result.addElement((LookupElement)lookupElementBuilder);
        }
    }

    public static boolean isInMiddleOfUncollapsedFence(@Nullable PsiElement element, int offset) {
        if (element == null) {
            return false;
        }
        if (PsiUtilCore.getElementType((PsiElement)element) == MarkdownTokenTypes.CODE_FENCE_START) {
            TextRange range = element.getTextRange();
            return range.getStartOffset() + range.getEndOffset() == offset * 2;
        }
        if (PsiUtilCore.getElementType((PsiElement)element) == MarkdownTokenTypes.TEXT && PsiUtilCore.getElementType((PsiElement)element.getParent()) == MarkdownElementTypes.CODE_SPAN) {
            TextRange range = element.getTextRange();
            TextRange parentRange = element.getParent().getTextRange();
            return range.getStartOffset() - parentRange.getStartOffset() == parentRange.getEndOffset() - range.getEndOffset();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/markdown/injection/LanguageListCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeAutoPopup";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doFillVariants";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doFillVariants$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyInsertHandler
    implements InsertHandler<LookupElement> {
        private final CompletionParameters myParameters;

        MyInsertHandler(CompletionParameters parameters) {
            this.myParameters = parameters;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                MyInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                MyInsertHandler.$$$reportNull$$$0(1);
            }
            if (LanguageListCompletionContributor.isInMiddleOfUncollapsedFence(this.myParameters.getOriginalPosition(), context.getStartOffset())) {
                context.getDocument().insertString(context.getTailOffset(), (CharSequence)"\n\n");
                context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "org/intellij/plugins/markdown/injection/LanguageListCompletionContributor$MyInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

