/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerProcessUtil;
import com.intellij.docker.remote.ruby.RubyDockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.ruby.RubyDockerConsoleProcessHandler;
import com.intellij.docker.remote.ruby.RubyDockerProcessConnectionData;
import com.intellij.docker.remote.ruby.RubyDockerProcessHandler;
import com.intellij.docker.remote.run.DockerHelpersImageCreator;
import com.intellij.docker.remote.run.common.EnvsBuilder;
import com.intellij.docker.remote.run.common.ExtraHostsBuilder;
import com.intellij.docker.remote.run.common.PortsBuilder;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.runtime.WrappedInternalServerErrorException;
import com.intellij.docker.remote.run.runtime.WrappedNotFoundException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.PathMappingSettings;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubySshRemoteTransfer;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;

public class RubyDockerProcessUtil {
    private static final Logger LOG = Logger.getInstance(RubyDockerProcessUtil.class);
    public static final String RUBYMINE_HELPERS_IMAGE_REPOSITORY = "rubymine_helpers";
    public static final String RUBYMINE_HELPERS_VERSION_LABEL = "com.jetbrains.rubymine_helpers.version";
    public static final String RUBYMINE_HELPERS_DIRECTORY = "/opt/.rubymine_helpers/rb";
    public static final String RUBYMINE_HELPERS_DIRECTORY_ENV = "RUBYMINE_HELPERS_DIRECTORY";
    public static final String RUBYMINE_HELPERS_SERVICE_NAME = "rubymine_helpers";
    private static final DockerHelpersImageCreator myHelpersImageCreator = new DockerHelpersImageCreator("rubymine_helpers", "com.jetbrains.rubymine_helpers.version", "/opt/.rubymine_helpers/rb", "RUBYMINE_HELPERS_DIRECTORY", "rubymine_helpers"){

        @NotNull
        protected List<File> getHelpersRoots() {
            List<File> list = RubySshRemoteTransfer.getHelpersPaths().stream().map(s -> new File((String)s)).collect(Collectors.toList());
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/ruby/RubyDockerProcessUtil$1", "getHelpersRoots"));
        }
    };

    @NotNull
    public static DockerVolumesFrom[] getHelpersContainerVolumesFrom(@NotNull RemoteDockerRuntime dockerRuntime) throws IOException, ServerRuntimeException {
        if (dockerRuntime == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(0);
        }
        DockerVolumesFrom[] dockerVolumesFromArray = myHelpersImageCreator.getHelpersContainerVolumesFrom(dockerRuntime);
        if (dockerVolumesFromArray == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(1);
        }
        return dockerVolumesFromArray;
    }

    @NotNull
    public static SharedVolume getSharedVolume(@NotNull RemoteDockerRuntime dockerRuntime) throws IOException, ServerRuntimeException {
        if (dockerRuntime == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(2);
        }
        SharedVolume sharedVolume = myHelpersImageCreator.getHelpersContainerSharedVolume(dockerRuntime);
        if (sharedVolume == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(3);
        }
        return sharedVolume;
    }

    public static RubyDockerConsoleProcessHandler startDockerConsole(@Nullable Project project, @NotNull RubyDockerProcessConnectionData data, @NotNull GeneralCommandLine commandLine, @NotNull AbstractPathMapper pathMapper) throws RemoteSdkException {
        if (data == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(4);
        }
        if (commandLine == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(5);
        }
        if (pathMapper == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(6);
        }
        DockerExecProcess process = RubyDockerProcessUtil.createDockerProcess(project, pathMapper, data, commandLine);
        return new RubyDockerConsoleProcessHandler((RemoteProcess)process, commandLine.getCommandLineString());
    }

    public static ProcessHandler startDockerProcess(@Nullable Project project, @NotNull RubyDockerProcessConnectionData data, @NotNull GeneralCommandLine commandLine, @NotNull AbstractPathMapper pathMapper) throws RemoteSdkException {
        if (data == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(7);
        }
        if (commandLine == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(8);
        }
        if (pathMapper == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(9);
        }
        DockerExecProcess process = RubyDockerProcessUtil.createDockerProcess(project, pathMapper, data, commandLine);
        return new RubyDockerProcessHandler((RemoteProcess)process, commandLine.getCommandLineString(), null);
    }

    @NotNull
    private static DockerExecProcess createDockerProcess(@Nullable Project project, @NotNull AbstractPathMapper pathMapper, @NotNull RubyDockerProcessConnectionData data, @NotNull GeneralCommandLine commandLine) throws RemoteSdkException {
        DockerExecProcess dockerExecProcess;
        if (pathMapper == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(10);
        }
        if (data == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(11);
        }
        if (commandLine == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(12);
        }
        if (Registry.is((String)"ruby.docker.verbose.logging")) {
            LOG.info(String.format("[DOCKER]: %s", commandLine.getCommandLineString()));
        }
        if (commandLine.getWorkDirectory() != null) {
            commandLine.setWorkDirectory(pathMapper.convertToRemote(commandLine.getWorkDirectory().getPath()));
        }
        DockerContainerSettings containerSettings = project != null ? DockerContainerSettings.defaultSettings((Project)project) : null;
        try {
            Collection portForwardings;
            DockerCloudConfiguration account = data.getAccount();
            RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)account, (Project)project);
            RubyDockerAgentDeploymentConfigImpl config = new RubyDockerAgentDeploymentConfigImpl(data.getImage(), DockerProcessUtil.setupVolumesBinds(null, (DockerContainerSettings)containerSettings).build());
            if (containerSettings != null) {
                for (DockerVolumeBindingImpl binding : containerSettings.getVolumeBindings()) {
                    ((PathMappingSettings)pathMapper).addMapping(binding.getHostPath(), binding.getContainerPath());
                }
            }
            config.withEntrypoint(new String[0]);
            config.withStdinOnce(true);
            config.setupRemoteCommandLine(pathMapper, commandLine);
            config.setupHelpers(dockerRuntime);
            PortsBuilder portsBuilder = PortsBuilder.builder();
            RubyCommandLineData rubyCommandLineData = (RubyCommandLineData)commandLine.getUserData(RubyCommandLine.COMMAND_LINE_DATA_KEY);
            if (containerSettings != null) {
                portsBuilder.addPortBindings(containerSettings.getPortBindings());
            }
            if (rubyCommandLineData != null && (portForwardings = (Collection)rubyCommandLineData.getUserData(RubyCommandLineData.PORT_FORWARDING_KEY)) != null) {
                for (PortForwarding portForwarding : portForwardings) {
                    portsBuilder.addPortBinding(portForwarding.getRemotePort(), portForwarding.getLocalPort());
                }
            }
            if (containerSettings != null && containerSettings.isPublishAllPorts()) {
                config.withPublishAllPorts(true);
            } else {
                config.withPortBindings(portsBuilder.buildPortBindings());
            }
            config.withExposedPorts(portsBuilder.buildExposedPorts());
            EnvsBuilder envsBuilder = EnvsBuilder.builder().addEnvs(commandLine.getEnvironment());
            if (containerSettings != null) {
                envsBuilder.addEnvs(containerSettings.getEnvVars());
            }
            config.withEnvs(envsBuilder.withPassParentEnvironment(false).buildEnvs());
            if (containerSettings != null) {
                if (containerSettings.isNetworkDisabled()) {
                    config.withNetworkDisabled(true);
                } else if (StringUtil.isNotEmpty((String)containerSettings.getNetworkMode())) {
                    config.withNetworkMode(containerSettings.getNetworkMode());
                }
            }
            if (containerSettings != null) {
                config.withLinks(containerSettings.getLinks());
            }
            if (containerSettings != null) {
                config.withExtraHosts(ExtraHostsBuilder.builder().addExtraHosts(containerSettings.getExtraHosts()).build());
            }
            dockerExecProcess = DockerExecProcess.Factory.startProcessWithRemove((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfigImpl)config);
        }
        catch (WrappedNotFoundException e) {
            throw DockerUtil.propagateNotFoundException((ServerRuntimeException)((Object)e), (String)data.getImage());
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        if (dockerExecProcess == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(13);
        }
        return dockerExecProcess;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/ruby/RubyDockerProcessUtil";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/ruby/RubyDockerProcessUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpersContainerVolumesFrom";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedVolume";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDockerProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHelpersContainerVolumesFrom";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSharedVolume";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startDockerConsole";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startDockerProcess";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDockerProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

