/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.rails;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.Utils;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.diagram.rails.RailsAddElementAction;
import com.intellij.diagram.rails.RailsUmlDnDSupport;
import com.intellij.diagram.rails.RailsUmlRelationship;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.associations.Association;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class RailsDiagramExtras
extends DiagramExtras<RClass> {
    private final RailsUmlDnDSupport dndSupport = new RailsUmlDnDSupport();

    public DiagramDnDProvider<RClass> getDnDProvider() {
        return this.dndSupport;
    }

    public boolean useDefaultLayouter() {
        return true;
    }

    public Object getData(@NotNull String dataId, List<DiagramNode<RClass>> nodes, DiagramBuilder builder) {
        if (dataId == null) {
            RailsDiagramExtras.$$$reportNull$$$0(0);
        }
        if (nodes.isEmpty()) {
            List edges = DiagramUtils.getSelectedEdges((DiagramBuilder)builder);
            if (CommonDataKeys.NAVIGATABLE.is(dataId) && edges.size() == 1) {
                DiagramEdge edge = (DiagramEdge)edges.get(0);
                RailsUmlRelationship relationship = (RailsUmlRelationship)edge.getRelationship();
                Object fromClass = edge.getIdentifyingElement();
                Association association = relationship.getAssociation();
                if (association == null && fromClass instanceof Navigatable) {
                    return fromClass;
                }
                if (association != null) {
                    RCall reverse;
                    RCall associationCall = association.getRCall();
                    Association reverseAssociation = relationship.getReverseAssociation();
                    RCall rCall = reverse = reverseAssociation != null ? reverseAssociation.getRCall() : null;
                    if (associationCall != null && associationCall.isValid() && associationCall instanceof NavigatablePsiElement) {
                        if (reverse != null && reverse.isValid() && reverse instanceof NavigatablePsiElement) {
                            return RailsDiagramExtras.getNavigatable(builder, new Navigatable[]{associationCall, (NavigatablePsiElement)reverse});
                        }
                        return associationCall;
                    }
                }
            }
        }
        return super.getData(dataId, nodes, builder);
    }

    @Nullable
    private static Navigatable getNavigatable(final DiagramBuilder builder, final Navigatable ... navigatables) {
        if (navigatables == null || navigatables.length == 0) {
            return null;
        }
        if (navigatables.length == 1) {
            return navigatables[0];
        }
        List edges = DiagramUtils.getSelectedEdges((DiagramBuilder)builder);
        assert (edges != null && edges.size() == 1);
        DiagramEdge edge = (DiagramEdge)edges.get(0);
        final Graph2DView view = builder.getView();
        final DiagramNode src = edge.getSource();
        return new NavigatableAdapter(){

            public void navigate(boolean requestFocus) {
                JBList list = new JBList();
                list.setModel(new CollectionListModel((Object[])navigatables));
                list.setCellRenderer(new NavigationItemListCellRenderer());
                list.setSelectedIndex(0);
                JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setRequestFocus(requestFocus).setItemChoosenCallback(() -> 1.lambda$navigate$1((JList)list, navigatables, requestFocus)).createPopup();
                Utils.showPopupBeneathNode((JBPopup)popup, (Node)builder.getNode(src), (Graph2DView)view);
            }

            private static /* synthetic */ void lambda$navigate$1(JList list, Navigatable[] navigatables2, boolean requestFocus) {
                int index = list.getSelectedIndex();
                ApplicationManager.getApplication().invokeLater(() -> navigatables2[index].navigate(requestFocus));
            }
        };
    }

    public DiagramAddElementAction getAddElementHandler() {
        return new RailsAddElementAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/diagram/rails/RailsDiagramExtras", "getData"));
    }
}

