/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.puppet.PuppetParser;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.lexer.PuppetLexerAdapter;
import com.intellij.lang.puppet.lexer.PuppetTokenTypeSets;
import com.intellij.lang.puppet.psi.PuppetPsiFileImpl;
import com.intellij.lang.puppet.psi.impl.PuppetCompositePsiElementBase;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class PuppetParserDefinition
implements ParserDefinition {
    private static final TokenSet WHITE_SPACES = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
    protected static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{PuppetTokenTypes.COMMENT, PuppetTokenTypes.HEREDOC_BODY, PuppetTokenTypes.HEREDOC_BODY_QQ, PuppetTokenTypes.HEREDOC_ENDING});
    private static final TokenSet LITERALS = TokenSet.create((IElementType[])new IElementType[]{PuppetTokenTypes.STRING});
    public static final TokenSet WHITESPACE_OR_COMMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{WHITE_SPACES, COMMENTS});

    @NotNull
    public Lexer createLexer(Project project) {
        PuppetLexerAdapter puppetLexerAdapter = new PuppetLexerAdapter(project);
        if (puppetLexerAdapter == null) {
            PuppetParserDefinition.$$$reportNull$$$0(0);
        }
        return puppetLexerAdapter;
    }

    public PsiParser createParser(Project project) {
        return new PuppetParser();
    }

    public IFileElementType getFileNodeType() {
        return PuppetTokenTypeSets.PUPPET_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WHITE_SPACES;
        if (tokenSet == null) {
            PuppetParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = COMMENTS;
        if (tokenSet == null) {
            PuppetParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = LITERALS;
        if (tokenSet == null) {
            PuppetParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        if (node.getElementType() == PuppetTokenTypes.HEREDOC_BODY_QQ) {
            PuppetCompositePsiElementBase puppetCompositePsiElementBase = new PuppetCompositePsiElementBase(node);
            if (puppetCompositePsiElementBase == null) {
                PuppetParserDefinition.$$$reportNull$$$0(4);
            }
            return puppetCompositePsiElementBase;
        }
        PsiElement psiElement = PuppetTokenTypes.Factory.createElement(node);
        if (psiElement == null) {
            PuppetParserDefinition.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new PuppetPsiFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/puppet/psi/PuppetParserDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

