/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rvm;

import b.h.la;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandlerBase;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkData;

public class RvmVersionManagerHandler
extends RubyVersionManagerHandlerBase<RvmSdkData> {
    private static final Logger i;
    @NonNls
    private static final String l = "IS_RVM_SDK";
    @NonNls
    private static final String g = "RVM_GEMSET_NAME";
    @NonNls
    private static final String j = "RVM_IGNORE_GLOBAL";
    private static final String f = "rvm_path";
    private static final String m = "rvm_rubies_path";
    private static final String h = "rvm_gems_path";
    private static final String e = "gems";
    private static final String k = "rubies";
    static final String RVM_DEFAULT_RUBY = "default";
    static final List<String> RVM_SEARCH_PATHS_LIST;
    private static final long p;

    @Override
    @NotNull
    protected List<String> getAdditionalPathsToSearch() {
        List<String> list2 = RVM_SEARCH_PATHS_LIST;
        if (list2 == null) {
            RvmVersionManagerHandler.c(0);
        }
        return list2;
    }

    @Override
    @NotNull
    public String getVersionManagerExecutableName() {
        long l2 = p ^ 0x3595F056DF12L;
        if ("rvm" == null) {
            RvmVersionManagerHandler.c(1);
        }
        return "rvm";
    }

    @Override
    @NotNull
    public RvmSdkData createAdditionalData() {
        RvmSdkData rvmSdkData = new RvmSdkData(this);
        if (rvmSdkData == null) {
            RvmVersionManagerHandler.c(2);
        }
        return rvmSdkData;
    }

    @Override
    @NotNull
    protected List<String> processAvailableDistributionsOutput(@NotNull List<String> rawOutput) {
        if (rawOutput == null) {
            RvmVersionManagerHandler.c(3);
        }
        List list2 = ContainerUtil.filter(rawOutput, string -> {
            long l2 = p ^ 0x3521652A16EDL;
            return string != null && !StringUtil.endsWith((CharSequence)string, (CharSequence)"@global");
        });
        if (list2 == null) {
            RvmVersionManagerHandler.c(4);
        }
        return list2;
    }

    @Override
    @NotNull
    protected List<String> getAvailableDistributionsCommands(@NotNull String versionManagerPath) {
        long l2 = p ^ 0x302B5311177AL;
        if (versionManagerPath == null) {
            RvmVersionManagerHandler.c(5);
        }
        List<String> list2 = Arrays.asList(versionManagerPath, "list", "gemsets", "strings");
        if (list2 == null) {
            RvmVersionManagerHandler.c(6);
        }
        return list2;
    }

    @Override
    @Nullable
    protected RubyVersionManagerSdkData doLoadLegacy(@NotNull Element rootElement, @NotNull String interpreterPath) {
        long l2 = p ^ 0x4A685EFA6EAL;
        if (rootElement == null) {
            RvmVersionManagerHandler.c(7);
        }
        if (interpreterPath == null) {
            RvmVersionManagerHandler.c(8);
        }
        String string = rootElement.getAttributeValue(l);
        String string2 = rootElement.getAttributeValue(g);
        if (string != null && Boolean.valueOf(string).booleanValue() || string2 != null) {
            RvmSdkData rvmSdkData = this.createAdditionalData().withDistributionId(RvmVersionManagerHandler.getVersionFromInterpreterPath(interpreterPath), string2);
            rvmSdkData.withRVMIgnoreGlobalGemset(Boolean.valueOf(rootElement.getAttributeValue(j, "false")));
            return rvmSdkData;
        }
        return null;
    }

    @Override
    @NotNull
    public RvmSdkData createAdditionalData(@NotNull RubySdkInfo sdkInfo) {
        if (sdkInfo == null) {
            RvmVersionManagerHandler.c(9);
        }
        RvmSdkData rvmSdkData = ((RvmSdkData)super.createAdditionalData(sdkInfo)).withDistributionId(sdkInfo.getInterpreterHome().getName(), sdkInfo.getGemSet());
        if (rvmSdkData == null) {
            RvmVersionManagerHandler.c(10);
        }
        return rvmSdkData;
    }

    @Override
    @NotNull
    protected List<String> patchCommands(@NotNull String versionManagerPath, @NotNull String distributionId, @NotNull List<String> commandsToPatch) {
        long l2 = p ^ 0x524A05E47F95L;
        if (versionManagerPath == null) {
            RvmVersionManagerHandler.c(11);
        }
        if (distributionId == null) {
            RvmVersionManagerHandler.c(12);
        }
        if (commandsToPatch == null) {
            RvmVersionManagerHandler.c(13);
        }
        List<String> list2 = RvmVersionManagerHandler.getCommandsSequence(ContainerUtil.concat(Arrays.asList(versionManagerPath, distributionId, "do"), commandsToPatch));
        if (list2 == null) {
            RvmVersionManagerHandler.c(14);
        }
        return list2;
    }

    @NotNull
    public static RvmVersionManagerHandler getInstance() {
        RvmVersionManagerHandler rvmVersionManagerHandler = Objects.requireNonNull((RvmVersionManagerHandler)RubyVersionManagerHandler.findHandler(rubyVersionManagerHandler -> rubyVersionManagerHandler instanceof RvmVersionManagerHandler));
        if (rvmVersionManagerHandler == null) {
            RvmVersionManagerHandler.c(15);
        }
        return rvmVersionManagerHandler;
    }

    static {
        p = la.a(1948398101298098681L, -1699430031825952876L, MethodHandles.lookup().lookupClass()).a(279527156300431L);
        long l2 = p ^ 0x46973400DA73L;
        i = Logger.getInstance(RvmVersionManagerHandler.class);
        RVM_SEARCH_PATHS_LIST = Arrays.asList("~/.rvm/bin", "/usr/local/rvm/bin", "/usr/share/rvm/bin", "/opt/rvm/bin");
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = p ^ 0x2BED2E8BE097L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmVersionManagerHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawOutput";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandsToPatch";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPathsToSearch";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerExecutableName";
                break;
            }
            case 2: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalData";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmVersionManagerHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "processAvailableDistributionsOutput";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributionsCommands";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommands";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAvailableDistributionsOutput";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDistributionsCommands";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doLoadLegacy";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalData";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "patchCommands";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RvmEnvironment {
        @NotNull
        private final String b;
        @NotNull
        private final String a;
        private final AtomicNullableLazyValue<VirtualFile> c;
        private static final long d = la.a(7223025675010970929L, -7768704131567247217L, MethodHandles.lookup().lookupClass()).a(185244803990901L);

        RvmEnvironment(@NotNull Map<String, String> rvmEnvironment) {
            long l2 = d ^ 0x567307A409L;
            if (rvmEnvironment == null) {
                RvmEnvironment.a(0);
            }
            this.c = AtomicNullableLazyValue.createValue(() -> VfsUtil.findFileByIoFile((File)new File(this.getRubiesPath()), (boolean)false));
            this.b = rvmEnvironment.get(RvmVersionManagerHandler.m);
            this.a = rvmEnvironment.get(RvmVersionManagerHandler.h);
        }

        @NotNull
        String getRubiesPath() {
            String string = this.b;
            if (string == null) {
                RvmEnvironment.a(1);
            }
            return string;
        }

        @NotNull
        String getGemsPath() {
            String string = this.a;
            if (string == null) {
                RvmEnvironment.a(2);
            }
            return string;
        }

        @Nullable
        VirtualFile getRubiesVirtualFile() {
            return (VirtualFile)this.c.getValue();
        }

        @Nullable
        @Contract(value="null, _ -> null")
        static RvmEnvironment compute(@Nullable Path pathToRvm, @NotNull RubyRunner runner) {
            long l2 = d ^ 0x27408B69EB6AL;
            if (runner == null) {
                RvmEnvironment.a(3);
            }
            if (pathToRvm == null) {
                return null;
            }
            try {
                i.debug("Getting rvm environment from " + pathToRvm.toString());
                GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{pathToRvm.toString(), RvmVersionManagerHandler.RVM_DEFAULT_RUBY, "do", "ruby", "-e", "ENV.each{|k,v| print %Q<#{k}=#{v}\\0>}"});
                ProcessOutput processOutput = runner.execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create("bash", "-lc", generalCommandLine.getCommandLineString()).inSameThread(30, RBundle.message((String)"version.manager.rvm.fetching.environment")));
                assert (processOutput != null);
                if (processOutput.getExitCode() != 0) {
                    i.warn("Error getting rvm environment from script, error code " + processOutput.getExitCode() + "; STDOUT: " + processOutput.getStdout() + "; STDERR: " + processOutput.getStderr());
                    return null;
                }
                Map map = EnvironmentUtil.parseEnv((String[])processOutput.getStdout().split("\u0000"));
                String string = (String)map.get(RvmVersionManagerHandler.h);
                String string2 = (String)map.get(RvmVersionManagerHandler.m);
                String string3 = (String)map.get(RvmVersionManagerHandler.f);
                if (StringUtil.isEmpty((String)string2) && StringUtil.isNotEmpty((String)string3)) {
                    string2 = FileUtil.toSystemIndependentName((String)Paths.get(string3, new String[0]).resolve(RvmVersionManagerHandler.k).toString());
                    i.warn("rvm_rubies_path(" + string2 + ") inferred from " + RvmVersionManagerHandler.f + "(" + string3 + ")");
                    map.put(RvmVersionManagerHandler.m, string2);
                }
                if (StringUtil.isEmpty((String)string) && StringUtil.isNotEmpty((String)string2)) {
                    string = FileUtil.toSystemIndependentName((String)Paths.get(string2, new String[0]).getParent().resolve(RvmVersionManagerHandler.e).toString());
                    i.warn("rvm_gems_path(" + string + ") inferred from " + RvmVersionManagerHandler.m + "(" + string2 + ")");
                    map.put(RvmVersionManagerHandler.h, string);
                }
                if (StringUtil.isEmpty((String)string2) || StringUtil.isEmpty((String)string)) {
                    i.warn("RVM environment is not good:\n" + map);
                    i.warn("Inferring paths from the path to RVM " + pathToRvm);
                    Path path = pathToRvm.getParent();
                    if (path == null) {
                        i.warn("No bin path in " + pathToRvm.toString());
                        return null;
                    }
                    Path path2 = path.getParent();
                    if (path2 == null) {
                        i.warn("No rvm root path in " + pathToRvm.toString());
                        return null;
                    }
                    string2 = FileUtil.toSystemIndependentName((String)path2.resolve(RvmVersionManagerHandler.k).toString());
                    i.warn("rvm_rubies_path(" + string2 + ") inferred from path to rvm executable (" + pathToRvm + ")");
                    map.put(RvmVersionManagerHandler.m, string2);
                    string = FileUtil.toSystemIndependentName((String)path2.resolve(RvmVersionManagerHandler.e).toString());
                    i.warn("rvm_gems_path(" + string + ") inferred from path to rvm executable (" + pathToRvm + ")");
                    map.put(RvmVersionManagerHandler.h, string);
                }
                return new RvmEnvironment(map);
            }
            catch (Exception exception) {
                i.warn("Error getting rvm environment", (Throwable)exception);
                return null;
            }
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = d ^ 0x439F9CD4A3CBL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rvmEnvironment";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmVersionManagerHandler$RvmEnvironment";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmVersionManagerHandler$RvmEnvironment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRubiesPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemsPath";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

