/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger;

import b.h.la;
import com.google.common.collect.Sets;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValueFactory;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyExpressionCodeFragment;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.impl.RControlFlowBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RNameUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.rubyforge.debugcommons.model.RubyVariable;

public class RubyDebuggerSupportUtils {
    private static final long a = la.a(-5913898240014674101L, 5202031683352915899L, MethodHandles.lookup().lookupClass()).a(96759571223912L);

    private RubyDebuggerSupportUtils() {
    }

    public static Document createDocument(@NotNull String text, @NotNull Project project, @Nullable VirtualFile contextVirtualFile, int contextOffset) {
        if (text == null) {
            RubyDebuggerSupportUtils.a(0);
        }
        if (project == null) {
            RubyDebuggerSupportUtils.a(1);
        }
        RPsiElement rPsiElement = null;
        if (contextVirtualFile != null) {
            rPsiElement = RubyDebuggerSupportUtils.getContextElement(contextVirtualFile, contextOffset, project);
        }
        RubyExpressionCodeFragment rubyExpressionCodeFragment = RubyElementFactory.createExpressionCodeFragment(project, text, (PsiElement)rPsiElement, true);
        return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)rubyExpressionCodeFragment);
    }

    @Nullable
    public static RPsiElement getContextElement(@NotNull VirtualFile virtualFile, int offset, @NotNull Project project) {
        if (virtualFile == null) {
            RubyDebuggerSupportUtils.a(2);
        }
        if (project == null) {
            RubyDebuggerSupportUtils.a(3);
        }
        if (!virtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        FileViewProvider fileViewProvider = PsiManager.getInstance((Project)project).findViewProvider(virtualFile);
        if (fileViewProvider == null) {
            return null;
        }
        PsiFile psiFile = fileViewProvider.getPsi((Language)RubyLanguage.INSTANCE);
        if (psiFile == null) {
            return null;
        }
        if (offset >= 0 && offset < document.getTextLength()) {
            int n2 = document.getLineEndOffset(document.getLineNumber(offset));
            do {
                PsiElement psiElement;
                if ((psiElement = psiFile.findElementAt(offset)) != null) {
                    if (!(psiElement instanceof PsiWhiteSpace) && !(psiElement instanceof PsiComment) && psiElement.getNode().getElementType() instanceof RubyElementType) {
                        return RControlFlowBuilder.getControlFlowNodeElement(psiElement);
                    }
                } else {
                    return null;
                }
                offset = psiElement.getTextRange().getEndOffset() + 1;
            } while (offset < n2);
        }
        return null;
    }

    @Nullable
    public static TextRange getExpressionAtOffset(@NotNull Project project, @NotNull Document document, int offset) {
        RIdentifier rIdentifier;
        PsiFile psiFile;
        if (project == null) {
            RubyDebuggerSupportUtils.a(4);
        }
        if (document == null) {
            RubyDebuggerSupportUtils.a(5);
        }
        if ((psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) == null) {
            return null;
        }
        RExpression rExpression = RubyPsiUtil.getCoveringExpression(psiFile.findElementAt(offset));
        if (rExpression == null) {
            return null;
        }
        if (rExpression instanceof RIdentifier && ((rIdentifier = (RIdentifier)rExpression).isParameterDeclaration() || rIdentifier.isLocalVariable())) {
            return rIdentifier.getTextRange();
        }
        if (rExpression instanceof RField || rExpression instanceof RGlobalVariable) {
            return rExpression.getTextRange();
        }
        if (TextUtil.isCIDOrColonQualifiedReference(rExpression.getText())) {
            return rExpression.getTextRange();
        }
        return null;
    }

    public static void addRubyVariablesToNode(Project project, XSourcePosition position, @NotNull XCompositeNode node, @NotNull RubyVariable[] variables, @NotNull RubyStackFrame frame, boolean canEvaluate) {
        if (node == null) {
            RubyDebuggerSupportUtils.a(6);
        }
        if (variables == null) {
            RubyDebuggerSupportUtils.a(7);
        }
        if (frame == null) {
            RubyDebuggerSupportUtils.a(8);
        }
        RubyDebuggerSupportUtils.addRubyVariablesToNode(project, position, node, variables, frame, canEvaluate, false);
    }

    public static void addRubyVariablesToNode(Project project, XSourcePosition position, @NotNull XCompositeNode node, @NotNull RubyVariable[] variables, @NotNull RubyStackFrame frame, boolean canEvaluate, boolean alreadySorted) {
        if (node == null) {
            RubyDebuggerSupportUtils.a(9);
        }
        if (variables == null) {
            RubyDebuggerSupportUtils.a(10);
        }
        if (frame == null) {
            RubyDebuggerSupportUtils.a(11);
        }
        RubyDebuggerSupportUtils.addRubyVariablesToNode(project, position, node, variables, frame, canEvaluate, alreadySorted, true);
    }

    public static void addRubyVariablesToNode(Project project, XSourcePosition position, @NotNull XCompositeNode node, @NotNull RubyVariable[] variables, @NotNull RubyStackFrame frame, boolean canEvaluate, boolean alreadySorted, boolean isLastChildren) {
        if (node == null) {
            RubyDebuggerSupportUtils.a(12);
        }
        if (variables == null) {
            RubyDebuggerSupportUtils.a(13);
        }
        if (frame == null) {
            RubyDebuggerSupportUtils.a(14);
        }
        if (node.isObsolete()) {
            return;
        }
        XValueChildrenList xValueChildrenList = new XValueChildrenList();
        node.setAlreadySorted(alreadySorted);
        for (RubyVariable rubyVariable : variables) {
            String string = RubyDebuggerSupportUtils.convertToIdeEncoding(rubyVariable.getName());
            if (StringUtil.isEmptyOrSpaces((String)string)) continue;
            xValueChildrenList.add(string, RubyDebugValueFactory.create(project, position, frame, string, rubyVariable, canEvaluate));
        }
        node.addChildren(xValueChildrenList, isLastChildren);
    }

    public static void collectFieldsMentionedInContext(@NotNull RContainer scope, final @NotNull List<? super String> collector) {
        if (scope == null) {
            RubyDebuggerSupportUtils.a(15);
        }
        if (collector == null) {
            RubyDebuggerSupportUtils.a(16);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final HashSet hashSet = Sets.newHashSet();
        scope.acceptChildren((PsiElementVisitor)new RubyDebuggerScopeVisitor(scope){

            @Override
            public void visitRClassVariable(RClassVariable rClassVariable) {
                String string = rClassVariable.getText();
                if (hashSet.add(string)) {
                    collector.add(string);
                }
            }

            @Override
            public void visitRInstanceVariable(RInstanceVariable rInstanceVariable) {
                String string = rInstanceVariable.getText();
                if (hashSet.add(string)) {
                    collector.add(string);
                }
            }
        });
    }

    public static Set<String> addGlobalsMentionedInContext(@NotNull RContainer scope, final @NotNull List<? super String> collector) {
        if (scope == null) {
            RubyDebuggerSupportUtils.a(17);
        }
        if (collector == null) {
            RubyDebuggerSupportUtils.a(18);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final HashSet hashSet = Sets.newHashSet();
        scope.acceptChildren((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            @Override
            public void visitRGlobalVariable(RGlobalVariable rGlobalVariable) {
                String string = rGlobalVariable.getText();
                if (hashSet.add(string)) {
                    collector.add(string);
                }
            }
        });
        return hashSet;
    }

    public static void collectContextInfoFromProviders(@NotNull RContainer scope, XSourcePosition xSourcePosition, @NotNull List<? super String> collector) {
        if (scope == null) {
            RubyDebuggerSupportUtils.a(19);
        }
        if (collector == null) {
            RubyDebuggerSupportUtils.a(20);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashSet hashSet = Sets.newHashSet();
        for (ContextInfoProvider contextInfoProvider : (ContextInfoProvider[])ContextInfoProvider.EP_NAME.getExtensions()) {
            List<String> list2 = contextInfoProvider.getEvaluateExpression(scope, xSourcePosition);
            for (String string : list2) {
                if (!hashSet.add(string)) continue;
                collector.add(string);
            }
        }
    }

    public static void collectConstantsMentionedInContext(@NotNull RContainer scope, final @NotNull List<? super String> collector) {
        if (scope == null) {
            RubyDebuggerSupportUtils.a(21);
        }
        if (collector == null) {
            RubyDebuggerSupportUtils.a(22);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final HashSet hashSet = Sets.newHashSet();
        scope.acceptChildren((PsiElementVisitor)new RubyDebuggerScopeVisitor(scope){

            @Override
            public void visitRReference(RReference reference) {
                String string = this.a(reference);
                if (string != null) {
                    if (hashSet.add(string)) {
                        collector.add(string);
                    }
                    return;
                }
                RPsiElement rPsiElement = reference.getReceiver();
                if (rPsiElement != null) {
                    rPsiElement.accept((PsiElementVisitor)this);
                }
            }

            @Override
            public void visitRConstant(RConstant rConstant) {
                String string = rConstant.getText();
                if (hashSet.add(string)) {
                    collector.add(string);
                }
            }

            @Nullable
            private String a(RReference rReference) {
                FQN fQN = RNameUtilCore.getPath((PsiElement)rReference);
                for (String string : fQN.asList()) {
                    if (TextUtil.isConstId(string)) continue;
                    return null;
                }
                return fQN.getFullPath();
            }
        });
    }

    public static String convertToIdeEncoding(String value) {
        return new String(value.getBytes(), EncodingManager.getInstance().getDefaultCharset());
    }

    public static void invalidateSessionFrames(XDebugSession session) {
        XStackFrame xStackFrame;
        if (session != null && (xStackFrame = session.getCurrentStackFrame()) instanceof RubyStackFrame) {
            ((RubyStackFrame)xStackFrame).getRubyThread().invalidateFrames();
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x6A3461192126L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebuggerSupportUtils";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createDocument";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpressionAtOffset";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addRubyVariablesToNode";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "collectFieldsMentionedInContext";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "addGlobalsMentionedInContext";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "collectContextInfoFromProviders";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "collectConstantsMentionedInContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class RubyDebuggerScopeVisitor
    extends RubyRecursiveElementVisitor {
        private final RContainer a;

        RubyDebuggerScopeVisitor(RContainer scope) {
            this.a = scope;
        }

        @Override
        public void visitRClass(RClass rClass) {
            if (rClass != this.a) {
                return;
            }
            super.visitRClass(rClass);
        }

        @Override
        public void visitRModule(RModule rModule) {
            if (rModule != this.a) {
                return;
            }
            super.visitRModule(rModule);
        }
    }

    public static interface ContextInfoProvider {
        public static final ExtensionPointName<ContextInfoProvider> EP_NAME;

        @NotNull
        public List<String> getEvaluateExpression(RContainer var1, XSourcePosition var2);

        static {
            long l2 = la.a(-9075865708795298815L, 2174803080548055742L, MethodHandles.lookup().lookupClass()).a(122391934639316L) ^ 0x412F6752D239L;
            EP_NAME = ExtensionPointName.create((String)"org.jetbrains.plugins.ruby.debug.infoProvider");
        }
    }
}

