/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import b.h.la;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.dupLocator.index.DuplicatesIndex;
import com.intellij.dupLocator.index.a;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntLongHashMap;
import gnu.trove.TIntObjectHashMap;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesInspectionBase
extends LocalInspectionTool {
    public boolean myFilterOutGeneratedCode;
    private static final int a = 3;
    private static final long c = la.a(7011140901710576618L, -539259138954158232L, MethodHandles.lookup().lookupClass()).a(223371038826605L);

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager manager, boolean isOnTheFly) {
        VirtualFile virtualFile;
        long l2 = c ^ 0x7FCB36C4DC93L;
        if (psiFile == null) {
            DuplicatesInspectionBase.a(0);
        }
        if (manager == null) {
            DuplicatesInspectionBase.a(1);
        }
        if (!((virtualFile = psiFile.getVirtualFile()) instanceof VirtualFileWithId) || !DuplicatesIndex.ourEnabled) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        DuplicatesProfile duplicatesProfile = DuplicatesIndex.findDuplicatesProfile(psiFile.getFileType());
        if (duplicatesProfile == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        FileASTNode fileASTNode = psiFile.getNode();
        boolean bl2 = duplicatesProfile instanceof LightDuplicateProfile && fileASTNode.getElementType() instanceof ILightStubFileElementType;
        Project project = psiFile.getProject();
        DuplicatedCodeProcessor<?> duplicatedCodeProcessor = bl2 ? this.a(fileASTNode, virtualFile, (LightDuplicateProfile)((Object)duplicatesProfile), project) : this.a(psiFile, virtualFile, duplicatesProfile, project);
        if (duplicatedCodeProcessor == null) {
            return null;
        }
        SmartList smartList = new SmartList();
        VirtualFile virtualFile2 = project.getBaseDir();
        for (Map.Entry<Integer, TextRange> entry : duplicatedCodeProcessor.reportedRanges.entrySet()) {
            LocalQuickFix localQuickFix;
            Integer n2 = entry.getKey();
            if (!bl2 && duplicatedCodeProcessor.fragmentSize.get(n2.intValue()) < 3) continue;
            VirtualFile virtualFile3 = (VirtualFile)duplicatedCodeProcessor.reportedFiles.get(n2.intValue());
            String string = null;
            if (virtualFile3.equals(virtualFile)) {
                string = "this file";
            } else if (virtualFile2 != null) {
                string = VfsUtilCore.getRelativePath((VirtualFile)virtualFile3, (VirtualFile)virtualFile2);
            }
            if (string == null) {
                string = virtualFile3.getPath();
            }
            String string2 = "Found duplicated code in " + string;
            PsiElement psiElement = (PsiElement)duplicatedCodeProcessor.reportedPsi.get(n2.intValue());
            TextRange textRange = entry.getValue();
            int n3 = duplicatedCodeProcessor.reportedOffsetInOtherFiles.get(n2.intValue());
            LocalQuickFix localQuickFix2 = isOnTheFly ? this.createNavigateToDupeFix(virtualFile3, n3) : null;
            long l3 = duplicatedCodeProcessor.fragmentHash.get(n2.intValue());
            int n4 = (int)(l3 >> 32);
            LocalQuickFix localQuickFix3 = isOnTheFly && l3 != 0L ? this.createShowOtherDupesFix(virtualFile, n2, (int)l3, n4) : null;
            boolean bl3 = Registry.is((String)"duplicates.inspection.only.extractable");
            LocalQuickFix localQuickFix4 = localQuickFix = (isOnTheFly || bl3) && l3 != 0L ? this.createExtractMethodFix(psiElement, textRange, (int)l3, n4) : null;
            if (bl3) {
                if (localQuickFix == null) {
                    return null;
                }
                if (!isOnTheFly) {
                    localQuickFix = null;
                }
            }
            ProblemDescriptor problemDescriptor = manager.createProblemDescriptor(psiElement, textRange, string2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{localQuickFix2, localQuickFix3, localQuickFix});
            smartList.add((Object)problemDescriptor);
        }
        return smartList.isEmpty() ? null : (ProblemDescriptor[])smartList.toArray((Object[])ProblemDescriptor.EMPTY_ARRAY);
    }

    private DuplicatedCodeProcessor<?> a(FileASTNode fileASTNode, VirtualFile virtualFile, LightDuplicateProfile lightDuplicateProfile, Project project) {
        Ref ref = new Ref();
        LighterAST lighterAST2 = fileASTNode.getLighterAST();
        lightDuplicateProfile.process(lighterAST2, (n2, n3, lighterAST, lighterASTNodeArray) -> {
            DuplicatedCodeProcessor duplicatedCodeProcessor = (DuplicatedCodeProcessor)ref.get();
            if (duplicatedCodeProcessor == null) {
                duplicatedCodeProcessor = new LightDuplicatedCodeProcessor((TreeBackedLighterAST)lighterAST, virtualFile, project, null);
                ref.set((Object)duplicatedCodeProcessor);
            }
            duplicatedCodeProcessor.process(n2, n3, lighterASTNodeArray[0]);
        });
        return (DuplicatedCodeProcessor)ref.get();
    }

    private DuplicatedCodeProcessor<?> a(PsiFile psiFile, VirtualFile virtualFile, DuplicatesProfile duplicatesProfile, Project project) {
        DuplocatorState duplocatorState = duplicatesProfile.getDuplocatorState(psiFile.getLanguage());
        Ref ref = new Ref();
        DuplocateVisitor duplocateVisitor = duplicatesProfile.createVisitor((n2, n3, psiFragment) -> {
            if (!DuplicatesIndex.isIndexedFragment(psiFragment, n3, duplicatesProfile, duplocatorState)) {
                return;
            }
            DuplicatedCodeProcessor duplicatedCodeProcessor = (DuplicatedCodeProcessor)ref.get();
            if (duplicatedCodeProcessor == null) {
                duplicatedCodeProcessor = new OldDuplicatedCodeProcessor(virtualFile, project, null);
                ref.set((Object)duplicatedCodeProcessor);
            }
            duplicatedCodeProcessor.process(n2, 0, psiFragment);
        }, true);
        duplocateVisitor.visitNode((PsiElement)psiFile);
        return (DuplicatedCodeProcessor)ref.get();
    }

    protected LocalQuickFix createNavigateToDupeFix(@NotNull VirtualFile file, int offsetInOtherFile) {
        if (file == null) {
            DuplicatesInspectionBase.a(2);
        }
        return null;
    }

    protected LocalQuickFix createShowOtherDupesFix(VirtualFile file, int offset, int hash, int hash2) {
        return null;
    }

    protected LocalQuickFix createExtractMethodFix(@NotNull PsiElement targetElement, @Nullable TextRange rangeInElement, int hash, int hash2) {
        if (targetElement == null) {
            DuplicatesInspectionBase.a(3);
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x70CDE82238CEL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/index/DuplicatesInspectionBase";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createNavigateToDupeFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createExtractMethodFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static abstract class DuplicatedCodeProcessor<T>
    implements FileBasedIndex.ValueProcessor<TIntArrayList> {
        final TreeMap<Integer, TextRange> reportedRanges = new TreeMap();
        final TIntObjectHashMap<VirtualFile> reportedFiles = new TIntObjectHashMap();
        final TIntObjectHashMap<PsiElement> reportedPsi = new TIntObjectHashMap();
        final TIntIntHashMap reportedOffsetInOtherFiles = new TIntIntHashMap();
        final TIntIntHashMap fragmentSize = new TIntIntHashMap();
        final TIntLongHashMap fragmentHash = new TIntLongHashMap();
        final VirtualFile virtualFile;
        final Project project;
        final FileIndex myFileIndex;
        final boolean mySkipGeneratedCode;
        final boolean myFileWithinGeneratedCode;
        T myNode;
        int myHash;
        int myHash2;
        private static final long b = la.a(-220722918850491245L, -535853318148068771L, MethodHandles.lookup().lookupClass()).a(147383902867197L);

        DuplicatedCodeProcessor(VirtualFile file, Project project, boolean skipGeneratedCode) {
            this.virtualFile = file;
            this.project = project;
            this.myFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            this.mySkipGeneratedCode = skipGeneratedCode;
            this.myFileWithinGeneratedCode = skipGeneratedCode && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file, (Project)project);
        }

        void process(int hash, int hash2, T node) {
            ProgressManager.checkCanceled();
            this.myNode = node;
            this.myHash = hash;
            this.myHash2 = hash2;
            FileBasedIndex.getInstance().processValues(DuplicatesIndex.NAME, (Object)hash, null, (FileBasedIndex.ValueProcessor)this, GlobalSearchScope.projectScope((Project)this.project));
        }

        public boolean process(@NotNull VirtualFile file, TIntArrayList list2) {
            if (file == null) {
                DuplicatedCodeProcessor.a(0);
            }
            int n2 = list2.size();
            for (int i10 = 0; i10 < n2; i10 += 2) {
                ProgressManager.checkCanceled();
                if (list2.getQuick(i10 + 1) != this.myHash2) continue;
                int n3 = list2.getQuick(i10);
                if (this.myFileIndex.isInSourceContent(this.virtualFile)) {
                    if (!this.myFileIndex.isInSourceContent(file)) {
                        return true;
                    }
                    if (!TestSourcesFilter.isTestSources((VirtualFile)this.virtualFile, (Project)this.project) && TestSourcesFilter.isTestSources((VirtualFile)file, (Project)this.project)) {
                        return true;
                    }
                    if (this.mySkipGeneratedCode && !this.myFileWithinGeneratedCode && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file, (Project)this.project)) {
                        return true;
                    }
                } else if (this.myFileIndex.isInSourceContent(file)) {
                    return true;
                }
                int n4 = this.getStartOffset(this.myNode);
                int n5 = this.getEndOffset(this.myNode);
                if (file.equals(this.virtualFile) && n3 >= n4 && n3 < n5) continue;
                PsiElement psiElement = this.getPsi(this.myNode);
                TextRange textRange = this.getRangeInElement(this.myNode);
                Integer n6 = n4;
                SortedMap<Integer, TextRange> sortedMap = this.reportedRanges.subMap(n6, n5);
                int n7 = !sortedMap.isEmpty() ? 0 : 1;
                Iterator<Integer> iterator = sortedMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Integer n8 = iterator.next();
                    iterator.remove();
                    this.reportedFiles.remove(n8.intValue());
                    this.reportedOffsetInOtherFiles.remove(n8.intValue());
                    this.reportedPsi.remove(n8.intValue());
                    n7 += this.fragmentSize.remove(n8.intValue());
                }
                this.reportedRanges.put(n6, textRange);
                this.reportedFiles.put(n6.intValue(), (Object)file);
                this.reportedOffsetInOtherFiles.put(n6.intValue(), n3);
                this.reportedPsi.put(n6.intValue(), (Object)psiElement);
                this.fragmentSize.put(n6.intValue(), n7);
                if (n7 >= 3 || this.isLightProfile()) {
                    this.fragmentHash.put(n6.intValue(), (long)this.myHash & 0xFFFFFFFFL | (long)this.myHash2 << 32);
                }
                return false;
            }
            return true;
        }

        protected abstract TextRange getRangeInElement(T var1);

        protected abstract PsiElement getPsi(T var1);

        protected abstract int getStartOffset(T var1);

        protected abstract int getEndOffset(T var1);

        protected abstract boolean isLightProfile();

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x5784FF4A11DEL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dupLocator/index/DuplicatesInspectionBase$DuplicatedCodeProcessor", "process"));
        }
    }

    class OldDuplicatedCodeProcessor
    extends DuplicatedCodeProcessor<PsiFragment> {
        private OldDuplicatedCodeProcessor(VirtualFile file, Project project) {
            super(file, project, DuplicatesInspectionBase.this.myFilterOutGeneratedCode);
        }

        @Override
        protected TextRange getRangeInElement(PsiFragment node) {
            PsiElement[] psiElementArray = node.getElements();
            TextRange textRange = null;
            if (psiElementArray.length > 1) {
                PsiElement psiElement = psiElementArray[psiElementArray.length - 1];
                textRange = new TextRange(psiElementArray[0].getStartOffsetInParent(), psiElement.getStartOffsetInParent() + psiElement.getTextLength());
            }
            return textRange;
        }

        @Override
        protected PsiElement getPsi(PsiFragment node) {
            PsiElement[] psiElementArray = node.getElements();
            return psiElementArray.length > 1 ? psiElementArray[0].getParent() : psiElementArray[0];
        }

        @Override
        protected int getStartOffset(PsiFragment node) {
            return node.getStartOffset();
        }

        @Override
        protected int getEndOffset(PsiFragment node) {
            return node.getEndOffset();
        }

        @Override
        protected boolean isLightProfile() {
            return false;
        }

        /* synthetic */ OldDuplicatedCodeProcessor(VirtualFile x1, Project x2, a x3) {
            this(x1, x2);
        }
    }

    private class LightDuplicatedCodeProcessor
    extends DuplicatedCodeProcessor<LighterASTNode> {
        private final TreeBackedLighterAST a;
        private static final long c = la.a(-366906010415301051L, -2905087911587173723L, MethodHandles.lookup().lookupClass()).a(10128840608545L);

        private LightDuplicatedCodeProcessor(TreeBackedLighterAST ast, VirtualFile file, Project project) {
            if (ast == null) {
                LightDuplicatedCodeProcessor.b(0);
            }
            super(file, project, DuplicatesInspectionBase.this.myFilterOutGeneratedCode);
            this.a = ast;
        }

        @Override
        protected TextRange getRangeInElement(LighterASTNode node) {
            return null;
        }

        @Override
        protected PsiElement getPsi(LighterASTNode node) {
            return this.a.unwrap(node).getPsi();
        }

        @Override
        protected int getStartOffset(LighterASTNode node) {
            return node.getStartOffset();
        }

        @Override
        protected int getEndOffset(LighterASTNode node) {
            return node.getEndOffset();
        }

        @Override
        protected boolean isLightProfile() {
            return true;
        }

        /* synthetic */ LightDuplicatedCodeProcessor(TreeBackedLighterAST x1, VirtualFile x2, Project x3, a x4) {
            this(x1, x2, x3);
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = c ^ 0xD3AC5C65D3AL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "com/intellij/dupLocator/index/DuplicatesInspectionBase$LightDuplicatedCodeProcessor", "<init>"));
        }
    }
}

