/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.navigation;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.testFramework.JsTestFileByTestNameIndex;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestNavigationItem
implements NavigationItem {
    private final String myName;
    private final PsiElement myElement;

    public JsTestNavigationItem(@NotNull JsTestFqn fqn, @NotNull PsiElement element) {
        if (fqn == null) {
            JsTestNavigationItem.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JsTestNavigationItem.$$$reportNull$$$0(1);
        }
        this.myName = fqn.getPresentableName();
        this.myElement = element;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return JsTestNavigationItem.this.myName;
            }

            @Nullable
            public String getLocationString() {
                return JsTestNavigationItem.this.myElement.getContainingFile().getName();
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                Icon icon = JsTestNavigationItem.this.myElement.getContainingFile().getIcon(0);
                return icon != null ? icon : JsTestNavigationItem.this.myElement.getIcon(0);
            }
        };
    }

    public void navigate(boolean requestFocus) {
        VirtualFile file2;
        Navigatable descriptor2 = null;
        if (this.myElement instanceof JSLiteralExpression && (file2 = this.myElement.getContainingFile().getVirtualFile()) != null) {
            descriptor2 = PsiNavigationSupport.getInstance().createNavigatable(this.myElement.getProject(), file2, this.myElement.getTextOffset() + 1);
        }
        if (descriptor2 == null) {
            descriptor2 = PsiNavigationSupport.getInstance().getDescriptor(this.myElement);
        }
        if (descriptor2 != null) {
            descriptor2.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this.myElement);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Nullable
    public static JsTestNavigationItem tryCreate(@NotNull String indexKey, @NotNull Project project) {
        PsiElement element;
        JsTestFqn fqn;
        if (indexKey == null) {
            JsTestNavigationItem.$$$reportNull$$$0(2);
        }
        if (project == null) {
            JsTestNavigationItem.$$$reportNull$$$0(3);
        }
        if ((fqn = JsTestFileByTestNameIndex.toFqn((String)indexKey)) == null) {
            return null;
        }
        List files = JsTestFileByTestNameIndex.findFilesByKey((String)indexKey, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        VirtualFile file2 = (VirtualFile)ContainerUtil.getFirstItem((Collection)files);
        if (file2 == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        if (psiFile instanceof JSFile && (element = fqn.findNavigationElement((JSFile)psiFile)) != null) {
            return new JsTestNavigationItem(fqn, element);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/testing/navigation/JsTestNavigationItem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "tryCreate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

