/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;
import org.jetbrains.plugins.cucumber.psi.GherkinPsiUtil;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFileImpl;
import org.jetbrains.plugins.ruby.cucumber.CucumberUtil;
import org.jetbrains.plugins.ruby.cucumber.run.BaseCucumberRunConfiguration;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.testing.PreloadedTestRunConfiguration;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

public abstract class BaseCucumberRunConfigurationProducer
extends RunConfigurationProducer<BaseCucumberRunConfiguration> {
    protected abstract boolean isSameRunConfigurationType(RunConfiguration var1);

    protected abstract void applyExtensionsToConfiguration(Location var1, RunConfiguration var2);

    protected abstract boolean isApplicable(PsiElement var1, Module var2);

    public BaseCucumberRunConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    public boolean isConfigurationFromContext(BaseCucumberRunConfiguration configuration, ConfigurationContext context) {
        String filter;
        if (context == null) {
            return false;
        }
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        final PsiElement locationElement = location.getPsiElement();
        if (!this.isApplicable(locationElement, context.getModule())) {
            return false;
        }
        VirtualFile vFile = location.getVirtualFile();
        VirtualFile file = BaseCucumberRunConfigurationProducer.getFeatureFileBy(vFile, locationElement);
        if (file == null) {
            return false;
        }
        String featurePath = file.getPath();
        NullableLazyValue<String> featureNameFilter = new NullableLazyValue<String>(){

            protected String compute() {
                return CucumberUtil.determineCurrentScenarioName(locationElement);
            }
        };
        if (configuration == null || !this.isSameRunConfigurationType(configuration)) {
            return false;
        }
        if (configuration.getTestType() != AbstractRubyTestsRunConfigurationParams.TestType.TEST_SCRIPT) {
            return false;
        }
        if (!featurePath.equals(configuration.getTestScriptPath())) {
            return false;
        }
        String candidateFeatureElemFilter = configuration.getFeatureElementNameFilter();
        return candidateFeatureElemFilter.equals(filter = StringUtil.notNullize((String)((String)featureNameFilter.getValue())));
    }

    protected boolean setupConfigurationFromContext(BaseCucumberRunConfiguration configuration, ConfigurationContext context, Ref sourceElement) {
        if (context == null) {
            return false;
        }
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        PsiElement locationElement = location.getPsiElement();
        if (!this.isApplicable(locationElement, context.getModule())) {
            return false;
        }
        Project project = location.getProject();
        VirtualFile file = BaseCucumberRunConfigurationProducer.getFeatureFileBy(location.getVirtualFile(), locationElement);
        if (file == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return false;
        }
        configuration.setModule(module);
        String scenarioName = CucumberUtil.determineCurrentScenarioName(locationElement);
        String confName = scenarioName != null ? "Scenario: " + scenarioName : file.getName();
        configuration.setName(confName);
        BaseCucumberRunConfigurationProducer.setWorkingDirectory(file, configuration, project, module);
        PreLoadUtil.setPreloadServersIfRunning((Module)module, (SupportedTestFramework)SupportedTestFramework.CUCUMBER, (PreloadedTestRunConfiguration)configuration);
        this.initCucumberSpecificSettings(configuration, project, module, file, scenarioName);
        this.applyExtensionsToConfiguration(location, configuration);
        return true;
    }

    protected void initCucumberSpecificSettings(@NotNull BaseCucumberRunConfiguration conf, @NotNull Project project, @Nullable Module module, @NotNull VirtualFile file, @Nullable String scenarioName) {
        if (conf == null) {
            BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (project == null) {
            BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (file == null) {
            BaseCucumberRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        conf.setTestType(AbstractRubyTestsRunConfigurationParams.TestType.TEST_SCRIPT);
        conf.setTestScriptPath(file.getPath());
        PreLoadUtil.setPreloadServersIfRunning((Module)module, (SupportedTestFramework)SupportedTestFramework.CUCUMBER, (PreloadedTestRunConfiguration)conf);
        JRubySdkUtil.enableObjectSpaceIfNotOverriddenByUser((AbstractRubyRunConfigurationParams)conf);
        if (!StringUtil.isEmpty((String)scenarioName)) {
            conf.setFeatureElementNameFilter(scenarioName);
        }
    }

    @Nullable
    private static VirtualFile getFeatureFileBy(VirtualFile file, PsiElement locationElement) {
        GherkinFileImpl containingFile = GherkinPsiUtil.getGherkinFile((PsiElement)locationElement);
        if (containingFile == null || file == null) {
            return null;
        }
        assert (file.getFileType() == GherkinFileType.INSTANCE);
        return file;
    }

    public static void setWorkingDirectory(VirtualFile file, AbstractRubyRunConfigurationParams templateConfiguration, Project project, Module module) {
        String dir;
        if (!StringUtil.isEmptyOrSpaces((String)templateConfiguration.getWorkingDirectory())) {
            return;
        }
        if (module != null && RailsFacetUtil.hasRailsSupport((Module)module)) {
            dir = RailsFacetUtil.getRailsAppHomeDirPath((Module)module);
        } else {
            VirtualFile featuresFolder = null;
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            for (VirtualFile parent = file.getParent(); parent != null && fileIndex.isInContent(parent); parent = parent.getParent()) {
                if (!parent.isDirectory() || !parent.getName().equals("features")) continue;
                featuresFolder = parent;
                break;
            }
            if (featuresFolder == null) {
                VirtualFile parentDir = file.getParent();
                dir = parentDir != null ? parentDir.getPath() : null;
            } else {
                VirtualFile parentForFeatures = featuresFolder.getParent();
                if (parentForFeatures != null && fileIndex.isInContent(parentForFeatures)) {
                    dir = parentForFeatures.getPath();
                } else {
                    VirtualFile parentDir = file.getParent();
                    String string = dir = parentDir != null ? parentDir.getPath() : null;
                }
            }
        }
        if (dir != null) {
            templateConfiguration.setWorkingDirectory(dir);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "conf";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/cucumber/run/BaseCucumberRunConfigurationProducer";
        objectArray[2] = "initCucumberSpecificSettings";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

