/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.PassThroughIdeFocusManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeFocusManager
implements FocusRequestor {
    public ActionCallback requestFocusInProject(@NotNull Component c, @Nullable Project project) {
        if (c == null) {
            IdeFocusManager.$$$reportNull$$$0(0);
        }
        return this.requestFocus(c, false);
    }

    @Nullable
    public abstract JComponent getFocusTargetFor(@NotNull JComponent var1);

    public abstract void doWhenFocusSettlesDown(@NotNull Runnable var1);

    public abstract void doWhenFocusSettlesDown(@NotNull Runnable var1, @NotNull ModalityState var2);

    public abstract void doWhenFocusSettlesDown(@NotNull ExpirableRunnable var1);

    @Nullable
    public abstract Component getFocusedDescendantFor(Component var1);

    @Deprecated
    public void typeAheadUntil(ActionCallback done2) {
        this.typeAheadUntil(done2, "No cause has been provided");
    }

    public void typeAheadUntil(ActionCallback done2, @NotNull String cause) {
        if (cause == null) {
            IdeFocusManager.$$$reportNull$$$0(1);
        }
    }

    @NotNull
    public abstract ActionCallback requestDefaultFocus(boolean var1);

    public abstract boolean isFocusTransferEnabled();

    public abstract void setTypeaheadEnabled(boolean var1);

    public abstract Component getFocusOwner();

    public abstract void runOnOwnContext(@NotNull DataContext var1, @NotNull Runnable var2);

    @Nullable
    public abstract Component getLastFocusedFor(@Nullable IdeFrame var1);

    @Nullable
    public abstract IdeFrame getLastFocusedFrame();

    public abstract void toFront(JComponent var1);

    public static IdeFocusManager getInstance(@Nullable Project project) {
        if (project == null || project.isDisposed() || !project.isInitialized()) {
            return IdeFocusManager.getGlobalInstance();
        }
        return project.getComponent(IdeFocusManager.class);
    }

    @NotNull
    public static IdeFocusManager findInstanceByContext(@Nullable DataContext context) {
        IdeFocusManager instance = null;
        if (context != null) {
            instance = IdeFocusManager.getInstanceSafe(CommonDataKeys.PROJECT.getData(context));
        }
        if (instance == null) {
            instance = IdeFocusManager.findByComponent(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow());
        }
        if (instance == null) {
            instance = IdeFocusManager.getGlobalInstance();
        }
        IdeFocusManager ideFocusManager = instance;
        if (ideFocusManager == null) {
            IdeFocusManager.$$$reportNull$$$0(2);
        }
        return ideFocusManager;
    }

    @NotNull
    public static IdeFocusManager findInstanceByComponent(@NotNull Component c) {
        IdeFocusManager instance;
        if (c == null) {
            IdeFocusManager.$$$reportNull$$$0(3);
        }
        IdeFocusManager ideFocusManager = (instance = IdeFocusManager.findByComponent(c)) != null ? instance : IdeFocusManager.findInstanceByContext(null);
        if (ideFocusManager == null) {
            IdeFocusManager.$$$reportNull$$$0(4);
        }
        return ideFocusManager;
    }

    @Nullable
    private static IdeFocusManager findByComponent(Component c) {
        Component parent = UIUtil.findUltimateParent((Component)c);
        if (parent instanceof IdeFrame) {
            return IdeFocusManager.getInstanceSafe(((IdeFrame)((Object)parent)).getProject());
        }
        return null;
    }

    @Nullable
    private static IdeFocusManager getInstanceSafe(@Nullable Project project) {
        if (project != null && !project.isDisposed() && project.isInitialized()) {
            return IdeFocusManager.getInstance(project);
        }
        return null;
    }

    @NotNull
    public static IdeFocusManager findInstance() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        IdeFocusManager ideFocusManager = owner != null ? IdeFocusManager.findInstanceByComponent(owner) : IdeFocusManager.findInstanceByContext(null);
        if (ideFocusManager == null) {
            IdeFocusManager.$$$reportNull$$$0(5);
        }
        return ideFocusManager;
    }

    @Deprecated
    @NotNull
    public FocusRequestor getFurtherRequestor() {
        FocusRequestor focusRequestor = new FocusRequestor(){

            @Override
            @NotNull
            public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
                if (c == null) {
                    1.$$$reportNull$$$0(0);
                }
                ActionCallback actionCallback = ActionCallback.REJECTED;
                if (actionCallback == null) {
                    1.$$$reportNull$$$0(1);
                }
                return actionCallback;
            }

            public void dispose() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "c";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/wm/IdeFocusManager$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/wm/IdeFocusManager$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "requestFocus";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "requestFocus";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (focusRequestor == null) {
            IdeFocusManager.$$$reportNull$$$0(6);
        }
        return focusRequestor;
    }

    @NotNull
    public static IdeFocusManager getGlobalInstance() {
        IdeFocusManager fm = null;
        Application app = ApplicationManager.getApplication();
        if (app != null && app.hasComponent(IdeFocusManager.class)) {
            fm = app.getComponent(IdeFocusManager.class);
        }
        if (fm == null) {
            fm = PassThroughIdeFocusManager.getInstance();
        }
        PassThroughIdeFocusManager passThroughIdeFocusManager = fm;
        if (passThroughIdeFocusManager == null) {
            IdeFocusManager.$$$reportNull$$$0(7);
        }
        return passThroughIdeFocusManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/IdeFocusManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/IdeFocusManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findInstanceByContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findInstanceByComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFurtherRequestor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requestFocusInProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "typeAheadUntil";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findInstanceByComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

