/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.Win7TaskBar;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.apache.commons.imaging.ImageWriteException;
import org.jetbrains.annotations.NotNull;

public abstract class AppIcon {
    private static final Logger LOG = Logger.getInstance(AppIcon.class);
    private static AppIcon ourIcon;

    @NotNull
    public static AppIcon getInstance() {
        if (ourIcon == null) {
            ourIcon = SystemInfo.isMac ? new MacAppIcon() : (SystemInfo.isWin7OrNewer ? new Win7AppIcon() : new EmptyIcon());
        }
        AppIcon appIcon = ourIcon;
        if (appIcon == null) {
            AppIcon.$$$reportNull$$$0(0);
        }
        return appIcon;
    }

    public abstract boolean setProgress(Project var1, Object var2, AppIconScheme.Progress var3, double var4, boolean var6);

    public abstract boolean hideProgress(Project var1, Object var2);

    public abstract void setErrorBadge(Project var1, String var2);

    public abstract void setOkBadge(Project var1, boolean var2);

    public abstract void requestAttention(Project var1, boolean var2);

    public abstract void requestFocus(IdeFrame var1);

    private static void assertIsDispatchThread() {
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            if (!app.isUnitTestMode()) {
                app.assertIsDispatchThread();
            }
        } else assert (EventQueue.isDispatchThread());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AppIcon", "getInstance"));
    }

    private static class EmptyIcon
    extends AppIcon {
        private EmptyIcon() {
        }

        @Override
        public boolean setProgress(Project project, Object processId, AppIconScheme.Progress scheme2, double value, boolean isOk) {
            return false;
        }

        @Override
        public boolean hideProgress(Project project, Object processId) {
            return false;
        }

        @Override
        public void setErrorBadge(Project project, String text) {
        }

        @Override
        public void setOkBadge(Project project, boolean visible) {
        }

        @Override
        public void requestAttention(Project project, boolean critical) {
        }

        @Override
        public void requestFocus(IdeFrame frame) {
        }
    }

    private static class Win7AppIcon
    extends BaseIcon {
        private static final Color errorBadgeShadowColor = new Color(0, 0, 0, 102);
        private static final Color errorBadgeMainColor = new Color(255, 98, 89);
        private static final Color errorBadgeTextBackgroundColor = new Color(0, 0, 0, 39);
        private Object myOkIcon;

        private Win7AppIcon() {
        }

        @Override
        public boolean _setProgress(IdeFrame frame, Object processId, AppIconScheme.Progress scheme2, double value, boolean isOk) {
            this.myCurrentProcessId = processId;
            if (Math.abs(this.myLastValue - value) < 0.02) {
                return true;
            }
            try {
                if (Win7AppIcon.isValid(frame)) {
                    Win7TaskBar.setProgress(frame, value, isOk);
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            this.myLastValue = value;
            this.myCurrentProcessId = null;
            return true;
        }

        @Override
        public boolean _hideProgress(IdeFrame frame, Object processId) {
            if (this.myCurrentProcessId != null && !this.myCurrentProcessId.equals(processId)) {
                return false;
            }
            try {
                if (Win7AppIcon.isValid(frame)) {
                    Win7TaskBar.hideProgress(frame);
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            this.myCurrentProcessId = null;
            this.myLastValue = 0.0;
            return true;
        }

        /*
         * Exception decompiling
         */
        private static byte[] writeTransparentIco(BufferedImage src) throws ImageWriteException, IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void _setTextBadge(IdeFrame frame, String text) {
            if (!Win7AppIcon.isValid(frame)) {
                return;
            }
            Object icon = null;
            if (text != null) {
                try {
                    int size = 16;
                    BufferedImage image = UIUtil.createImage((Component)frame.getComponent(), (int)size, (int)size, (int)2);
                    Graphics2D g = image.createGraphics();
                    int shadowRadius = 16;
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setPaint(errorBadgeShadowColor);
                    g.fillRoundRect(size / 2 - shadowRadius / 2, size / 2 - shadowRadius / 2, shadowRadius, shadowRadius, size, size);
                    int mainRadius = 14;
                    g.setPaint(errorBadgeMainColor);
                    g.fillRoundRect(size / 2 - mainRadius / 2, size / 2 - mainRadius / 2, mainRadius, mainRadius, size, size);
                    Font font = g.getFont();
                    g.setFont(new Font(font.getName(), 1, 9));
                    FontMetrics fontMetrics = g.getFontMetrics();
                    int textWidth = fontMetrics.stringWidth(text);
                    int textHeight = UIUtil.getHighestGlyphHeight((String)text, (Font)font, (Graphics)g);
                    g.setPaint(errorBadgeTextBackgroundColor);
                    g.fillOval(size / 2 - textWidth / 2, size / 2 - textHeight / 2, textWidth, textHeight);
                    g.setColor(Color.white);
                    g.drawString(text, size / 2 - textWidth / 2, size / 2 - fontMetrics.getHeight() / 2 + fontMetrics.getAscent());
                    byte[] bytes = Win7AppIcon.writeTransparentIco(image);
                    icon = Win7TaskBar.createIcon(bytes);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
            try {
                Win7TaskBar.setOverlayIcon(frame, icon, icon != null);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void _setOkBadge(IdeFrame frame, boolean visible) {
            if (!Win7AppIcon.isValid(frame)) {
                return;
            }
            Object icon = null;
            if (visible) {
                Class<Win7AppIcon> clazz = Win7AppIcon.class;
                // MONITORENTER : com.intellij.ui.AppIcon$Win7AppIcon.class
                if (this.myOkIcon == null) {
                    try {
                        BufferedImage image = ImageIO.read(this.getClass().getResource("/mac/appIconOk512.png"));
                        byte[] bytes = Win7AppIcon.writeTransparentIco(image);
                        this.myOkIcon = Win7TaskBar.createIcon(bytes);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                        this.myOkIcon = null;
                    }
                }
                icon = this.myOkIcon;
                // MONITOREXIT : clazz
            }
            try {
                Win7TaskBar.setOverlayIcon(frame, icon, false);
                return;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        public void _requestAttention(IdeFrame frame, boolean critical) {
            try {
                if (Win7AppIcon.isValid(frame)) {
                    Win7TaskBar.attention(frame, critical);
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        protected IdeFrame getIdeFrame(Project project) {
            return WindowManager.getInstance().getIdeFrame(project);
        }

        @Override
        public void requestFocus(IdeFrame frame) {
        }

        private static boolean isValid(IdeFrame frame) {
            return frame != null && ((Component)frame).isDisplayable();
        }
    }

    static class MacAppIcon
    extends BaseIcon {
        private BufferedImage myAppImage;
        private final Map<Object, AppImage> myProgressImagesCache = new HashMap<Object, AppImage>();
        private static final Color PROGRESS_BACKGROUND_COLOR = new Color(255, 255, 255, 217);
        private static final Color PROGRESS_OUTLINE_COLOR = new Color(140, 139, 140);

        MacAppIcon() {
        }

        private BufferedImage getAppImage() {
            AppIcon.assertIsDispatchThread();
            try {
                if (this.myAppImage != null) {
                    return this.myAppImage;
                }
                Object app = MacAppIcon.getApp();
                Image appImage = (Image)MacAppIcon.getAppMethod("getDockIconImage", new Class[0]).invoke(app, new Object[0]);
                if (appImage == null) {
                    return null;
                }
                this.myAppImage = ImageUtil.toBufferedImage((Image)appImage);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return this.myAppImage;
        }

        @Override
        public void _setTextBadge(IdeFrame frame, String text) {
            AppIcon.assertIsDispatchThread();
            try {
                MacAppIcon.getAppMethod("setDockIconBadge", String.class).invoke(MacAppIcon.getApp(), text);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public void requestFocus(IdeFrame frame) {
            AppIcon.assertIsDispatchThread();
            try {
                MacAppIcon.getAppMethod("requestForeground", Boolean.TYPE).invoke(MacAppIcon.getApp(), true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public void _requestAttention(IdeFrame frame, boolean critical) {
            AppIcon.assertIsDispatchThread();
            try {
                MacAppIcon.getAppMethod("requestUserAttention", Boolean.TYPE).invoke(MacAppIcon.getApp(), critical);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        protected IdeFrame getIdeFrame(Project project) {
            return null;
        }

        @Override
        public boolean _hideProgress(IdeFrame frame, Object processId) {
            AppIcon.assertIsDispatchThread();
            if (this.getAppImage() == null) {
                return false;
            }
            if (this.myCurrentProcessId != null && !this.myCurrentProcessId.equals(processId)) {
                return false;
            }
            MacAppIcon.setDockIcon(this.getAppImage());
            this.myProgressImagesCache.remove(this.myCurrentProcessId);
            this.myCurrentProcessId = null;
            this.myLastValue = 0.0;
            return true;
        }

        @Override
        public void _setOkBadge(IdeFrame frame, boolean visible) {
            AppIcon.assertIsDispatchThread();
            if (this.getAppImage() == null) {
                return;
            }
            AppImage img = this.createAppImage();
            if (visible) {
                Icon okIcon = AllIcons.Mac.AppIconOk512;
                int myImgWidth = img.myImg.getWidth();
                if (myImgWidth != 128) {
                    okIcon = IconUtil.scale((Icon)okIcon, (Component)(frame != null ? frame.getComponent() : null), (float)((float)myImgWidth / 128.0f));
                }
                int x = myImgWidth - okIcon.getIconWidth();
                int y = 0;
                okIcon.paintIcon(JOptionPane.getRootFrame(), img.myG2d, x, y);
            }
            MacAppIcon.setDockIcon(img.myImg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean _setProgress(IdeFrame frame, Object processId, AppIconScheme.Progress scheme2, double value, boolean isOk) {
            AppIcon.assertIsDispatchThread();
            if (this.getAppImage() == null) {
                return false;
            }
            this.myCurrentProcessId = processId;
            if (this.myLastValue > value) {
                return true;
            }
            if (Math.abs(this.myLastValue - value) < 0.02) {
                return true;
            }
            try {
                double progressHeight = (double)this.myAppImage.getHeight() * 0.13;
                double xInset = (double)this.myAppImage.getWidth() * 0.05;
                double yInset = (double)this.myAppImage.getHeight() * 0.15;
                double width = (double)this.myAppImage.getWidth() - xInset * 2.0;
                double y = (double)this.myAppImage.getHeight() - progressHeight - yInset;
                Area borderArea = new Area(new RoundRectangle2D.Double(xInset - 1.0, y - 1.0, width + 2.0, progressHeight + 2.0, progressHeight + 2.0, progressHeight + 2.0));
                Area backgroundArea = new Area(new Rectangle2D.Double(xInset, y, width, progressHeight));
                backgroundArea.intersect(borderArea);
                Area progressArea = new Area(new Rectangle2D.Double(xInset + 1.0, y + 1.0, (width - 2.0) * value, progressHeight - 1.0));
                progressArea.intersect(borderArea);
                AppImage appImg = this.myProgressImagesCache.get(this.myCurrentProcessId);
                if (appImg == null) {
                    appImg = this.createAppImage();
                    this.myProgressImagesCache.put(this.myCurrentProcessId, appImg);
                }
                appImg.myG2d.setColor(PROGRESS_BACKGROUND_COLOR);
                appImg.myG2d.fill(backgroundArea);
                Color color = isOk ? scheme2.getOkColor() : scheme2.getErrorColor();
                appImg.myG2d.setColor(color);
                appImg.myG2d.fill(progressArea);
                appImg.myG2d.setColor(PROGRESS_OUTLINE_COLOR);
                appImg.myG2d.draw(backgroundArea);
                appImg.myG2d.draw(borderArea);
                MacAppIcon.setDockIcon(appImg.myImg);
                this.myLastValue = value;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                this.myCurrentProcessId = null;
            }
            return true;
        }

        private AppImage createAppImage() {
            BufferedImage appImage = this.getAppImage();
            assert (appImage != null);
            BufferedImage current = new BufferedImage(appImage.getWidth(), appImage.getHeight(), 2);
            Graphics2D g = current.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            UIUtil.drawImage((Graphics)g, (Image)appImage, (int)0, (int)0, null);
            return new AppImage(current, g);
        }

        static void setDockIcon(BufferedImage image) {
            try {
                MacAppIcon.getAppMethod("setDockIconImage", Image.class).invoke(MacAppIcon.getApp(), image);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        private static Method getAppMethod(String name, Class ... args) throws NoSuchMethodException, ClassNotFoundException {
            return MacAppIcon.getAppClass().getMethod(name, args);
        }

        private static Object getApp() throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
            return MacAppIcon.getAppClass().getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
        }

        private static Class<?> getAppClass() throws ClassNotFoundException {
            return Class.forName("com.apple.eawt.Application");
        }

        private static class AppImage {
            BufferedImage myImg;
            Graphics2D myG2d;

            AppImage(BufferedImage img, Graphics2D g2d) {
                this.myImg = img;
                this.myG2d = g2d;
            }
        }
    }

    private static abstract class BaseIcon
    extends AppIcon {
        private ApplicationActivationListener myAppListener;
        protected Object myCurrentProcessId;
        protected double myLastValue;

        private BaseIcon() {
        }

        @Override
        public final boolean setProgress(Project project, Object processId, AppIconScheme.Progress scheme2, double value, boolean isOk) {
            if (!this.isAppActive() && Registry.is((String)"ide.appIcon.progress") && (this.myCurrentProcessId == null || this.myCurrentProcessId.equals(processId))) {
                return this._setProgress(this.getIdeFrame(project), processId, scheme2, value, isOk);
            }
            return false;
        }

        @Override
        public final boolean hideProgress(Project project, Object processId) {
            if (Registry.is((String)"ide.appIcon.progress")) {
                return this._hideProgress(this.getIdeFrame(project), processId);
            }
            return false;
        }

        @Override
        public final void setErrorBadge(Project project, String text) {
            if (!this.isAppActive() && Registry.is((String)"ide.appIcon.badge")) {
                this._setOkBadge(this.getIdeFrame(project), false);
                this._setTextBadge(this.getIdeFrame(project), text);
            }
        }

        @Override
        public final void setOkBadge(Project project, boolean visible) {
            if (!this.isAppActive() && Registry.is((String)"ide.appIcon.badge")) {
                this._setTextBadge(this.getIdeFrame(project), null);
                this._setOkBadge(this.getIdeFrame(project), visible);
            }
        }

        @Override
        public final void requestAttention(Project project, boolean critical) {
            if (!this.isAppActive() && Registry.is((String)"ide.appIcon.requestAttention")) {
                this._requestAttention(this.getIdeFrame(project), critical);
            }
        }

        public abstract boolean _setProgress(IdeFrame var1, Object var2, AppIconScheme.Progress var3, double var4, boolean var6);

        public abstract boolean _hideProgress(IdeFrame var1, Object var2);

        public abstract void _setTextBadge(IdeFrame var1, String var2);

        public abstract void _setOkBadge(IdeFrame var1, boolean var2);

        public abstract void _requestAttention(IdeFrame var1, boolean var2);

        protected abstract IdeFrame getIdeFrame(Project var1);

        private boolean isAppActive() {
            Application app = ApplicationManager.getApplication();
            if (app != null && this.myAppListener == null) {
                this.myAppListener = new ApplicationActivationListener(){

                    public void applicationActivated(@NotNull IdeFrame ideFrame) {
                        if (ideFrame == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.hideProgress(ideFrame.getProject(), myCurrentProcessId);
                        this._setOkBadge(ideFrame, false);
                        this._setTextBadge(ideFrame, null);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/ui/AppIcon$BaseIcon$1", "applicationActivated"));
                    }
                };
                app.getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)this.myAppListener);
            }
            return app != null && app.isActive();
        }
    }
}

