/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.jetbrains.php.framework.FrameworkCommandHistoryList;
import com.jetbrains.php.framework.data.FrameworkDescription;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.Nullable;

public class FrameworkHistoryKeyListener
extends KeyAdapter {
    private static final int SCROLL_OUTPUT_MASK = 640;
    public static final Key<FrameworkHistoryKeyListener> HISTORY_LISTENER_KEY = new Key("frameworkHistoryKeyListener");
    private final Editor myEditor;
    private final FrameworkCommandHistoryList myCommands;

    public FrameworkHistoryKeyListener(Editor editor, FrameworkCommandHistoryList commands) {
        this.myEditor = editor;
        this.myCommands = commands;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        boolean isStrictArrow;
        LookupEx lookup = LookupManager.getActiveLookup((Editor)this.myEditor);
        if (lookup != null) {
            return;
        }
        boolean isArrow = 40 == e.getKeyCode() || 38 == e.getKeyCode();
        boolean bl = isStrictArrow = isArrow && (e.getModifiersEx() & 0x280) != 640;
        if (isStrictArrow) {
            if (this.myCommands.needsInitialString()) {
                this.myCommands.setInitialString(this.myEditor.getDocument().getText());
            }
            String newCommand = 38 == e.getKeyCode() ? this.myCommands.getPrevious() : this.myCommands.getNext();
            FrameworkHistoryKeyListener.setText(newCommand, this.myEditor);
        }
    }

    private static void setText(String newCommand, Editor editor) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            editor.getDocument().setText((CharSequence)newCommand);
            CaretModel caretModel = editor.getCaretModel();
            caretModel.moveToOffset(editor.getDocument().getLineEndOffset(0));
        });
    }

    public void addNewExecutedCommand(String command, @Nullable FrameworkDescription framework) {
        this.myCommands.add(command, framework);
    }
}

