/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.util.text.StringUtil;

public abstract class FilePatch {
    private String myBeforeName;
    private String myAfterName;
    private String myBeforeVersionId;
    private String myAfterVersionId;
    private String myBaseRevisionText;
    private int myNewFileMode = -1;

    public String getBeforeName() {
        return this.myBeforeName;
    }

    public String getAfterName() {
        return this.myAfterName;
    }

    public String getBeforeFileName() {
        String[] pathNameComponents = this.myBeforeName.split("/");
        return pathNameComponents[pathNameComponents.length - 1];
    }

    public String getAfterFileName() {
        String[] pathNameComponents = this.myAfterName.split("/");
        return pathNameComponents[pathNameComponents.length - 1];
    }

    public void setBeforeName(String fileName) {
        this.myBeforeName = fileName;
    }

    public void setAfterName(String fileName) {
        this.myAfterName = fileName;
    }

    public String getBeforeVersionId() {
        return this.myBeforeVersionId;
    }

    public void setBeforeVersionId(String beforeVersionId) {
        this.myBeforeVersionId = beforeVersionId;
    }

    public String getAfterVersionId() {
        return this.myAfterVersionId;
    }

    public void setAfterVersionId(String afterVersionId) {
        this.myAfterVersionId = afterVersionId;
    }

    public String getAfterNameRelative(int skipDirs) {
        String[] components = this.myAfterName.split("/");
        return StringUtil.join((String[])components, (int)skipDirs, (int)components.length, (String)"/");
    }

    public String getBaseRevisionText() {
        return this.myBaseRevisionText;
    }

    public void setBaseRevisionText(String baseRevisionText) {
        this.myBaseRevisionText = baseRevisionText;
    }

    public abstract boolean isNewFile();

    public abstract boolean isDeletedFile();

    public int getNewFileMode() {
        return this.myNewFileMode;
    }

    public void setNewFileMode(int newFileMode) {
        this.myNewFileMode = newFileMode;
    }
}

