/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.WeightFilter;
import java.awt.image.ImageFilter;

final class DaltonizationFilter
extends WeightFilter {
    public static final ImageFilter protanopia = DaltonizationFilter.forProtanopia(null);
    public static final ImageFilter deuteranopia = DaltonizationFilter.forDeuteranopia(null);
    public static final ImageFilter tritanopia = DaltonizationFilter.forTritanopia(null);
    private final double[] myMatrix;

    public static ImageFilter get(ColorBlindness blindness) {
        if (blindness == ColorBlindness.protanopia) {
            return protanopia;
        }
        if (blindness == ColorBlindness.deuteranopia) {
            return deuteranopia;
        }
        if (blindness == ColorBlindness.tritanopia) {
            return tritanopia;
        }
        return null;
    }

    public static ImageFilter forProtanopia(Double weight) {
        return new DaltonizationFilter("Protanopia", weight, 0.0, 2.02344, -2.52581, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static ImageFilter forDeuteranopia(Double weight) {
        return new DaltonizationFilter("Deuteranopia", weight, 1.0, 0.0, 0.0, 0.494207, 0.0, 1.24827, 0.0, 0.0, 1.0);
    }

    public static ImageFilter forTritanopia(Double weight) {
        return new DaltonizationFilter("Tritanopia", weight, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, -0.395913, 0.801109, 0.0);
    }

    private DaltonizationFilter(String name, Double weight, double ... matrix) {
        super(name + " (daltonization)", weight);
        this.myMatrix = matrix;
    }

    @Override
    int toRGB(int srcR, int srcG, int srcB) {
        double L = 17.8824 * (double)srcR + 43.5161 * (double)srcG + 4.11935 * (double)srcB;
        double M = 3.45565 * (double)srcR + 27.1554 * (double)srcG + 3.86714 * (double)srcB;
        double S = 0.0299566 * (double)srcR + 0.184309 * (double)srcG + 1.46709 * (double)srcB;
        double l = L * this.myMatrix[0] + M * this.myMatrix[1] + S * this.myMatrix[2];
        double m = L * this.myMatrix[3] + M * this.myMatrix[4] + S * this.myMatrix[5];
        double s = L * this.myMatrix[6] + M * this.myMatrix[7] + S * this.myMatrix[8];
        double R = 0.0809444479 * l + -0.130504409 * m + 0.116721066 * s;
        double G = -0.0102485335 * l + 0.0540193266 * m + -0.113614708 * s;
        double B = -3.65296938E-4 * l + -0.00412161469 * m + 0.693511405 * s;
        R = (double)srcR - R;
        G = (double)srcG - G;
        B = (double)srcB - B;
        double dstR = DaltonizationFilter.fix((double)srcR + 0.0 * R + 0.0 * G + 0.0 * B);
        double dstG = DaltonizationFilter.fix((double)srcG + 0.7 * R + 1.0 * G + 0.0 * B);
        double dstB = DaltonizationFilter.fix((double)srcB + 0.7 * R + 0.0 * G + 1.0 * B);
        return this.toRGB(srcR, srcG, srcB, dstR, dstG, dstB);
    }
}

