/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.idea.RareLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ThrowableConsumer;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8LineReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class V8LogReader {
    private static final Logger LOG = RareLogger.wrap((Logger)Logger.getInstance((String)"#com.jetbrains.nodejs.run.profile.cpu.v8log.V8LogReader"), (boolean)false);
    private final File myFile;
    private final Map<String, ThrowableConsumer<List<String>, IOException>> myParsers;

    public V8LogReader(File file, Map<String, ThrowableConsumer<List<String>, IOException>> parsers) {
        this.myFile = file;
        this.myParsers = parsers;
    }

    public void read() throws IOException {
        try (FileInputStream fis = new FileInputStream(this.myFile);){
            new V8LineReader(new BufferedInputStream(fis)).readLines((ThrowableConsumer<String, IOException>)((ThrowableConsumer)line -> this.processLine((String)line)), CharsetToolkit.UTF8_CHARSET);
        }
    }

    private void processLine(String line) throws IOException {
        String commandName;
        List<String> fields = V8LogReader.splitIntoFields(line);
        if (fields.isEmpty() || StringUtil.isEmptyOrSpaces((String)(commandName = fields.get(0)))) {
            return;
        }
        ThrowableConsumer<List<String>, IOException> parser = this.myParsers.get(commandName.trim());
        if (parser == null) {
            LOG.info("Unknown v8 log field: " + commandName);
        } else {
            parser.consume(fields.subList(1, fields.size()));
        }
    }

    @VisibleForTesting
    @NotNull
    public static List<String> splitIntoFields(@NotNull String line) {
        if (line == null) {
            V8LogReader.$$$reportNull$$$0(0);
        }
        List list = StringUtil.splitHonorQuotes((String)line, (char)',');
        if (list == null) {
            V8LogReader.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8LogReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8LogReader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "splitIntoFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "splitIntoFields";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

