/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Range;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.intellij.plugins.markdown.ui.preview.PreviewStaticServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;

public interface MarkdownHtmlPanel
extends Disposable {
    public static final List<String> SCRIPTS = Arrays.asList("processLinks.js", "scrollToElement.js");
    public static final List<String> STYLES = Arrays.asList("default.css", "darcula.css", "inline.css");

    @NotNull
    public JComponent getComponent();

    public void setHtml(@NotNull String var1);

    public void setCSS(@Nullable String var1, String ... var2);

    public void render();

    public void scrollToMarkdownSrcOffset(int var1);

    @Nullable
    public static Range<Integer> nodeToSrcRange(@NotNull Node node) {
        if (node == null) {
            MarkdownHtmlPanel.$$$reportNull$$$0(0);
        }
        if (!node.hasAttributes()) {
            return null;
        }
        Node attribute = node.getAttributes().getNamedItem(HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME());
        if (attribute == null) {
            return null;
        }
        List startEnd = StringUtil.split((String)attribute.getNodeValue(), (String)"..");
        if (startEnd.size() != 2) {
            return null;
        }
        return new Range((Comparable)Integer.valueOf(Integer.parseInt((String)startEnd.get(0))), (Comparable)Integer.valueOf(Integer.parseInt((String)startEnd.get(1))));
    }

    @NotNull
    public static String getCssLines(@Nullable String inlineCss, String ... fileUris) {
        if (fileUris == null) {
            MarkdownHtmlPanel.$$$reportNull$$$0(1);
        }
        StringBuilder result = new StringBuilder();
        for (String uri : fileUris) {
            uri = MarkdownHtmlPanel.migrateUriToHttp(uri);
            result.append("<link rel=\"stylesheet\" href=\"").append(uri).append("\" />\n");
        }
        if (inlineCss != null) {
            result.append("<style>\n").append(inlineCss).append("\n</style>\n");
        }
        String string = result.toString();
        if (string == null) {
            MarkdownHtmlPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static String migrateUriToHttp(@NotNull String uri) {
        if (uri == null) {
            MarkdownHtmlPanel.$$$reportNull$$$0(3);
        }
        if (uri.equals(MarkdownCssSettings.DEFAULT.getStylesheetUri())) {
            return PreviewStaticServer.getStyleUrl("default.css");
        }
        if (uri.equals(MarkdownCssSettings.DARCULA.getStylesheetUri())) {
            return PreviewStaticServer.getStyleUrl("darcula.css");
        }
        return uri;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUris";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nodeToSrcRange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCssLines";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "migrateUriToHttp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

