/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class ConstDeclNode
extends AssignableNode
implements INameNode {
    private String name;
    private INameNode constNode;

    public ConstDeclNode(SourcePosition position, String name, INameNode constNode, Node valueNode) {
        super(position, valueNode);
        this.name = name;
        this.constNode = (INameNode)((Object)this.adopt((Node)((Object)constNode)));
    }

    public boolean isSame(Node other) {
        return super.isSame(other) && this.isNameMatch(((ConstDeclNode)other).getName());
    }

    public NodeType getNodeType() {
        return NodeType.CONSTDECLNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitConstDeclNode(this);
    }

    public String getLexicalName() {
        return this.getName();
    }

    public String getName() {
        return this.name == null ? this.constNode.getName() : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    public Node getConstNode() {
        return (Node)((Object)this.constNode);
    }

    public SourcePosition getNamePosition() {
        return this.getPosition().fromBeginning(this.getName().length());
    }

    public SourcePosition getLexicalNamePosition() {
        return this.getNamePosition();
    }
}

