/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.drupal.DrupalBundle;
import com.jetbrains.php.drupal.DrupalVersion;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DrupalUtil {
    @NonNls
    public static final String MODULE_FILE_EXTENSION = ".module";
    @NonNls
    public static final String INCLUDED_FILE_EXTENSION = ".inc";
    @NonNls
    public static final String INFO_FILE_EXTENSION = ".info";

    private DrupalUtil() {
    }

    @Nullable
    public static String validateDrupalFolder(String path, @Nullable DrupalVersion version) {
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return DrupalBundle.message("drupal.validate.directory.message", new Object[0]);
        }
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        return DrupalUtil.validateDrupalInstallation(file, version);
    }

    @Contract(value="null, _ -> !null")
    @Nullable
    public static String validateDrupalInstallation(@Nullable VirtualFile file, @Nullable DrupalVersion version) {
        if (file == null || !file.isDirectory() || VfsUtil.findRelativeFile((VirtualFile)file, (String[])new String[]{"modules"}) == null || VfsUtil.findRelativeFile((VirtualFile)file, (String[])new String[]{"sites"}) == null) {
            return DrupalBundle.message("drupal.validate.directory.message", new Object[0]);
        }
        if (version == null) {
            return null;
        }
        switch (version) {
            case SIX: 
            case SEVEN: {
                if (VfsUtil.findRelativeFile((VirtualFile)file, (String[])new String[]{"includes"}) != null) break;
                return DrupalBundle.message("drupal.validate.directory.message.6.7", new Object[0]);
            }
            case EIGHT: {
                if (VfsUtil.findRelativeFile((VirtualFile)file, (String[])new String[]{"core"}) != null) break;
                return DrupalBundle.message("drupal.validate.directory.message.8", new Object[0]);
            }
            default: {
                throw new IllegalStateException("Unknown drupal version: " + (Object)((Object)version));
            }
        }
        return null;
    }

    public static boolean isValid(DrupalDataService.State state) {
        if (!state.isEnabled()) {
            return true;
        }
        DrupalVersion version = DrupalVersion.getFromNumber(state.getVersion());
        if (version == null) {
            return false;
        }
        return DrupalUtil.validateDrupalFolder(state.getDrupalPath(), version) == null;
    }

    public static void notifyGlobally(@Nullable Project project, String title, String message, NotificationType notificationType, Function<Notification, AnAction> ... actions) {
        Notification notification = new Notification("Drupal", title, message, notificationType, null);
        for (Function<Notification, AnAction> actionGenerator : actions) {
            notification.addAction(actionGenerator.apply(notification));
        }
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    @Nullable
    public static String getModuleName(VirtualFile file, @Nullable Map<VirtualFile, String> moduleNamesCache) {
        if (file == null) {
            return null;
        }
        String moduleFileName = DrupalUtil.getModuleFileName(file.getName());
        if (moduleFileName != null) {
            return moduleFileName;
        }
        VirtualFile parent = file;
        while ((parent = parent.getParent()) != null) {
            String cachedModuleName;
            if (moduleNamesCache != null && (cachedModuleName = moduleNamesCache.get(parent)) != null) {
                if (cachedModuleName.isEmpty()) continue;
                return cachedModuleName;
            }
            for (VirtualFile child : parent.getChildren()) {
                String childFileName;
                if (child.isDirectory() || (childFileName = DrupalUtil.getModuleFileName(child.getName())) == null) continue;
                if (moduleNamesCache != null) {
                    moduleNamesCache.put(parent, childFileName);
                }
                return childFileName;
            }
            if (moduleNamesCache == null) continue;
            moduleNamesCache.put(parent, "");
        }
        return null;
    }

    @Nullable
    private static String getModuleFileName(String fileName) {
        if (fileName.endsWith(MODULE_FILE_EXTENSION)) {
            return fileName.substring(0, fileName.length() - MODULE_FILE_EXTENSION.length());
        }
        return null;
    }
}

