/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.PostgresLexer;
import com.intellij.sql.dialects.redshift.RedshiftInjectionIdentifyingLexer;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;

public class PostgresInjectionIdentifyingLexer
extends PostgresLexer {
    private final SqlLexer.LookAheadHelper myLah = new SqlLexer.LookAheadHelper(){

        @Override
        protected void superLookAhead(Lexer lexer) {
            PostgresInjectionIdentifyingLexer.super.lookAhead(lexer);
        }
    };

    @Override
    protected void lookAhead(Lexer baseLexer) {
        this.myLah.restart(baseLexer);
        IElementType type = this.myLah.getNextToken();
        if (type == PgTypes.PG_DO) {
            PostgresInjectionIdentifyingLexer.lookAheadDoBlock(this.myLah);
        } else if (type == PgTypes.PG_CREATE) {
            RedshiftInjectionIdentifyingLexer.lookAheadCreateFunction(this.myLah);
        }
    }

    private static void lookAheadDoBlock(SqlLexer.LookAheadHelper lah) {
        String lang;
        IElementType type = lah.getNextToken();
        if (type == PgTypes.PG_LANGUAGE) {
            lang = RedshiftInjectionIdentifyingLexer.getNormalizedLanguage(lah);
            if (lang == null) {
                return;
            }
            type = lah.getNextToken();
        } else {
            lang = "pgsql";
        }
        if (type == SqlTokens.SQL_CUSTOM_LQUOTE && lah.getNextToken() == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            lah.replaceToken(lah.getPos(), (IElementType)SqlTokenType.SqlInjectionMark.get((String)lang));
            lah.getNextToken();
        }
    }
}

