/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicPaths {
    @Contract(value="!null->!null")
    public static ObjectPath of(@Nullable BasicElement o) {
        return BasicPaths.of(o, null);
    }

    @Contract(value="!null,_->!null")
    public static ObjectPath of(@Nullable BasicElement o, @Nullable CasingProvider normalizer) {
        if (o == null) {
            return null;
        }
        BasicElement parent2 = o.getParent();
        if (parent2 != null && parent2.getKind() == ObjectKind.ROOT) {
            parent2 = null;
        }
        return BasicPaths.createNormalized(o, BasicPaths.isQuoted(o), BasicPaths.getIdentity(o), BasicPaths.of(parent2, normalizer), normalizer);
    }

    @NotNull
    public static ObjectPath createNormalized(@NotNull DasObject o, boolean quoted, @Nullable String identity, @Nullable ObjectPath parentPath, @Nullable CasingProvider normalizer) {
        if (o == null) {
            BasicPaths.$$$reportNull$$$0(0);
        }
        ObjectKind kind = o.getKind();
        String name = o.getName();
        if (normalizer != null) {
            Casing casing = normalizer.getCasing(kind, o);
            Case q = casing.choose(!quoted);
            name = q.apply(name);
            if (!(quoted || q == Case.MIXED && casing.quoted != Case.MIXED)) {
                quoted = true;
            }
        }
        ObjectPath objectPath = ObjectPath.create((String)name, (ObjectKind)kind, (boolean)quoted, (String)identity, (ObjectPath)parentPath);
        if (objectPath == null) {
            BasicPaths.$$$reportNull$$$0(1);
        }
        return objectPath;
    }

    public static boolean isQuoted(@NotNull BasicElement o) {
        if (o == null) {
            BasicPaths.$$$reportNull$$$0(2);
        }
        return !(o instanceof BasicNamedElement) || ((BasicNamedElement)o).isNameQuoted() || !((BasicNamedElement)o).isNameScripted();
    }

    @Nullable
    public static String getIdentity(@NotNull BasicElement obj) {
        if (obj == null) {
            BasicPaths.$$$reportNull$$$0(3);
        }
        String name = obj.getName();
        boolean useIdentity = obj instanceof BasicOverloadable || name.isEmpty();
        String id = useIdentity ? obj.identity(true) : null;
        return id == null || id.equals(name) ? null : StringUtil.trimStart((String)id, (String)name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/BasicPaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/BasicPaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNormalized";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNormalized";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isQuoted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIdentity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

