/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpCSFixer;

import com.google.gson.JsonElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.tools.quality.QualityToolConfigurationManager;
import com.jetbrains.php.tools.quality.QualityToolsComposerConfig;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerConfiguration;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerConfigurationManager;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerCustomRulesSetupDialog;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerOptionsPanel;
import com.jetbrains.php.tools.quality.phpCSFixer.PhpCSFixerValidationInspection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpCSFixerComposerConfig
extends QualityToolsComposerConfig<PhpCSFixerConfiguration, PhpCSFixerValidationInspection> {
    private static final String PACKAGE = "friendsofphp/php-cs-fixer";
    private static final String RELATIVE_PATH = "bin/php-cs-fixer" + (SystemInfo.isWindows ? ".bat" : "");
    private static final PhpCSFixerValidationInspection PHP_CS_FIXER_VALIDATION_INSPECTION = new PhpCSFixerValidationInspection();
    private static final String SEPARATOR = "=";
    private static final String RULES = "--rules";
    private static final String CONFIG = "--config";

    public PhpCSFixerComposerConfig() {
        super(PACKAGE, RELATIVE_PATH);
    }

    @Override
    @NotNull
    protected QualityToolConfigurationManager<PhpCSFixerConfiguration> getConfigurationManager(@NotNull Project project) {
        if (project == null) {
            PhpCSFixerComposerConfig.$$$reportNull$$$0(0);
        }
        PhpCSFixerConfigurationManager phpCSFixerConfigurationManager = PhpCSFixerConfigurationManager.getInstance(project);
        if (phpCSFixerConfigurationManager == null) {
            PhpCSFixerComposerConfig.$$$reportNull$$$0(1);
        }
        return phpCSFixerConfigurationManager;
    }

    @Override
    protected ComposerLogMessageBuilder.Settings getQualityToolsInspectionSettings() {
        return ComposerLogMessageBuilder.Settings.CS_FIXER_INSPECTION;
    }

    @Override
    protected boolean applyRulesetFromRoot(@NotNull Project project) {
        VirtualFile customRulesetFile;
        if (project == null) {
            PhpCSFixerComposerConfig.$$$reportNull$$$0(2);
        }
        if ((customRulesetFile = this.detectCustomRulesetFile(project.getBaseDir(), ".php_cs")) == null) {
            customRulesetFile = this.detectCustomRulesetFile(project.getBaseDir(), ".php_cs.dist");
        }
        if (customRulesetFile != null) {
            String path = customRulesetFile.getPath();
            return this.modifyRulesetInspectionSetting(project, tool -> PhpCSFixerComposerConfig.applyRuleset(tool, "Custom", path));
        }
        return false;
    }

    @Override
    protected boolean applyRulesetFromComposer(@NotNull Project project, PhpCSFixerConfiguration configuration) {
        VirtualFile customRulesetFile;
        if (project == null) {
            PhpCSFixerComposerConfig.$$$reportNull$$$0(3);
        }
        String configPath = ComposerDataService.getInstance(project).getConfigPath();
        VirtualFile config = LocalFileSystem.getInstance().refreshAndFindFileByPath(configPath);
        if (config == null) {
            return false;
        }
        String ruleset = this.getRuleset(config);
        if (ruleset == null) {
            return false;
        }
        List rulesetParts = StringUtil.split((String)ruleset, (String)SEPARATOR);
        if (rulesetParts.size() != 2) {
            return false;
        }
        String type = (String)rulesetParts.get(0);
        String rules = StringUtil.trimLeading((String)((String)rulesetParts.get(1)), (char)'@');
        if (StringUtil.equals((CharSequence)RULES, (CharSequence)type) && ArrayUtil.contains((String)rules, (String[])PhpCSFixerOptionsPanel.getInstalledStandards(project, configuration))) {
            return this.modifyRulesetInspectionSetting(project, tool -> PhpCSFixerComposerConfig.applyRuleset(tool, rules, ""));
        }
        if (StringUtil.equals((CharSequence)CONFIG, (CharSequence)type) && (customRulesetFile = this.detectCustomRulesetFile(config.getParent(), rules)) != null) {
            return this.modifyRulesetInspectionSetting(project, tool -> PhpCSFixerComposerConfig.applyRuleset(tool, "Custom", customRulesetFile.getPath()));
        }
        return false;
    }

    private static void applyRuleset(PhpCSFixerValidationInspection tool, String codingStandard, String customRuleset) {
        tool.CUSTOM_RULESET_PATH = customRuleset;
        tool.CODING_STANDARD = codingStandard;
    }

    @Override
    protected void checkComposerScriptsLeaves(JsonElement element, Ref<String> result) {
        String string = element.getAsString();
        if (string != null && string.contains("php-cs-fixer")) {
            for (String arg : StringUtil.split((String)string, (String)" ")) {
                if (!StringUtil.startsWith((CharSequence)arg, (CharSequence)CONFIG) && !StringUtil.startsWith((CharSequence)arg, (CharSequence)RULES)) continue;
                result.set((Object)arg);
            }
        }
    }

    @Override
    protected boolean checkRulesetFile(VirtualFile file) {
        return PhpCSFixerCustomRulesSetupDialog.isCodingStandardFile(file.getPath());
    }

    @Override
    protected PhpCSFixerValidationInspection getQualityInspection() {
        return PHP_CS_FIXER_VALIDATION_INSPECTION;
    }

    @Override
    protected ComposerLogMessageBuilder.Settings getQualityToolsSettings() {
        return ComposerLogMessageBuilder.Settings.CS_FIXER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/phpCSFixer/PhpCSFixerComposerConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/phpCSFixer/PhpCSFixerComposerConfig";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationManager";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyRulesetFromRoot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyRulesetFromComposer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

