/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpFilter
implements Filter {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.run.filters.PhpFilter");
    protected static final String DISK_PATTERN = "\\p{Alpha}:";
    protected static final String FILENAME_PATTERN = "[^:<>/\\?\\\\]+";
    protected static final String EXTENSION_PATTERN = "\\.[^:<>/\\?\\\\]+";
    protected static final String PATTERN = "(?:/|\\\\)[^:]*[^:<>/\\?\\\\]+(?:\\.[^:<>/\\?\\\\]+)?";
    protected static final String WHOLE_FILENAME_PATTERN = "(?:\\p{Alpha}:)?(?:/|\\\\)[^:]*[^:<>/\\?\\\\]+(?:\\.[^:<>/\\?\\\\]+)?";
    private final PhpPathMapper myPathMapper;
    private final Project myProject;

    public PhpFilter(@NotNull Project project, @NotNull PhpPathMapper pathMapper) {
        if (project == null) {
            PhpFilter.$$$reportNull$$$0(0);
        }
        if (pathMapper == null) {
            PhpFilter.$$$reportNull$$$0(1);
        }
        this.myPathMapper = pathMapper;
        this.myProject = project;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Path mapper: " + pathMapper);
        }
    }

    public final Filter.Result applyFilter(String line, int entireLength) {
        MyResult result = this.applyFilter(line);
        if (result == null) {
            return null;
        }
        VirtualFile localFile = this.getPathMapper(this.myProject).getLocalFile(result.getFileName());
        if (localFile == null) {
            return null;
        }
        OpenFileHyperlinkInfo hyperlinkInfo = new OpenFileHyperlinkInfo(this.myProject, localFile, result.getLineNumber() - 1);
        int textStartOffset = entireLength - line.length();
        int highlightStartOffset = textStartOffset + result.getHighlightStartOffset();
        int highlightEndOffset = textStartOffset + result.getHighlightEndOffset();
        if (highlightStartOffset < 0 || highlightEndOffset > entireLength || highlightStartOffset > highlightEndOffset) {
            LOG.warn("Failed to highlight range at " + textStartOffset + ":(" + highlightStartOffset + ", " + highlightEndOffset + ") in '" + line + "'");
            return null;
        }
        return new Filter.Result(highlightStartOffset, highlightEndOffset, (HyperlinkInfo)hyperlinkInfo);
    }

    protected PhpPathMapper getPathMapper(@NotNull Project project) {
        if (project == null) {
            PhpFilter.$$$reportNull$$$0(2);
        }
        return this.myPathMapper;
    }

    @Nullable
    public abstract MyResult applyFilter(@NotNull String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/run/filters/PhpFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathMapper";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyResult {
        @NotNull
        private final String myFileName;
        private final int myLineNumber;
        private final int myHighlightStartOffset;
        private final int myHighlightEndOffset;

        public MyResult(@NotNull String fileName, int lineNumber, int highlightStartOffset, int highlightEndOffset) {
            if (fileName == null) {
                MyResult.$$$reportNull$$$0(0);
            }
            this.myFileName = fileName;
            this.myLineNumber = lineNumber;
            this.myHighlightStartOffset = highlightStartOffset;
            this.myHighlightEndOffset = highlightEndOffset;
        }

        @NotNull
        public String getFileName() {
            String string = this.myFileName;
            if (string == null) {
                MyResult.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int getLineNumber() {
            return this.myLineNumber;
        }

        public int getHighlightStartOffset() {
            return this.myHighlightStartOffset;
        }

        public int getHighlightEndOffset() {
            return this.myHighlightEndOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/run/filters/PhpFilter$MyResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/run/filters/PhpFilter$MyResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

