/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.clazz;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.PhpFileCreator;
import com.jetbrains.php.refactoring.PhpNamespaceBraceConverter;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassUsageInfo;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpMoveClassDeclarationInfo
extends PhpMoveClassUsageInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.refactoring.move.clazz.PhpMoveClassDeclarationInfo");
    protected final PsiDirectory myBaseDirectory;
    protected final String myFilePath;

    public PhpMoveClassDeclarationInfo(@NotNull PsiElement element, @Nullable String filePath, @Nullable PsiDirectory baseDirectory) {
        if (element == null) {
            PhpMoveClassDeclarationInfo.$$$reportNull$$$0(0);
        }
        super(element);
        this.myBaseDirectory = baseDirectory;
        this.myFilePath = filePath;
    }

    public PhpMoveClassDeclarationInfo(@NotNull PsiElement element) {
        if (element == null) {
            PhpMoveClassDeclarationInfo.$$$reportNull$$$0(1);
        }
        super(element);
        this.myBaseDirectory = null;
        this.myFilePath = null;
    }

    @Override
    public PsiFile secondStepProcess(@NotNull Project project, @NotNull String newNamespaceName, @NotNull PhpClass clazz) throws IncorrectOperationException {
        if (project == null) {
            PhpMoveClassDeclarationInfo.$$$reportNull$$$0(2);
        }
        if (newNamespaceName == null) {
            PhpMoveClassDeclarationInfo.$$$reportNull$$$0(3);
        }
        if (clazz == null) {
            PhpMoveClassDeclarationInfo.$$$reportNull$$$0(4);
        }
        PhpClassReferenceResolver referenceResolver = new PhpClassReferenceResolver();
        referenceResolver.setProcessKwParent(false);
        referenceResolver.processElement((PsiElement)clazz);
        PsiElement scopeHolder = this.moveClass(project, newNamespaceName, clazz);
        if (scopeHolder != null) {
            PsiFile file = scopeHolder.getContainingFile();
            PhpClass newClass = PhpMoveClassDeclarationInfo.getClassByName(file, clazz.getNameCS());
            if (newClass == null) {
                LOG.error("Can not find class '" + clazz.getNameCS() + "' to import internal references");
            } else if (!(scopeHolder instanceof PhpPsiElement)) {
                LOG.error("Can not find scope for class '" + clazz.getNameCS() + "' to import internal references");
            } else {
                referenceResolver.importReferences((PhpPsiElement)scopeHolder, (PsiElement)newClass);
            }
            if (this.myBaseDirectory != null && this.myFilePath != null) {
                List path = StringUtil.split((String)this.myFilePath.replace(File.separator, "/"), (String)"/");
                PsiDirectory parentDir = PhpFileCreator.createDirectory(path, this.myBaseDirectory);
                MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)file, (PsiDirectory)parentDir);
                DumbService.getInstance((Project)project).completeJustSubmittedTasks();
                file = parentDir.findFile(file.getName());
                PhpCodeUtil.openRelatedFile(project, scopeHolder);
            }
            PhpMoveClassDeclarationInfo.navigateToClassByName(file, clazz.getNameCS());
            return file;
        }
        return null;
    }

    @Nullable
    protected abstract PsiElement moveClass(@NotNull Project var1, @NotNull String var2, @NotNull PhpClass var3);

    protected static void deleteClassWithPhpDoc(@NotNull PhpClass clazz) {
        PsiElement commentParent;
        if (clazz == null) {
            PhpMoveClassDeclarationInfo.$$$reportNull$$$0(5);
        }
        PsiElement parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)clazz);
        assert (parent != null);
        PhpDocComment comment = clazz.getDocComment();
        PsiElement psiElement = commentParent = comment == null ? null : comment.getParent();
        if (comment != null && commentParent != parent) {
            parent.deleteChildRange((PsiElement)clazz, (PsiElement)clazz);
            commentParent.deleteChildRange((PsiElement)comment, (PsiElement)comment);
        } else {
            parent.deleteChildRange((PsiElement)(comment == null ? clazz : comment), (PsiElement)clazz);
        }
    }

    @Nullable
    public static PhpNamespace getNamespaceByFqn(@NotNull PsiFile file, @NotNull String name) {
        if (file == null) {
            PhpMoveClassDeclarationInfo.$$$reportNull$$$0(6);
        }
        if (name == null) {
            PhpMoveClassDeclarationInfo.$$$reportNull$$$0(7);
        }
        String fqn = PhpLangUtil.toFQN(name);
        List<PhpNamespace> namespaces = PhpCodeInsightUtil.collectNamespaces(file);
        for (PhpNamespace namespace : namespaces) {
            if (!PhpLangUtil.equalsNamespaceNames(fqn, namespace.getFQN())) continue;
            return namespace;
        }
        LOG.debug("Can not find created namespace in " + file.getVirtualFile().getPath());
        return null;
    }

    protected static void navigateToClassByName(@NotNull PsiFile file, @NotNull CharSequence className) {
        PhpClass clazz;
        if (file == null) {
            PhpMoveClassDeclarationInfo.$$$reportNull$$$0(8);
        }
        if (className == null) {
            PhpMoveClassDeclarationInfo.$$$reportNull$$$0(9);
        }
        if ((clazz = PhpMoveClassDeclarationInfo.getClassByName(file, className)) != null) {
            clazz.navigate(true);
        }
    }

    @Nullable
    private static PhpClass getClassByName(@NotNull PsiFile file, @NotNull CharSequence className) {
        if (file == null) {
            PhpMoveClassDeclarationInfo.$$$reportNull$$$0(10);
        }
        if (className == null) {
            PhpMoveClassDeclarationInfo.$$$reportNull$$$0(11);
        }
        if (file instanceof PhpFile) {
            PhpClass clazz = PhpPsiUtil.findClass((PhpFile)file, (Condition<? super PhpClass>)((Condition)aClass -> {
                if (className == null) {
                    PhpMoveClassDeclarationInfo.$$$reportNull$$$0(15);
                }
                return PhpLangUtil.equalsClassNames(aClass.getNameCS(), className);
            }));
            if (clazz == null) {
                LOG.warn("Can not find class with specified name inside file: " + file.getName());
            }
            return clazz;
        }
        LOG.warn("Can not find class inside not php file: " + file.getName());
        return null;
    }

    @NotNull
    protected static String createNamespaceContent(@NotNull String namespaceName, @NotNull PhpClass clazz, boolean isBraced, boolean addSpaceAfterNamespace) {
        if (namespaceName == null) {
            PhpMoveClassDeclarationInfo.$$$reportNull$$$0(12);
        }
        if (clazz == null) {
            PhpMoveClassDeclarationInfo.$$$reportNull$$$0(13);
        }
        StringBuilder text = new StringBuilder();
        boolean globalNamespace = PhpLangUtil.isGlobalNamespaceName(namespaceName);
        if (!globalNamespace || isBraced) {
            text.append("namespace ").append(namespaceName);
            if (isBraced) {
                text.append(" {\n");
            } else {
                text.append(";\n");
            }
        }
        text.append("\n");
        PhpDocComment docComment = clazz.getDocComment();
        if (docComment != null) {
            text.append(docComment.getText()).append("\n");
        } else if (globalNamespace && !isBraced) {
            text.append("/** empty */\n");
        }
        text.append(clazz.getText());
        if (isBraced) {
            text.append("\n}");
        }
        if (addSpaceAfterNamespace) {
            text.append("\n");
        }
        String string = text.toString();
        if (string == null) {
            PhpMoveClassDeclarationInfo.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNamespaceName";
                break;
            }
            case 4: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassDeclarationInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassDeclarationInfo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamespaceContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "secondStepProcess";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteClassWithPhpDoc";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceByFqn";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "navigateToClassByName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getClassByName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createNamespaceContent";
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getClassByName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NamespaceScopeHolderUsage
    extends PhpMoveClassDeclarationInfo {
        public NamespaceScopeHolderUsage(@NotNull PhpNamespace namespace, @Nullable String filePath, @Nullable PsiDirectory baseDirectory) {
            if (namespace == null) {
                NamespaceScopeHolderUsage.$$$reportNull$$$0(0);
            }
            super((PsiElement)namespace, filePath, baseDirectory);
        }

        @NotNull
        private PhpNamespace getNamespaceElement() {
            PsiElement element = this.getElement();
            assert (element instanceof PhpNamespace);
            PhpNamespace phpNamespace = (PhpNamespace)element;
            if (phpNamespace == null) {
                NamespaceScopeHolderUsage.$$$reportNull$$$0(1);
            }
            return phpNamespace;
        }

        @Override
        protected PsiElement moveClass(@NotNull Project project, @NotNull String newNamespaceName, @NotNull PhpClass clazz) {
            if (project == null) {
                NamespaceScopeHolderUsage.$$$reportNull$$$0(2);
            }
            if (newNamespaceName == null) {
                NamespaceScopeHolderUsage.$$$reportNull$$$0(3);
            }
            if (clazz == null) {
                NamespaceScopeHolderUsage.$$$reportNull$$$0(4);
            }
            PhpNamespace namespace = this.getNamespaceElement();
            PsiFile file = namespace.getContainingFile();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document == null) {
                return null;
            }
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            if (StringUtil.isEmpty((String)newNamespaceName) && !namespace.isBraced()) {
                boolean multipleNamespaces;
                boolean bl = multipleNamespaces = PhpCodeInsightUtil.collectNamespaces(namespace.getContainingFile()).size() > 1;
                if (!multipleNamespaces) {
                    return NamespaceScopeHolderUsage.deleteNamespaceDeclaration(project, namespace, file, document);
                }
                String oldFqn = StringUtil.notNullize((String)namespace.getFQN());
                PhpNamespaceBraceConverter.braceAllInFile(project, file);
                PhpNamespace updatedNamespace = NamespaceScopeHolderUsage.getNamespaceByFqn(file, oldFqn);
                if (updatedNamespace == null) {
                    return null;
                }
                namespace = updatedNamespace;
            }
            PsiElement oldIdentifier = PhpPsiUtil.getChildOfType((PsiElement)namespace, PhpTokenTypes.IDENTIFIER);
            PsiElement oldReference = PhpPsiUtil.getChildOfType((PsiElement)namespace, PhpElementTypes.NS_REFERENCE);
            if (oldIdentifier == null) {
                PsiElement keywordNamespace = PhpPsiUtil.getChildOfType((PsiElement)namespace, PhpTokenTypes.kwNAMESPACE);
                if (keywordNamespace == null) {
                    return null;
                }
                int startOffset = keywordNamespace.getTextRange().getEndOffset();
                document.insertString(startOffset, (CharSequence)(" " + newNamespaceName));
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                return NamespaceScopeHolderUsage.getNamespaceByFqn(file, newNamespaceName);
            }
            int startOffset = oldReference == null ? oldIdentifier.getTextRange().getStartOffset() : oldReference.getTextRange().getStartOffset();
            int endOffset = oldIdentifier.getTextRange().getEndOffset();
            if (StringUtil.isEmpty((String)newNamespaceName) && oldIdentifier.getNextSibling() instanceof PsiWhiteSpace) {
                endOffset = oldIdentifier.getNextSibling().getTextRange().getEndOffset();
            }
            if (startOffset < 0 || endOffset > document.getTextLength() || endOffset < startOffset) {
                LOG.error("Invalid namespace identifier was found at [" + startOffset + ", " + endOffset + "]");
                return null;
            }
            document.replaceString(startOffset, endOffset, (CharSequence)newNamespaceName);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            return NamespaceScopeHolderUsage.getNamespaceByFqn(file, newNamespaceName);
        }

        @Nullable
        private static PsiElement deleteNamespaceDeclaration(@NotNull Project project, PhpNamespace namespace, PsiFile file, Document document) {
            if (project == null) {
                NamespaceScopeHolderUsage.$$$reportNull$$$0(5);
            }
            PsiElement keyword = PhpPsiUtil.getChildOfType((PsiElement)namespace, PhpTokenTypes.kwNAMESPACE);
            PsiElement semicolon = PhpPsiUtil.getChildOfType((PsiElement)namespace, PhpTokenTypes.opSEMICOLON);
            if (keyword == null || semicolon == null) {
                return null;
            }
            int startOffset = keyword.getTextRange().getStartOffset();
            int endOffset = semicolon.getTextRange().getEndOffset();
            endOffset = NamespaceScopeHolderUsage.expandEndOffset(document, endOffset);
            document.deleteString(startOffset, endOffset);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            return file;
        }

        private static int expandEndOffset(@NotNull Document document, int endOffset) {
            int endLine;
            if (document == null) {
                NamespaceScopeHolderUsage.$$$reportNull$$$0(6);
            }
            if (endOffset == document.getLineEndOffset(endLine = document.getLineNumber(endOffset))) {
                int separatorLength = document.getLineSeparatorLength(endLine);
                if (document.getTextLength() > endOffset + separatorLength) {
                    endOffset += separatorLength;
                }
            }
            return endOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassDeclarationInfo$NamespaceScopeHolderUsage";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNamespaceName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassDeclarationInfo$NamespaceScopeHolderUsage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespaceElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "moveClass";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteNamespaceDeclaration";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "expandEndOffset";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class NewFileScopeHolderUsage
    extends PhpMoveClassDeclarationInfo {
        public NewFileScopeHolderUsage(@NotNull PsiElement element, @NotNull PsiDirectory baseDirectory, @NotNull String filePath) {
            if (element == null) {
                NewFileScopeHolderUsage.$$$reportNull$$$0(0);
            }
            if (baseDirectory == null) {
                NewFileScopeHolderUsage.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                NewFileScopeHolderUsage.$$$reportNull$$$0(2);
            }
            super(element, filePath, baseDirectory);
        }

        @Override
        protected PsiElement moveClass(@NotNull Project project, @NotNull String namespaceName, @NotNull PhpClass clazz) {
            if (project == null) {
                NewFileScopeHolderUsage.$$$reportNull$$$0(3);
            }
            if (namespaceName == null) {
                NewFileScopeHolderUsage.$$$reportNull$$$0(4);
            }
            if (clazz == null) {
                NewFileScopeHolderUsage.$$$reportNull$$$0(5);
            }
            String content = NewFileScopeHolderUsage.createNamespaceContent(namespaceName, clazz, false, false);
            if (this.myBaseDirectory == null || this.myFilePath == null) {
                LOG.error("Can't create new file: invalid path to file");
                return null;
            }
            PsiFile file = PhpFileCreator.createPhpFile(project, this.myBaseDirectory, this.myFilePath, content);
            if (file == null) {
                LOG.error("Failed to create file for " + clazz.getPresentableFQN() + " class");
                return null;
            }
            NewFileScopeHolderUsage.deleteClassWithPhpDoc(clazz);
            PhpFile phpFile = (PhpFile)file;
            NewFileScopeHolderUsage.reformatFile(project, (PsiFile)phpFile);
            PhpCodeUtil.openRelatedFile(project, NewFileScopeHolderUsage.getFirstClassInFile(phpFile));
            if (PhpLangUtil.isGlobalNamespaceName(namespaceName)) {
                return phpFile;
            }
            List<PhpNamespace> namespaces = PhpCodeInsightUtil.collectNamespaces(file);
            return namespaces.isEmpty() ? null : (PsiElement)namespaces.get(0);
        }

        @Override
        public PsiFile secondStepProcess(@NotNull Project project, @NotNull String newNamespaceName, @NotNull PhpClass clazz) throws IncorrectOperationException {
            if (project == null) {
                NewFileScopeHolderUsage.$$$reportNull$$$0(6);
            }
            if (newNamespaceName == null) {
                NewFileScopeHolderUsage.$$$reportNull$$$0(7);
            }
            if (clazz == null) {
                NewFileScopeHolderUsage.$$$reportNull$$$0(8);
            }
            PhpClassReferenceResolver referenceCollector = new PhpClassReferenceResolver();
            referenceCollector.setProcessKwParent(false);
            referenceCollector.processElement((PsiElement)clazz);
            PsiElement scopeHolder = this.moveClass(project, newNamespaceName, clazz);
            if (scopeHolder != null) {
                PhpClass newClass = PhpMoveClassDeclarationInfo.getClassByName(scopeHolder.getContainingFile(), clazz.getNameCS());
                if (newClass == null) {
                    LOG.error("Can not find class '" + clazz.getNameCS() + "' to import internal references");
                } else if (!(scopeHolder instanceof PhpPsiElement)) {
                    LOG.error("Can not find scope for class '" + clazz.getNameCS() + "' to import internal references");
                } else {
                    referenceCollector.importReferences((PhpPsiElement)scopeHolder, (PsiElement)newClass);
                }
                if (scopeHolder instanceof PhpFile && clazz.getDocComment() == null) {
                    Collection<PhpClass> classes = PhpPsiUtil.findAllClasses((PhpFile)scopeHolder);
                    assert (classes.size() == 1);
                    PhpDocComment comment = classes.iterator().next().getDocComment();
                    if (comment != null) {
                        comment.delete();
                    }
                }
                PsiFile file = scopeHolder.getContainingFile();
                NewFileScopeHolderUsage.navigateToClassByName(file, clazz.getNameCS());
                PhpCodeUtil.openRelatedFile(project, scopeHolder);
                return file;
            }
            return null;
        }

        @NotNull
        private static PsiElement getFirstClassInFile(@NotNull PhpFile file) {
            Collection<PhpClass> classes;
            if (file == null) {
                NewFileScopeHolderUsage.$$$reportNull$$$0(9);
            }
            PsiElement psiElement = (classes = PhpPsiUtil.findAllClasses(file)).isEmpty() ? file.getFirstChild() : (PsiElement)classes.iterator().next();
            if (psiElement == null) {
                NewFileScopeHolderUsage.$$$reportNull$$$0(10);
            }
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseDirectory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceName";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNamespaceName";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassDeclarationInfo$NewFileScopeHolderUsage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassDeclarationInfo$NewFileScopeHolderUsage";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFirstClassInFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "moveClass";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "secondStepProcess";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getFirstClassInFile";
                    break;
                }
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class FileScopeHolderUsage
    extends PhpMoveClassDeclarationInfo {
        public FileScopeHolderUsage(@NotNull PsiElement element, @Nullable String filePath, @Nullable PsiDirectory baseDirectory) {
            if (element == null) {
                FileScopeHolderUsage.$$$reportNull$$$0(0);
            }
            super(element, filePath, baseDirectory);
        }

        @Override
        protected PsiElement moveClass(@NotNull Project project, @NotNull String namespaceName, @NotNull PhpClass clazz) {
            if (project == null) {
                FileScopeHolderUsage.$$$reportNull$$$0(1);
            }
            if (namespaceName == null) {
                FileScopeHolderUsage.$$$reportNull$$$0(2);
            }
            if (clazz == null) {
                FileScopeHolderUsage.$$$reportNull$$$0(3);
            }
            if (StringUtil.isEmpty((String)namespaceName)) {
                return null;
            }
            PsiFile file = clazz.getContainingFile();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document == null) {
                return null;
            }
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            int startOffset = FileScopeHolderUsage.findOffsetForNamespace(file, clazz);
            if (startOffset == -1) {
                return null;
            }
            document.insertString(startOffset, (CharSequence)("namespace " + namespaceName + ";\n"));
            FileScopeHolderUsage.commitAndReformat(project, file, document);
            List<PhpNamespace> namespaces = PhpCodeInsightUtil.collectNamespaces(file);
            if (namespaces.isEmpty()) {
                LOG.debug("Can not find created namespace in " + file.getVirtualFile().getPath());
                return null;
            }
            return (PsiElement)namespaces.get(0);
        }

        private static int findOffsetForNamespace(@NotNull PsiFile file, @NotNull PhpClass clazz) {
            List groupStatements;
            if (file == null) {
                FileScopeHolderUsage.$$$reportNull$$$0(4);
            }
            if (clazz == null) {
                FileScopeHolderUsage.$$$reportNull$$$0(5);
            }
            if ((groupStatements = PhpPsiUtil.getChildren((PsiElement)file, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF)).isEmpty()) {
                return -1;
            }
            PhpPsiElement firstChild = ((GroupStatement)groupStatements.get(0)).getFirstPsiChild();
            PhpDocComment comment = clazz.getDocComment();
            PhpPsiElement element = firstChild instanceof PhpDocComment && firstChild != comment ? firstChild.getNextPsiSibling() : firstChild;
            return element == null ? -1 : element.getTextRange().getStartOffset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceName";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassDeclarationInfo$FileScopeHolderUsage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveClass";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findOffsetForNamespace";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

