/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkDependentConfiguration;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitSettingsLoader;
import com.jetbrains.php.testFramework.PhpTestFrameworkStateListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpUnitBaseSettingsManager
implements PersistentStateComponent<Element> {
    protected static final SerializationFilter myFilter = new SkipDefaultValuesSerializationFilters();
    protected static final String SETTINGS = "phpunit_settings";
    protected static final String ROOT = "root";
    protected final Project myProject;
    protected List<PhpUnitSettings> mySettings = new ArrayList<PhpUnitSettings>();
    private final List<PhpTestFrameworkStateListener> myStateListeners = new SmartList();

    public PhpUnitBaseSettingsManager() {
        this(null);
    }

    public PhpUnitBaseSettingsManager(@Nullable Project project) {
        this.myProject = project;
        if (this.myProject != null) {
            this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(PhpInterpretersManagerImpl.PhpInterpreterConflictResolveListener.TOPIC, (Object)new PhpInterpretersManagerImpl.PhpInterpreterConflictResolveListener(){

                @Override
                public void resolveInterpreterConflict(@NotNull Map<String, String> oldInterpreterIdToNew) {
                    if (oldInterpreterIdToNew == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List<PhpUnitSettings> settings = PhpUnitBaseSettingsManager.this.getAllSettings();
                    for (PhpUnitSettings setting : settings) {
                        String oldInterpreterId;
                        if (!(setting instanceof PhpSdkDependentConfiguration) || !oldInterpreterIdToNew.containsKey(oldInterpreterId = ((PhpSdkDependentConfiguration)((Object)setting)).getInterpreterId())) continue;
                        ((PhpSdkDependentConfiguration)((Object)setting)).setInterpreterId(oldInterpreterIdToNew.get(oldInterpreterId));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldInterpreterIdToNew", "com/jetbrains/php/phpunit/PhpUnitBaseSettingsManager$1", "resolveInterpreterConflict"));
                }
            });
        }
    }

    public List<PhpUnitSettings> getAllSettings() {
        return this.mySettings;
    }

    public void setSettings(@NotNull List<PhpUnitSettings> settings) {
        if (settings == null) {
            PhpUnitBaseSettingsManager.$$$reportNull$$$0(0);
        }
        this.mySettings = settings;
    }

    @Nullable
    public PhpUnitSettings getSettingsByName(@Nullable String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        for (PhpUnitSettings setting : this.mySettings) {
            if (!StringUtil.equals((CharSequence)setting.getPresentableName(this.myProject), (CharSequence)name)) continue;
            return setting;
        }
        return null;
    }

    public Element getState() {
        Element root = new Element(ROOT);
        if (this.mySettings.isEmpty()) {
            return root;
        }
        Element element = new Element(SETTINGS);
        for (PhpUnitSettings phpUnitSettings : this.mySettings) {
            Element settingElement = XmlSerializer.serialize((Object)phpUnitSettings, (SerializationFilter)myFilter);
            element.addContent(settingElement);
        }
        root.addContent(element);
        return root;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            PhpUnitBaseSettingsManager.$$$reportNull$$$0(1);
        }
        this.mySettings.clear();
        Element settings = element.getChild(SETTINGS);
        if (settings != null) {
            PhpUnitSettingsLoader[] loaders = PhpUnitSettingsLoader.getInstances();
            List children = settings.getChildren();
            for (Object child : children) {
                Element settingElement = (Element)child;
                PhpUnitSettings phpUnitSettings = PhpUnitBaseSettingsManager.load(loaders, settingElement);
                if (phpUnitSettings == null) continue;
                this.mySettings.add(phpUnitSettings);
            }
        }
        this.onSettingsUpdate();
    }

    @Nullable
    protected static PhpUnitSettings load(@NotNull PhpUnitSettingsLoader[] loaders, @NotNull Element element) {
        if (loaders == null) {
            PhpUnitBaseSettingsManager.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpUnitBaseSettingsManager.$$$reportNull$$$0(3);
        }
        for (PhpUnitSettingsLoader loader : loaders) {
            if (!loader.canLoad(element.getName())) continue;
            return loader.load(element);
        }
        return null;
    }

    protected void onSettingsUpdate() {
        for (PhpTestFrameworkStateListener listener : this.myStateListeners) {
            listener.onSettingsUpdate();
        }
    }

    public void addListener(@NotNull Project project, @NotNull PhpTestFrameworkStateListener listener) {
        if (project == null) {
            PhpUnitBaseSettingsManager.$$$reportNull$$$0(4);
        }
        if (listener == null) {
            PhpUnitBaseSettingsManager.$$$reportNull$$$0(5);
        }
        ContainerUtil.add((Object)listener, this.myStateListeners, (Disposable)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaders";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitBaseSettingsManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

