/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.assignment;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class PhpReplaceWithPrefixExpressionQuickFix<F extends AssignmentExpression>
implements LocalQuickFix {
    private final String myName;
    private final String myReplacementExpression;

    public PhpReplaceWithPrefixExpressionQuickFix(F assignment) {
        this.myReplacementExpression = this.getReplacementExpressionString(assignment);
        String operatorText = this.getToBeReplacedOperatorText(assignment);
        this.myName = PhpBundle.message("quickfix.replace.one.operator.with.another", operatorText, this.myReplacementExpression);
    }

    @NotNull
    private String getReplacementExpressionString(@NotNull F assignment) {
        if (assignment == null) {
            PhpReplaceWithPrefixExpressionQuickFix.$$$reportNull$$$0(0);
        }
        PhpPsiElement variable = assignment.getVariable();
        assert (variable != null);
        String variableName = variable.getText();
        IElementType operatorType = this.getOperatorType(assignment);
        String prefix = operatorType.equals(this.getPlusOperatorType()) ? "++" : "--";
        String string = prefix + variableName;
        if (string == null) {
            PhpReplaceWithPrefixExpressionQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public final String getReplacementExpressionString() {
        String string = this.myReplacementExpression;
        if (string == null) {
            PhpReplaceWithPrefixExpressionQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected abstract IElementType getOperatorType(@NotNull F var1);

    @NotNull
    protected abstract IElementType getPlusOperatorType();

    @NotNull
    @Contract(pure=true)
    protected abstract String getToBeReplacedOperatorText(@NotNull F var1);

    @Nls
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PhpReplaceWithPrefixExpressionQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpReplaceWithPrefixExpressionQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            PhpReplaceWithPrefixExpressionQuickFix.$$$reportNull$$$0(5);
        }
        UnaryExpression newExpressionElement = PhpPsiElementFactory.createFromText(project, UnaryExpression.class, this.myReplacementExpression);
        assert (newExpressionElement != null);
        PsiElement assignment = descriptor.getPsiElement();
        assignment.replace((PsiElement)newExpressionElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/assignment/PhpReplaceWithPrefixExpressionQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/assignment/PhpReplaceWithPrefixExpressionQuickFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementExpressionString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementExpressionString";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

