/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocLinkResolver {
    private final String myLink;
    private final PsiElement myContext;

    public PhpDocLinkResolver(@NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(1);
        }
        this.myLink = link;
        this.myContext = context;
    }

    @Deprecated
    @Nullable
    public PsiElement resolveLink() {
        return PhpDocLinkResolver.resolve(this.myLink, this.myContext).stream().map(Result::getElement).findAny().orElse(null);
    }

    @NotNull
    public static Collection<Result> resolve(@NotNull String myLink, @NotNull PsiElement myContext) {
        int bracketIndex;
        if (myLink == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(2);
        }
        if (myContext == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(3);
        }
        List result = ContainerUtil.newSmartList();
        String className = null;
        String functionName = null;
        String fieldName = null;
        String unqualifiedName = null;
        int doubleColIndex = myLink.indexOf("::");
        if (doubleColIndex > 0) {
            className = myLink.substring(0, doubleColIndex);
        }
        if ((bracketIndex = myLink.indexOf("[]")) > 0) {
            className = myLink.substring(0, bracketIndex);
        }
        if (myLink.endsWith("()")) {
            functionName = myLink.substring(doubleColIndex > 0 ? doubleColIndex + 2 : 0, myLink.indexOf("()", doubleColIndex));
        }
        if (myLink.startsWith("function ")) {
            functionName = myLink.substring("function".length()).trim();
        } else if (myLink.contains("$")) {
            int nameStart = myLink.indexOf("$") + 1;
            if (nameStart <= myLink.length()) {
                fieldName = myLink.substring(nameStart);
            }
        } else {
            unqualifiedName = myLink.substring(doubleColIndex > 0 ? doubleColIndex + 2 : 0);
        }
        if (className == null) {
            PhpClass clazz = (PhpClass)PhpPsiUtil.getParentByCondition(myContext, false, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
            if (functionName != null) {
                PhpDocLinkResolver.addAll(result, PhpDocLinkResolver.findFunctions(functionName, myContext));
                if (result.isEmpty() && clazz != null) {
                    PhpDocLinkResolver.addIfNotNull(result, clazz, (PhpClassMember)clazz.findMethodByName((CharSequence)functionName));
                }
            } else if (fieldName != null) {
                PhpDocLinkResolver.addAll(result, PhpDocLinkResolver.findVariable(fieldName, myContext));
                if (result.isEmpty() && clazz != null) {
                    PhpDocLinkResolver.addIfNotNull(result, clazz, (PhpClassMember)clazz.findFieldByName((CharSequence)fieldName, false));
                }
            } else if (unqualifiedName != null) {
                if (clazz != null) {
                    PhpDocLinkResolver.addIfNotNull(result, clazz, (PhpClassMember)clazz.findMethodByName((CharSequence)unqualifiedName));
                    if (result.isEmpty()) {
                        PhpDocLinkResolver.addIfNotNull(result, clazz, (PhpClassMember)clazz.findFieldByName((CharSequence)unqualifiedName, false));
                    }
                }
                if (result.isEmpty()) {
                    PhpDocLinkResolver.addAll(result, PhpDocLinkResolver.findClasses(unqualifiedName, myContext));
                }
                if (result.isEmpty()) {
                    PhpDocLinkResolver.addAll(result, PhpDocLinkResolver.findFunctions(StringUtil.trimEnd((String)unqualifiedName, (String)"()"), myContext));
                }
                if (result.isEmpty()) {
                    PhpDocLinkResolver.addAll(result, PhpDocLinkResolver.findConstants(unqualifiedName, myContext));
                }
            }
        } else {
            Collection<PhpClass> classes = PhpDocLinkResolver.findClasses(className, myContext);
            for (PhpClass clazz : classes) {
                Method resolved = clazz.findMethodByName((CharSequence)(functionName == null ? unqualifiedName : functionName));
                if (resolved == null) {
                    resolved = clazz.findFieldByName((CharSequence)(fieldName == null ? unqualifiedName : fieldName), false);
                }
                if (resolved == null) {
                    resolved = clazz.findFieldByName((CharSequence)(fieldName == null ? unqualifiedName : fieldName), true);
                }
                PhpDocLinkResolver.addIfNotNull(result, clazz, (PhpClassMember)resolved);
            }
            if (result.isEmpty()) {
                PhpDocLinkResolver.addAll(result, classes);
            }
        }
        List list = result;
        if (list == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static void addAll(@NotNull Collection<Result> result, @NotNull Collection<? extends PsiElement> elements) {
        if (result == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(6);
        }
        for (PsiElement psiElement : elements) {
            result.add(new Result(psiElement));
        }
    }

    private static void addIfNotNull(@NotNull Collection<Result> result, @NotNull PhpClass phpClass, @Nullable PhpClassMember member) {
        if (result == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(7);
        }
        if (phpClass == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(8);
        }
        if (member != null) {
            result.add(new Result(phpClass, member));
        }
    }

    private static Collection<PhpClass> findClasses(@NotNull String name, @NotNull PsiElement myContext) {
        if (name == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(9);
        }
        if (myContext == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(10);
        }
        PhpIndex myIndex = PhpIndex.getInstance((Project)myContext.getProject());
        boolean qualified = PhpLangUtil.isFqn(name);
        if (!qualified) {
            List phpClasses = PhpDocLinkResolver.findInImports(name, myContext, false, false).select(PhpClass.class).toList();
            if (!phpClasses.isEmpty()) {
                return phpClasses;
            }
        } else {
            return myIndex.getAnyByFQN(name);
        }
        List result = ContainerUtil.newSmartList();
        result.addAll(myIndex.getClassesByName(name));
        result.addAll(myIndex.getInterfacesByName(name));
        result.addAll(myIndex.getTraitsByName(name));
        return result;
    }

    private static Collection<Function> findFunctions(@NotNull String name, @NotNull PsiElement context) {
        boolean qualified;
        if (name == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(12);
        }
        if (!(qualified = PhpLangUtil.isFqn(name))) {
            List functions = PhpDocLinkResolver.findInImports(name, context, true, false).select(Function.class).toList();
            return !functions.isEmpty() ? functions : PhpIndex.getInstance((Project)context.getProject()).getFunctionsByName(name);
        }
        return PhpIndex.getInstance((Project)context.getProject()).getFunctionsByFQN(name);
    }

    private static Collection<Variable> findVariable(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(14);
        }
        return PhpIndex.getInstance((Project)context.getProject()).getVariablesByName(name);
    }

    private static Collection<Constant> findConstants(@NotNull String name, @NotNull PsiElement context) {
        Collection constants;
        boolean qualified;
        if (name == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(16);
        }
        if (!(qualified = PhpLangUtil.isFqn(name))) {
            constants = PhpDocLinkResolver.findInImports(name, context, false, true).select(Constant.class).toList();
            if (!constants.isEmpty()) {
                return constants;
            }
            constants = PhpIndex.getInstance((Project)context.getProject()).getConstantsByName(name);
        } else {
            constants = PhpIndex.getInstance((Project)context.getProject()).getConstantsByFQN(name);
        }
        List result = ContainerUtil.newSmartList();
        for (Constant constant : constants) {
            if (constant.isCaseSensitive() && !PhpLangUtil.toShortName(name).equals(constant.getName())) continue;
            result.add(constant);
        }
        return result;
    }

    private static StreamEx<PsiElement> findInImports(@NotNull String name, @NotNull PsiElement myContext, boolean function, boolean constant) {
        PhpPsiElement scope;
        if (name == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(17);
        }
        if (myContext == null) {
            PhpDocLinkResolver.$$$reportNull$$$0(18);
        }
        if ((scope = PhpCodeInsightUtil.findScopeForUseOperator(myContext)) != null) {
            return ((StreamEx)((StreamEx)StreamEx.of(PhpCodeInsightUtil.collectImports(scope)).map(PhpUseList::getDeclarations).flatMap(Arrays::stream).filter(use -> !(function && !PhpUseImpl.isOfFunction(use) || constant && !PhpUseImpl.isOfConst(use)))).filter(use -> {
                if (name == null) {
                    PhpDocLinkResolver.$$$reportNull$$$0(19);
                }
                return constant ? name.equals(use.getName()) : name.equalsIgnoreCase(use.getName());
            })).map(PhpUse::getTargetReference).nonNull().map(reference -> reference.multiResolve(false)).flatMap(Arrays::stream).map(ResolveResult::getElement);
        }
        return StreamEx.empty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 1: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myLink";
                break;
            }
            case 3: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/PhpDocLinkResolver";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/PhpDocLinkResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFunctions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findVariable";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findConstants";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findInImports";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findInImports$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Result {
        private final PsiElement myElement;
        private final PhpClassMember myMember;

        private Result(@NotNull PsiElement element) {
            if (element == null) {
                Result.$$$reportNull$$$0(0);
            }
            this.myElement = element;
            this.myMember = null;
        }

        private Result(@NotNull PhpClass phpClass, @NotNull PhpClassMember member) {
            if (phpClass == null) {
                Result.$$$reportNull$$$0(1);
            }
            if (member == null) {
                Result.$$$reportNull$$$0(2);
            }
            this.myElement = phpClass;
            this.myMember = member;
        }

        @NotNull
        public PsiElement getElement() {
            Object object = this.myMember != null ? this.myMember : this.myElement;
            if (object == null) {
                Result.$$$reportNull$$$0(3);
            }
            return object;
        }

        @Nullable
        public PhpClass getPhpClass() {
            return this.myElement instanceof PhpClass ? (PhpClass)this.myElement : null;
        }

        @Nullable
        public PhpClassMember getMember() {
            return this.myMember;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/documentation/PhpDocLinkResolver$Result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/documentation/PhpDocLinkResolver$Result";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

