/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.roots.VcsRootErrorsFinder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootProblemNotifier {
    private static final Logger LOG = Logger.getInstance(VcsRootProblemNotifier.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsConfiguration mySettings;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;
    @NotNull
    private final Set<String> myReportedUnregisteredRoots;
    @Nullable
    private Notification myNotification;
    @NotNull
    private final Object NOTIFICATION_LOCK;
    @NotNull
    private final Function<VcsRootError, String> ROOT_TO_PRESENTABLE;

    public static VcsRootProblemNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(0);
        }
        return new VcsRootProblemNotifier(project);
    }

    private VcsRootProblemNotifier(@NotNull Project project) {
        if (project == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(1);
        }
        this.NOTIFICATION_LOCK = new Object();
        this.ROOT_TO_PRESENTABLE = rootError -> {
            if (rootError.getMapping().equals("<Project>")) {
                return StringUtil.escapeXml((String)rootError.getMapping());
            }
            return this.getPresentableMapping(rootError.getMapping());
        };
        this.myProject = project;
        this.mySettings = VcsConfiguration.getInstance((Project)this.myProject);
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
        this.myProjectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myReportedUnregisteredRoots = new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanAndNotifyIfNeeded() {
        NotificationAction[] notificationActions;
        String description;
        String title;
        Collection<VcsRootError> errors = this.scan();
        if (errors.isEmpty()) {
            Object object = this.NOTIFICATION_LOCK;
            synchronized (object) {
                this.expireNotification();
            }
            return;
        }
        LOG.debug("Following errors detected: " + errors);
        List<VcsRootError> importantUnregisteredRoots = this.getImportantUnregisteredMappings(errors);
        Collection<VcsRootError> invalidRoots = VcsRootProblemNotifier.getInvalidRoots(errors);
        if (Registry.is((String)"vcs.root.auto.add") && !this.areThereExplicitlyIgnoredRoots(errors)) {
            if (invalidRoots.isEmpty() && importantUnregisteredRoots.isEmpty()) {
                return;
            }
            LOG.info("Auto-registered following mappings: " + importantUnregisteredRoots);
            this.addMappings(importantUnregisteredRoots);
            if (invalidRoots.isEmpty() && importantUnregisteredRoots.size() == 1 && FileUtil.pathsEqual((String)((VcsRootError)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(importantUnregisteredRoots))).getMapping(), (String)this.myProject.getBasePath())) {
                return;
            }
            if (invalidRoots.isEmpty() && !Registry.is((String)"vcs.root.auto.add.nofity")) {
                return;
            }
            title = VcsRootProblemNotifier.makeTitle(importantUnregisteredRoots, invalidRoots, true);
            description = this.makeDescription(importantUnregisteredRoots, invalidRoots);
            notificationActions = new NotificationAction[]{this.getConfigureNotificationAction()};
        } else {
            List unregRootPaths = ContainerUtil.map(importantUnregisteredRoots, VcsRootError::getMapping);
            if (invalidRoots.isEmpty() && (importantUnregisteredRoots.isEmpty() || this.myReportedUnregisteredRoots.containsAll(unregRootPaths))) {
                return;
            }
            this.myReportedUnregisteredRoots.addAll(unregRootPaths);
            title = VcsRootProblemNotifier.makeTitle(importantUnregisteredRoots, invalidRoots, false);
            description = this.makeDescription(importantUnregisteredRoots, invalidRoots);
            NotificationAction enableIntegration = NotificationAction.create((String)"Enable Integration", (event, notification) -> this.addMappings(importantUnregisteredRoots));
            NotificationAction ignoreAction = NotificationAction.create((String)"Ignore", (event, notification) -> {
                this.mySettings.addIgnoredUnregisteredRoots((Collection)ContainerUtil.map((Collection)importantUnregisteredRoots, VcsRootError::getMapping));
                notification.expire();
            });
            notificationActions = new NotificationAction[]{enableIntegration, this.getConfigureNotificationAction(), ignoreAction};
        }
        Object object = this.NOTIFICATION_LOCK;
        synchronized (object) {
            this.expireNotification();
            VcsNotifier notifier = VcsNotifier.getInstance(this.myProject);
            this.myNotification = invalidRoots.isEmpty() ? notifier.notifyMinorInfo(title, description, notificationActions) : notifier.notifyError(title, description, this.getConfigureNotificationAction());
        }
    }

    @NotNull
    private NotificationAction getConfigureNotificationAction() {
        NotificationAction notificationAction = NotificationAction.create((String)"Configure...", (event, notification) -> {
            if (!this.myProject.isDisposed()) {
                ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, ActionsBundle.message((String)"group.VcsGroup.text", (Object[])new Object[0]));
                Collection<VcsRootError> errorsAfterPossibleFix = VcsRootProblemNotifier.getInstance(this.myProject).scan();
                if (errorsAfterPossibleFix.isEmpty() && !notification.isExpired()) {
                    notification.expire();
                }
            }
        });
        if (notificationAction == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(2);
        }
        return notificationAction;
    }

    private void addMappings(Collection<VcsRootError> importantUnregisteredRoots) {
        List mappings = this.myVcsManager.getDirectoryMappings();
        for (VcsRootError root : importantUnregisteredRoots) {
            mappings = VcsUtil.addMapping((List)mappings, (String)root.getMapping(), (String)root.getVcsKey().getName());
        }
        this.myVcsManager.setDirectoryMappings(mappings);
    }

    private boolean isUnderOrAboveProjectDir(@NotNull String mapping) {
        if (mapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(3);
        }
        String projectDir = (String)ObjectUtils.assertNotNull((Object)this.myProject.getBasePath());
        return mapping.equals("<Project>") || FileUtil.isAncestor((String)projectDir, (String)mapping, (boolean)false) || FileUtil.isAncestor((String)mapping, (String)projectDir, (boolean)false);
    }

    private boolean isIgnoredOrExcludedPath(@NotNull String mapping) {
        VirtualFile file2;
        if (mapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(4);
        }
        return (file2 = LocalFileSystem.getInstance().findFileByPath(mapping)) != null && (this.myChangeListManager.isIgnoredFile(file2) || (Boolean)ReadAction.compute(() -> this.myProjectFileIndex.isExcluded(file2)) != false);
    }

    private void expireNotification() {
        if (this.myNotification != null) {
            Notification notification = this.myNotification;
            ApplicationManager.getApplication().invokeLater(() -> ((Notification)notification).expire());
            this.myNotification = null;
        }
    }

    @NotNull
    private Collection<VcsRootError> scan() {
        Collection<VcsRootError> collection = new VcsRootErrorsFinder(this.myProject).find();
        if (collection == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    private String makeDescription(@NotNull Collection<VcsRootError> unregisteredRoots, @NotNull Collection<VcsRootError> invalidRoots) {
        if (unregisteredRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(6);
        }
        if (invalidRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(7);
        }
        StringBuilder description = new StringBuilder();
        if (!invalidRoots.isEmpty()) {
            if (invalidRoots.size() == 1) {
                VcsRootError rootError = invalidRoots.iterator().next();
                String vcsName = rootError.getVcsKey().getName();
                description.append(this.getInvalidRootDescriptionItem(rootError, vcsName));
            } else {
                description.append("The following directories are registered as VCS roots, but they are not: <br/>" + this.joinRootsForPresentation(invalidRoots));
            }
            description.append("<br/>");
        }
        if (!unregisteredRoots.isEmpty()) {
            if (unregisteredRoots.size() == 1) {
                VcsRootError unregisteredRoot = unregisteredRoots.iterator().next();
                description.append((String)this.ROOT_TO_PRESENTABLE.fun((Object)unregisteredRoot));
            } else {
                description.append(this.joinRootsForPresentation(unregisteredRoots));
            }
        }
        String string = description.toString();
        if (string == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(8);
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    String getInvalidRootDescriptionItem(@NotNull VcsRootError rootError, @NotNull String vcsName) {
        if (rootError == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(9);
        }
        if (vcsName == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(10);
        }
        String string = String.format("The directory %s is registered as a %s root, but no %s repositories were found there.", this.ROOT_TO_PRESENTABLE.fun((Object)rootError), vcsName, vcsName);
        if (string == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private String joinRootsForPresentation(@NotNull Collection<VcsRootError> errors) {
        if (errors == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(12);
        }
        String string = StringUtil.join((Collection)ContainerUtil.sorted(errors, (root1, root2) -> {
            if (root1.getMapping().equals("<Project>")) {
                return -1;
            }
            if (root2.getMapping().equals("<Project>")) {
                return 1;
            }
            return root1.getMapping().compareTo(root2.getMapping());
        }), this.ROOT_TO_PRESENTABLE, (String)"<br/>");
        if (string == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String makeTitle(@NotNull Collection<VcsRootError> unregisteredRoots, @NotNull Collection<VcsRootError> invalidRoots, boolean rootsAlreadyAdded) {
        String title;
        if (unregisteredRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(14);
        }
        if (invalidRoots == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(15);
        }
        if (unregisteredRoots.isEmpty()) {
            title = "Invalid VCS root " + StringUtil.pluralize((String)"mapping", (int)invalidRoots.size());
        } else if (invalidRoots.isEmpty()) {
            String vcs = VcsRootProblemNotifier.getVcsName(unregisteredRoots);
            String repository = StringUtil.pluralize((String)"Repository", (int)unregisteredRoots.size());
            title = rootsAlreadyAdded ? String.format("%s Integration Enabled", vcs) : String.format("%s %s Found", vcs, repository);
        } else {
            title = "VCS root configuration problems";
        }
        String string = title;
        if (string == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static String getVcsName(Collection<VcsRootError> roots) {
        String result2 = null;
        for (VcsRootError root : roots) {
            String vcsName = root.getVcsKey().getName();
            if (result2 == null) {
                result2 = vcsName;
                continue;
            }
            if (result2.equals(vcsName)) continue;
            return "VCS";
        }
        return result2;
    }

    @NotNull
    private List<VcsRootError> getImportantUnregisteredMappings(@NotNull Collection<VcsRootError> errors) {
        if (errors == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(17);
        }
        List list2 = ContainerUtil.filter(errors, error -> {
            String mapping = error.getMapping();
            return error.getType() == VcsRootError.Type.UNREGISTERED_ROOT && this.isUnderOrAboveProjectDir(mapping) && !this.isIgnoredOrExcludedPath(mapping) && !this.mySettings.isIgnoredUnregisteredRoot(mapping);
        });
        if (list2 == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(18);
        }
        return list2;
    }

    private boolean areThereExplicitlyIgnoredRoots(Collection<VcsRootError> allErrors) {
        return ContainerUtil.exists(allErrors, it -> it.getType() == VcsRootError.Type.UNREGISTERED_ROOT && this.mySettings.isIgnoredUnregisteredRoot(it.getMapping()));
    }

    @NotNull
    private static Collection<VcsRootError> getInvalidRoots(@NotNull Collection<VcsRootError> errors) {
        if (errors == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(19);
        }
        List list2 = ContainerUtil.filter(errors, error -> error.getType() == VcsRootError.Type.EXTRA_MAPPING);
        if (list2 == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @VisibleForTesting
    @NotNull
    String getPresentableMapping(@NotNull String mapping) {
        if (mapping == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(21);
        }
        String relativePath = null;
        String projectDir = this.myProject.getBasePath();
        if (projectDir != null && FileUtil.isAncestor((String)projectDir, (String)mapping, (boolean)true)) {
            relativePath = "<Project>/" + FileUtil.getRelativePath((String)projectDir, (String)mapping, (char)File.separatorChar);
        }
        if (relativePath == null) {
            relativePath = FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)mapping));
        }
        String string = StringUtil.shortenPathWithEllipsis((String)StringUtil.escapeXml(relativePath), (int)30, (boolean)true);
        if (string == null) {
            VcsRootProblemNotifier.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier";
                break;
            }
            case 3: 
            case 4: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unregisteredRoots";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidRoots";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootError";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 12: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootProblemNotifier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigureNotificationAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "scan";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "makeDescription";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidRootDescriptionItem";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "joinRootsForPresentation";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "makeTitle";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportantUnregisteredMappings";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidRoots";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnderOrAboveProjectDir";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredOrExcludedPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "makeDescription";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidRootDescriptionItem";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "joinRootsForPresentation";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "makeTitle";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getImportantUnregisteredMappings";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidRoots";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

