/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service;

import com.intellij.internal.statistic.connect.StatisticsConnectionService;
import com.intellij.internal.statistic.connect.StatisticsNotification;
import com.intellij.internal.statistic.connect.StatisticsResult;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurableStatisticsService<T extends StatisticsConnectionService>
implements StatisticsService {
    @Override
    public final StatisticsResult send() {
        String serviceUrl = this.getConnectionService().getServiceUrl();
        if (serviceUrl == null) {
            return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR: unknown Statistics Service URL.");
        }
        if (!((StatisticsConnectionService)((Object)this.getConnectionService())).isTransmissionPermitted()) {
            return new StatisticsResult(StatisticsResult.ResultCode.NOT_PERMITTED_SERVER, "NOT_PERMITTED");
        }
        try {
            String sentData = this.sendData();
            StatisticsUploadAssistant.updateSentTime();
            return new StatisticsResult(StatisticsResult.ResultCode.SEND, sentData);
        }
        catch (Exception e) {
            return new StatisticsResult(StatisticsResult.ResultCode.SENT_WITH_ERRORS, e.getMessage() != null ? e.getMessage() : "NPE");
        }
    }

    @Override
    public Notification createNotification(@NotNull String groupDisplayId, @Nullable NotificationListener listener2) {
        if (groupDisplayId == null) {
            ConfigurableStatisticsService.$$$reportNull$$$0(0);
        }
        return new StatisticsNotification(groupDisplayId, listener2);
    }

    @NotNull
    protected abstract String sendData();

    public abstract T getConnectionService();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayId", "com/intellij/internal/statistic/service/ConfigurableStatisticsService", "createNotification"));
    }
}

