/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.generation;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.javascript.boilerplate.GithubProjectGeneratorPeer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.joomla.JoomlaBundle;
import com.jetbrains.php.joomla.JoomlaExtensionType;
import com.jetbrains.php.joomla.generation.JoomlaProjectGeneratorSettings;
import com.jetbrains.php.joomla.generation.JoomlaProjectPeer;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import icons.JoomlaIcons;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JoomlaGithubProjectGenerator
extends WebProjectTemplate<JoomlaProjectGeneratorSettings> {
    public static final String LEFT_SQUARE_BRACKET = "\\[";
    private static final Logger LOG = Logger.getInstance(JoomlaGithubProjectGenerator.class);
    private static final String RIGHT_SQUARE_BRACKET = "\\]";

    private static void removeFiles(@NotNull JoomlaProjectGeneratorSettings settings, File virtualToIoFile) {
        if (settings == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(0);
        }
        JoomlaExtensionType extensionType = settings.getJoomlaState().getJoomlaExtensionType();
        File[] listFiles = virtualToIoFile.listFiles();
        if (listFiles != null) {
            for (File it : listFiles) {
                if (it.getName().equals(extensionType.getFolderName()) || it.getName().equals("LICENSE")) continue;
                FileUtil.delete((File)it);
            }
        }
    }

    private static void showErrorMessage(@NotNull String message) {
        if (message == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(1);
        }
        String fullMessage = "Error creating Joomla extension. " + message;
        Notifications.Bus.notify((Notification)new Notification(JoomlaBundle.message("joomla.plugin.extension.generator", new Object[0]), JoomlaBundle.message("joomla.plugin.extension.generator", new Object[0]), fullMessage, NotificationType.ERROR));
    }

    private static void replaceInCode(@NotNull Project project, @NonNls String directoryName, ProjectFileIndex index) {
        if (project == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(2);
        }
        index.iterateContent(fileOrDir -> {
            Document document;
            if (project == null) {
                JoomlaGithubProjectGenerator.$$$reportNull$$$0(16);
            }
            if (!fileOrDir.isDirectory() && (document = FileDocumentManager.getInstance().getDocument(fileOrDir)) != null) {
                String documentText = document.getText();
                documentText = documentText.replaceAll("foo", directoryName);
                documentText = documentText.replaceAll("FOO", directoryName.toUpperCase());
                char firstChar = directoryName.charAt(0);
                char upperCase = Character.toUpperCase(firstChar);
                documentText = documentText.replaceAll("Foo", upperCase + directoryName.substring(1));
                FileTemplateManager manager = FileTemplateManager.getInstance((Project)project);
                Properties properties = manager.getDefaultProperties();
                documentText = JoomlaGithubProjectGenerator.convertProperty(documentText, properties, "DATE");
                documentText = JoomlaGithubProjectGenerator.convertProperty(documentText, properties, "PROJECT_NAME");
                documentText = JoomlaGithubProjectGenerator.convertProperty(documentText, properties, "AUTHOR", "USER");
                documentText = JoomlaGithubProjectGenerator.setTag(documentText, "AUTHOR_EMAIL", "your@email.com");
                documentText = JoomlaGithubProjectGenerator.setTag(documentText, "AUTHOR_URL", "http://your.url.com");
                documentText = JoomlaGithubProjectGenerator.setTag(documentText, "COPYRIGHT", "A copyright");
                String finalText = documentText = JoomlaGithubProjectGenerator.setTag(documentText, "PACKAGE_NAME", project.getName());
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project == null) {
                        JoomlaGithubProjectGenerator.$$$reportNull$$$0(17);
                    }
                    document.setText((CharSequence)finalText);
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                });
            }
            return true;
        });
    }

    private static String setTag(String documentText, String email, String replacement) {
        return documentText.replaceAll(LEFT_SQUARE_BRACKET + email + RIGHT_SQUARE_BRACKET, replacement);
    }

    private static String convertProperty(String documentText, Properties properties, String arg) {
        return documentText.replaceAll(LEFT_SQUARE_BRACKET + arg + RIGHT_SQUARE_BRACKET, properties.getProperty(arg));
    }

    private static String convertProperty(String documentText, Properties properties, String arg, String property) {
        return documentText.replaceAll(LEFT_SQUARE_BRACKET + arg + RIGHT_SQUARE_BRACKET, properties.getProperty(property));
    }

    public static void performRename(String directoryName, @NotNull File virtualToIoFile) throws IOException {
        if (virtualToIoFile == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(3);
        }
        JoomlaGithubProjectGenerator.renameAllInDirectory(directoryName, virtualToIoFile);
    }

    private static void renameAllInDirectory(String directoryName, @NotNull File directory) throws IOException {
        File[] children;
        if (directory == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(4);
        }
        if ((children = directory.listFiles()) != null) {
            for (File iterator : children) {
                if (iterator.isDirectory()) {
                    JoomlaGithubProjectGenerator.renameAllInDirectory(directoryName, iterator);
                }
                JoomlaGithubProjectGenerator.renameFile(directoryName, iterator);
            }
        }
    }

    private static void renameFile(String directoryName, File iterator) throws IOException {
        String fileName = iterator.getName();
        if (fileName.contains("foo")) {
            FileUtil.rename((File)iterator, (String)fileName.replaceAll("foo", directoryName));
        }
        if (fileName.contains("FOO")) {
            FileUtil.rename((File)iterator, (String)fileName.replaceAll("FOO", directoryName.toUpperCase()));
        }
        if (fileName.contains("Foo")) {
            char firstChar = directoryName.charAt(0);
            char upperCase = Character.toUpperCase(firstChar);
            FileUtil.rename((File)iterator, (String)fileName.replaceAll("Foo", upperCase + directoryName.substring(1)));
        }
    }

    @NotNull
    public String getGithubUserName() {
        if ("joomla-extensions" == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(5);
        }
        return "joomla-extensions";
    }

    @NotNull
    public String getGithubRepositoryName() {
        if ("boilerplate" == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(6);
        }
        return "boilerplate";
    }

    @Nls
    @NotNull
    public String getName() {
        String string = JoomlaBundle.message("joomla.plugin.extension.generator", new Object[0]);
        if (string == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return "Project generator for Joomla! extensions <br>";
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull JoomlaProjectGeneratorSettings settings, @NotNull Module module) {
        if (project == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(8);
        }
        if (baseDir == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(10);
        }
        if (module == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(11);
        }
        JoomlaDataService dataService = JoomlaDataService.getInstance(project);
        dataService.setState(settings.getJoomlaState());
        if (!settings.getJoomlaState().getJoomlaExtensionType().equals((Object)JoomlaExtensionType.EMPTY_PROJECT)) {
            this.generateProjectFromGithubBoilerplates(project, baseDir, settings);
        }
    }

    private void generateProjectFromGithubBoilerplates(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull JoomlaProjectGeneratorSettings settings) {
        if (project == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(12);
        }
        if (baseDir == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(14);
        }
        File zipArchiveFile = null;
        File tempDirectory = null;
        try {
            zipArchiveFile = GithubDownloadUtil.findCacheFile((String)this.getGithubUserName(), (String)this.getGithubRepositoryName(), (String)("joomla-" + this.getGithubRepositoryName() + ".zip"));
            String url = GithubProjectGeneratorPeer.getGithubZipballUrl((String)this.getGithubUserName(), (String)this.getGithubRepositoryName(), (String)"master");
            GithubDownloadUtil.downloadContentToFileWithProgressSynchronously((Project)project, (String)url, (String)this.getName(), (File)zipArchiveFile, (String)this.getGithubUserName(), (String)this.getGithubRepositoryName(), (boolean)false);
            String directoryName = baseDir.getName();
            LOG.info("Content of " + url + " has been successfully downloaded to " + zipArchiveFile.getAbsolutePath() + ", size " + zipArchiveFile.length() + " bytes");
            File virtualToIoFile = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
            tempDirectory = FileUtil.createTempDirectory((String)"joomla", (String)"tmp");
            ZipUtil.unzipWithProgressSynchronously((Project)project, (String)this.getName(), (File)zipArchiveFile, (File)tempDirectory, null, (boolean)true);
            JoomlaGithubProjectGenerator.removeFiles(settings, tempDirectory);
            File[] children = tempDirectory.listFiles();
            if (children == null || children.length < 1) {
                throw new GeneratorException("Boilerplates are not downloaded");
            }
            for (File it : children) {
                if (it.getName().equals(settings.getJoomlaState().getJoomlaExtensionType().getFolderName()) && it.isDirectory()) {
                    FileUtil.copyDirContent((File)it, (File)virtualToIoFile);
                    continue;
                }
                FileUtil.copyFileOrDir((File)it, (File)new File(virtualToIoFile, it.getName()));
            }
            FileUtil.delete((File)tempDirectory);
            JoomlaGithubProjectGenerator.performRename(directoryName, virtualToIoFile);
            FileBasedIndex.getInstance().requestReindex(baseDir);
            ApplicationManager.getApplication().runWriteAction(() -> {
                FileDocumentManager.getInstance().saveAllDocuments();
                VirtualFileManager.getInstance().refreshWithoutFileWatcher(false);
            });
            ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
            JoomlaGithubProjectGenerator.replaceInCode(project, directoryName, index);
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)project, (String)JoomlaBundle.message("joomla.error.creating.joomla.plugin.0", e.getMessage()), (String)JoomlaBundle.message("joomla.create.joomla.plugin", new Object[0]));
            if (zipArchiveFile != null) {
                FileUtil.delete((File)zipArchiveFile);
            }
            if (tempDirectory != null) {
                FileUtil.delete(tempDirectory);
            }
            LOG.warn((Throwable)e);
            JoomlaGithubProjectGenerator.showErrorMessage(e.getMessage());
        }
    }

    @NotNull
    public ProjectGeneratorPeer<JoomlaProjectGeneratorSettings> createPeer() {
        JoomlaProjectPeer joomlaProjectPeer = new JoomlaProjectPeer();
        if (joomlaProjectPeer == null) {
            JoomlaGithubProjectGenerator.$$$reportNull$$$0(15);
        }
        return joomlaProjectPeer;
    }

    public Icon getIcon() {
        return JoomlaIcons.Joomla;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualToIoFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/joomla/generation/JoomlaGithubProjectGenerator";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/joomla/generation/JoomlaGithubProjectGenerator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGithubUserName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGithubRepositoryName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createPeer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeFiles";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "replaceInCode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renameAllInDirectory";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateProjectFromGithubBoilerplates";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$replaceInCode$1";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

