/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.library.TypeScriptLibraries;
import com.intellij.lang.typescript.library.TypeScriptLibraryKt;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLibraryProviderImpl
implements TypeScriptLibraryProvider {
    public static final Logger LOG = Logger.getInstance(TypeScriptLibraryProviderImpl.class);
    private static final String TS_LIB_VERSION_KEY = "ts.lib.d.ts.version";
    @NotNull
    private final Project myProject;
    private volatile boolean myBundledRefreshed;
    @NotNull
    private volatile TypeScriptLibraries myCurrentLibrary;
    @NotNull
    private volatile TypeScriptLibraries myBundledLibrary;

    private static void asyncRefreshBundledVersion(@NotNull Runnable completeCallback, @NotNull TypeScriptLibraries bundled, boolean force) {
        if (completeCallback == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(0);
        }
        if (bundled == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(1);
        }
        String key = PropertiesComponent.getInstance().getValue(TS_LIB_VERSION_KEY);
        if (!force && "3.2.1".equals(key)) {
            return;
        }
        PropertiesComponent.getInstance().setValue(TS_LIB_VERSION_KEY, "3.2.1");
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        if (!force && testMode && key == null) {
            return;
        }
        LOG.info("Start refreshing typescript libraries");
        List list = VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])VfsUtilCore.toVirtualFileArray(bundled.getFilesToRefresh()));
        LocalFileSystem.getInstance().refreshFiles((Iterable)list, !testMode, true, () -> {
            if (completeCallback == null) {
                TypeScriptLibraryProviderImpl.$$$reportNull$$$0(39);
            }
            LOG.info("End refreshing typescript libraries");
            completeCallback.run();
        });
    }

    public TypeScriptLibraryProviderImpl(@NotNull Project project, @NotNull TypeScriptServiceDirectoryWatcher watcher) {
        if (project == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(2);
        }
        if (watcher == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(3);
        }
        this.myBundledRefreshed = false;
        this.myProject = project;
        this.myBundledLibrary = new TypeScriptLibraries();
        this.myCurrentLibrary = TypeScriptLibraryKt.getLibraryCandidate(project, this.myBundledLibrary);
        watcher.addListener(() -> this.reloadLibraries());
        TypeScriptLibraryProviderImpl.asyncRefreshBundledVersion(() -> this.reloadBundledLibraries(), this.myBundledLibrary, false);
    }

    private void reloadBundledLibraries() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!this.myBundledRefreshed) {
            TypeScriptLibraries oldLibrary = this.myBundledLibrary;
            TypeScriptLibraries copy = oldLibrary.copy();
            WriteAction.run(() -> {
                this.myBundledLibrary = copy;
                if (oldLibrary == this.myCurrentLibrary) {
                    this.myCurrentLibrary = this.myBundledLibrary;
                }
                if (this.myBundledLibrary.getModificationId() != oldLibrary.getModificationId() && !ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.info("Refresh roots after updating typescript libraries");
                    this.refreshRoots();
                }
                this.myBundledRefreshed = true;
            });
        }
    }

    private void refreshRoots() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.getInstance(), false, true);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getAllBundledLibraries() {
        Collection<VirtualFile> libs = this.myBundledLibrary.getAllLibs();
        Set<VirtualFile> set = TypeScriptLibraryProviderImpl.asSet(this.filterAndRefreshIfRequiredBundled(libs));
        if (set == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getAllCustomLibraries() {
        TypeScriptLibraries library = this.myCurrentLibrary;
        Set<VirtualFile> set = library.isBundled() ? Collections.emptySet() : TypeScriptLibraryProviderImpl.asSet(this.filterAndRefreshIfRequired(library.getAllLibs(), library));
        if (set == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @NotNull
    public GlobalSearchScope getFileTypeRestrictedScope(@NotNull GlobalSearchScope moduleAndLibraryScope, @NotNull VirtualFile file2) {
        if (moduleAndLibraryScope == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(7);
        }
        Collection<TypeScriptConfig> includes = this.getIncludeConfigs(file2);
        TypeScriptLibraries library = this.getEffectiveLibrary();
        Collection<VirtualFile> tsLibs = this.filterAndRefreshIfRequired(this.getPredefinedLibrariesImpl(file2, includes, library), library);
        GlobalSearchScope resultScope = moduleAndLibraryScope.uniteWith(GlobalSearchScope.filesScope((Project)this.myProject, tsLibs));
        TypeScriptConfigService configService = TypeScriptConfigService.Provider.get(this.myProject);
        assert (configService != null);
        if (!configService.hasConfigs()) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)resultScope, (FileType[])TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
            if (globalSearchScope == null) {
                TypeScriptLibraryProviderImpl.$$$reportNull$$$0(8);
            }
            return globalSearchScope;
        }
        final Condition<VirtualFile> accessScope = configService.getAccessScope(file2);
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(resultScope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                if (accessScope.value((Object)file2)) {
                    return true;
                }
                FileType fileType = file2.getFileType();
                return TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(fileType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl$1", "contains"));
            }
        };
        if (delegatingGlobalSearchScope == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(9);
        }
        return delegatingGlobalSearchScope;
    }

    @Override
    public boolean isLibraryFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        return this.myCurrentLibrary.includeFile(file2);
    }

    @Override
    public boolean isLibraryOrBundledLibraryFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        return this.myCurrentLibrary.includeFile(file2) || this.myBundledLibrary != this.myCurrentLibrary && this.myBundledLibrary.includeFile(file2);
    }

    @Override
    public boolean isLibraryFileName(@NotNull String fileName) {
        if (fileName == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(10);
        }
        return this.myCurrentLibrary.includeFileWithName(fileName);
    }

    private void reloadLibraries() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TypeScriptLibraries newLibraries = TypeScriptLibraryKt.getLibraryCandidate(this.myProject, this.myBundledLibrary);
        if (newLibraries.getModificationId() != this.myCurrentLibrary.getModificationId()) {
            WriteAction.run(() -> {
                this.myCurrentLibrary = newLibraries;
                this.refreshRoots();
            });
        }
    }

    @Override
    @Nullable
    public VirtualFile findLibraryByShortName(@NotNull String shortLibraryName) {
        if (shortLibraryName == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(11);
        }
        return this.getEffectiveLibrary().getLibraryByName(shortLibraryName);
    }

    @NotNull
    private Collection<VirtualFile> filterAndRefreshIfRequiredBundled(@NotNull Collection<VirtualFile> libs) {
        boolean hasInvalidFiles;
        if (libs == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(12);
        }
        if (hasInvalidFiles = libs.stream().anyMatch(el -> !el.isValid())) {
            if (!this.myBundledRefreshed) {
                TypeScriptLibraryProviderImpl.asyncRefreshBundledVersion(() -> this.reloadBundledLibraries(), this.myBundledLibrary, true);
            } else {
                LOG.error("Some of the library files are invalidated after refresh");
            }
        }
        Collection collection = hasInvalidFiles ? (Collection)libs.stream().filter(VirtualFile::isValid).collect(Collectors.toSet()) : libs;
        if (collection == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    private Collection<VirtualFile> filterAndRefreshIfRequired(@NotNull Collection<VirtualFile> libs, @NotNull TypeScriptLibraries library) {
        if (libs == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(14);
        }
        if (library == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(15);
        }
        if (library.isBundled()) {
            Collection<VirtualFile> collection = this.filterAndRefreshIfRequiredBundled(libs);
            if (collection == null) {
                TypeScriptLibraryProviderImpl.$$$reportNull$$$0(16);
            }
            return collection;
        }
        Collection collection = libs.stream().filter(VirtualFile::isValid).collect(Collectors.toSet());
        if (collection == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(17);
        }
        return collection;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getPredefinedLibraries(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(18);
        }
        TypeScriptLibraries library = this.getEffectiveLibrary();
        Set<VirtualFile> set = TypeScriptLibraryProviderImpl.asSet(this.filterAndRefreshIfRequired(this.getPredefinedLibrariesImpl(file2, this.getIncludeConfigs(file2), library), library));
        if (set == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(19);
        }
        return set;
    }

    @NotNull
    private Collection<TypeScriptConfig> getIncludeConfigs(@NotNull VirtualFile file2) {
        Collection<TypeScriptConfig> configs;
        if (file2 == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(20);
        }
        if ((configs = TypeScriptConfigService.Provider.getConfigFiles(this.myProject)).size() <= 1 || TypeScriptUtil.isUnderNodeModules(file2, this.myProject)) {
            Collection<TypeScriptConfig> collection = configs;
            if (collection == null) {
                TypeScriptLibraryProviderImpl.$$$reportNull$$$0(21);
            }
            return collection;
        }
        TypeScriptConfig config2 = TypeScriptConfigUtil.getNearestParentConfig(file2, configs);
        Collection<TypeScriptConfig> collection = config2 != null ? Collections.singletonList(config2) : configs;
        if (collection == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(22);
        }
        return collection;
    }

    @NotNull
    public Set<VirtualFile> getPredefinedLibrariesImpl(@NotNull VirtualFile file2, @NotNull Collection<TypeScriptConfig> includes, @NotNull TypeScriptLibraries library) {
        if (file2 == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(23);
        }
        if (includes == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(24);
        }
        if (library == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(25);
        }
        if (includes.isEmpty()) {
            JSLanguageDialect configuredJSVersion = DialectDetector.getConfiguredJSVersion(file2, this.myProject);
            Set<VirtualFile> set = this.getLibraries(configuredJSVersion.getOptionHolder().isECMA6 ? TypeScriptConfig.LanguageTarget.ES6 : TypeScriptConfig.LanguageTarget.ES5, Collections.emptyList(), library);
            if (set == null) {
                TypeScriptLibraryProviderImpl.$$$reportNull$$$0(26);
            }
            return set;
        }
        List additionalLibs = null;
        TypeScriptConfig.LanguageTarget target = null;
        ThreeState noLib = ThreeState.UNSURE;
        for (TypeScriptConfig config2 : includes) {
            Collection<String> names;
            noLib = TypeScriptLibraryProviderImpl.mergeFlags(noLib, config2.noLib());
            boolean hasNoLibOption = config2.noLib();
            if (!hasNoLibOption && config2.getRawCompilerOption("lib") == null) {
                TypeScriptConfig.LanguageTarget tempTarget = TypeScriptLibraryProviderImpl.getDefaultLibraryTarget(config2);
                TypeScriptConfig.LanguageTarget languageTarget = target = target == null || tempTarget.priority > target.priority ? tempTarget : target;
            }
            if ((names = config2.getLibNames()).isEmpty()) continue;
            if (additionalLibs == null) {
                additionalLibs = ContainerUtil.newSmartList();
            }
            additionalLibs.addAll(names);
        }
        if (noLib == ThreeState.YES) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                TypeScriptLibraryProviderImpl.$$$reportNull$$$0(27);
            }
            return set;
        }
        Set<VirtualFile> set = this.getLibraries(target, additionalLibs == null ? Collections.emptyList() : additionalLibs, library);
        if (set == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(28);
        }
        return set;
    }

    private static ThreeState mergeFlags(@NotNull ThreeState state, boolean newValue) {
        if (state == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(29);
        }
        return ThreeState.fromBoolean((boolean)(state == ThreeState.UNSURE ? newValue : state.toBoolean() && newValue));
    }

    @NotNull
    private static TypeScriptConfig.LanguageTarget getDefaultLibraryTarget(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(30);
        }
        TypeScriptConfig.LanguageTarget languageTarget = config2.getLanguageTarget();
        if (languageTarget == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(31);
        }
        return languageTarget;
    }

    @NotNull
    private Set<VirtualFile> getLibraries(@Nullable TypeScriptConfig.LanguageTarget target, @NotNull List<String> additionalLibs, @NotNull TypeScriptLibraries library) {
        if (additionalLibs == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(32);
        }
        if (library == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(33);
        }
        Set<VirtualFile> mainLibs = library.getLibsForTarget(this.myProject, target);
        if (additionalLibs.isEmpty()) {
            Set<VirtualFile> set = mainLibs;
            if (set == null) {
                TypeScriptLibraryProviderImpl.$$$reportNull$$$0(34);
            }
            return set;
        }
        HashSet result2 = ContainerUtil.newHashSet(mainLibs);
        for (String lib : additionalLibs) {
            result2.addAll(library.getLibraries(this.myProject, lib));
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(35);
        }
        return hashSet;
    }

    @NotNull
    private TypeScriptLibraries getEffectiveLibrary() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TypeScriptLibraries library = this.myCurrentLibrary;
        if (!library.isBundled() && !library.isValid()) {
            library = this.myBundledLibrary;
            this.myCurrentLibrary = this.myBundledLibrary;
            ApplicationManager.getApplication().invokeLater(() -> this.reloadLibraries(), this.myProject.getDisposed());
        }
        TypeScriptLibraries typeScriptLibraries = library;
        if (typeScriptLibraries == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(36);
        }
        return typeScriptLibraries;
    }

    @NotNull
    private static Set<VirtualFile> asSet(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(37);
        }
        Set set = files instanceof Set ? (Set)files : ContainerUtil.newTroveSet(files);
        if (set == null) {
            TypeScriptLibraryProviderImpl.$$$reportNull$$$0(38);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completeCallback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundled";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watcher";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleAndLibraryScope";
                break;
            }
            case 7: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortLibraryName";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libs";
                break;
            }
            case 15: 
            case 25: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includes";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalLibs";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/library/TypeScriptLibraryProviderImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBundledLibraries";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCustomLibraries";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeRestrictedScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAndRefreshIfRequiredBundled";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAndRefreshIfRequired";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraries";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeConfigs";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibrariesImpl";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLibraryTarget";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveLibrary";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "asSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "asyncRefreshBundledVersion";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeRestrictedScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryFileName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryByShortName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterAndRefreshIfRequiredBundled";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterAndRefreshIfRequired";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraries";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeConfigs";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibrariesImpl";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "mergeFlags";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLibraryTarget";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getLibraries";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "asSet";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$asyncRefreshBundledVersion$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

