/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.presentation;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.layout.EdgeLayout;
import com.intellij.openapi.util.Couple;
import java.util.ArrayList;
import java.util.List;

public class EdgeInfo {
    private final String src;
    private final String trg;
    private final List<Couple<Double>> points;

    public EdgeInfo(DiagramEdge edge, DiagramBuilder builder) {
        DiagramProvider provider = builder.getProvider();
        DiagramVfsResolver resolver = provider.getVfsResolver();
        this.src = resolver.getQualifiedName(edge.getSource().getIdentifyingElement());
        this.trg = edge instanceof DiagramNoteEdge ? null : resolver.getQualifiedName(edge.getTarget().getIdentifyingElement());
        EdgeLayout edgeLayout = builder.getGraph().getEdgeLayout((Object)builder.getEdge(edge));
        YPoint sp = edgeLayout.getSourcePoint();
        this.points = new ArrayList<Couple<Double>>();
        this.points.add((Couple<Double>)Couple.of((Object)sp.getX(), (Object)sp.getY()));
        for (int i = 0; i < edgeLayout.pointCount(); ++i) {
            YPoint p = edgeLayout.getPoint(i);
            this.points.add((Couple<Double>)Couple.of((Object)p.getX(), (Object)p.getY()));
        }
        YPoint tp = edgeLayout.getTargetPoint();
        this.points.add((Couple<Double>)Couple.of((Object)tp.getX(), (Object)tp.getY()));
    }

    public EdgeInfo(String src, String trg, List<Couple<Double>> points) {
        this.src = src;
        this.trg = trg;
        this.points = points;
    }

    public String getSrc() {
        return this.src;
    }

    public String getTrg() {
        return this.trg;
    }

    public List<Couple<Double>> getPoints() {
        return this.points;
    }
}

