require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ARM_ARM32_VMPARAM_H_)) {
    eval 'sub _ARM_ARM32_VMPARAM_H_ () {1;}' unless defined(&_ARM_ARM32_VMPARAM_H_);
    if(defined(&_KERNEL_OPT)) {
	require './arm/arm32/opt_kasan.ph';
    }
    require 'sys/cdefs.ph';
    require 'arm/cpuconf.ph';
    require 'arm/arm32/param.ph';
    eval 'sub __USE_TOPDOWN_VM () {1;}' unless defined(&__USE_TOPDOWN_VM);
    eval 'sub USRSTACK () { &VM_MAXUSER_ADDRESS;}' unless defined(&USRSTACK);
    unless(defined(&_ARM_ARCH_5)) {
	eval 'sub PAGER_MAP_DEFAULT_SIZE () {(4* 1024* 1024);}' unless defined(&PAGER_MAP_DEFAULT_SIZE);
    }
    eval 'sub MAXTSIZ () {(128*1024*1024);}' unless defined(&MAXTSIZ);
    unless(defined(&DFLDSIZ)) {
	eval 'sub DFLDSIZ () {(384*1024*1024);}' unless defined(&DFLDSIZ);
    }
    unless(defined(&MAXDSIZ)) {
	eval 'sub MAXDSIZ () {(1856*1024*1024);}' unless defined(&MAXDSIZ);
    }
    unless(defined(&DFLSSIZ)) {
	eval 'sub DFLSSIZ () {(4*1024*1024);}' unless defined(&DFLSSIZ);
    }
    unless(defined(&MAXSSIZ)) {
	eval 'sub MAXSSIZ () {(64*1024*1024);}' unless defined(&MAXSSIZ);
    }
    eval 'sub PAGE_SHIFT () { &PGSHIFT;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub VM_MIN_ADDRESS () {(( &vaddr_t)  &PAGE_SIZE);}' unless defined(&VM_MIN_ADDRESS);
    eval 'sub VM_MAXUSER_ADDRESS () {(( &vaddr_t)  &KERNEL_BASE -  &PAGE_SIZE);}' unless defined(&VM_MAXUSER_ADDRESS);
    eval 'sub VM_MAX_ADDRESS () { &VM_MAXUSER_ADDRESS;}' unless defined(&VM_MAX_ADDRESS);
    eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t)  &KERNEL_BASE);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
    eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t) -( &PAGE_SIZE+1));}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    if(defined(&_KERNEL)) {
	if(defined(&KASAN)) {
	    eval 'sub VM_KERNEL_KASAN_BASE () {0xc0000000;}' unless defined(&VM_KERNEL_KASAN_BASE);
	    eval 'sub VM_KERNEL_KASAN_SIZE () {( &VM_KERNEL_ADDR_SIZE >>  &KASAN_SHADOW_SCALE_SHIFT);}' unless defined(&VM_KERNEL_KASAN_SIZE);
	    eval 'sub VM_KERNEL_KASAN_END () {( &VM_KERNEL_KASAN_BASE +  &VM_KERNEL_KASAN_SIZE);}' unless defined(&VM_KERNEL_KASAN_END);
	    eval 'sub VM_KERNEL_VM_END () { &VM_KERNEL_KASAN_BASE;}' unless defined(&VM_KERNEL_VM_END);
	} else {
	    eval 'sub VM_KERNEL_VM_END () { &VM_KERNEL_IO_BASE;}' unless defined(&VM_KERNEL_VM_END);
	}
	if(defined(&__HAVE_MM_MD_DIRECT_MAPPED_PHYS)) {
	    if(defined(&KASAN)) {
		die("KASAN\ and\ __HAVE_MM_MD_DIRECT_MAPPED_PHYS\ is\ unsupported");
	    }
	    eval 'sub VM_KERNEL_VM_BASE () {0xc0000000;}' unless defined(&VM_KERNEL_VM_BASE);
	} else {
	    eval 'sub VM_KERNEL_VM_BASE () {0x90000000;}' unless defined(&VM_KERNEL_VM_BASE);
	}
	eval 'sub VM_KERNEL_ADDR_SIZE () {( &VM_KERNEL_VM_END -  &KERNEL_BASE);}' unless defined(&VM_KERNEL_ADDR_SIZE);
	eval 'sub VM_KERNEL_VM_SIZE () {( &VM_KERNEL_VM_END -  &VM_KERNEL_VM_BASE);}' unless defined(&VM_KERNEL_VM_SIZE);
	eval 'sub VM_KERNEL_IO_BASE () {0xf0000000;}' unless defined(&VM_KERNEL_IO_BASE);
	eval 'sub VM_KERNEL_IO_SIZE () {( &VM_MAX_KERNEL_ADDRESS -  &VM_KERNEL_IO_BASE);}' unless defined(&VM_KERNEL_IO_SIZE);
    }
}
1;
