/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.elements.FullyQualifiedElement;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class WhereUsedPanel
extends JPanel
implements CustomRefactoringPanel {
    private final transient WhereUsedSupport usage;
    private final transient ChangeListener parent;
    private boolean initialized = false;
    private String methodDeclaringSuperClass = null;
    private String methodDeclaringClass = null;
    private ButtonGroup buttonGroup;
    private JRadioButton c_directOnly;
    private JRadioButton c_subclasses;
    private JRadioButton c_usages;
    private JPanel classesPanel;
    private JPanel commentsPanel;
    private JComboBox elementComboBox;
    private JLabel elementLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel label;
    private JCheckBox m_isBaseClass;
    private JCheckBox m_overriders;
    private JCheckBox m_usages;
    private JPanel methodsPanel;
    private JCheckBox searchInComments;

    public WhereUsedPanel(String name, WhereUsedSupport e, ChangeListener parent) {
        this.setName(new MessageFormat(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_WhereUsed")).format(new Object[]{name}));
        this.usage = e;
        this.parent = parent;
        this.initComponents();
        this.searchInComments.setEnabled(false);
        this.searchInComments.setVisible(false);
        this.elementComboBox.setRenderer(new ModelElementRenderer());
    }

    String getMethodDeclaringClass() {
        return this.isMethodFromBaseClass() ? this.methodDeclaringSuperClass : this.methodDeclaringClass;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WhereUsedPanel.this.setupPanels();
            }
        });
        this.initialized = true;
    }

    private void setupPanels() {
        ModelElement elem = this.usage.getModelElement();
        assert (elem != null);
        String name = this.usage.getName();
        String clsName = null;
        if (this.usage.getModelElements().size() == 1) {
            if (elem instanceof FullyQualifiedElement && !(elem instanceof MethodScope)) {
                name = ((FullyQualifiedElement)elem).getFullyQualifiedName().toString();
            }
            if (elem.getInScope() instanceof TypeScope) {
                clsName = ((TypeScope)elem.getInScope()).getFullyQualifiedName().toString();
            }
        } else if (elem.getInScope() instanceof TypeScope) {
            clsName = "?";
        }
        String bKey = this.bundleKeyForLabel();
        Set<Modifier> modifiers = this.usage.getModifiers();
        String lblText = name;
        if (bKey != null) {
            lblText = clsName != null ? NbBundle.getMessage(WhereUsedPanel.class, (String)bKey, (Object)name, (Object)clsName) : NbBundle.getMessage(WhereUsedPanel.class, (String)bKey, (Object)name);
        }
        this.handleElementsCombo(this.usage.getModelElements());
        this.remove(this.classesPanel);
        this.remove(this.methodsPanel);
        this.m_overriders.setVisible(false);
        this.label.setText(lblText);
        if (this.usage.getKind() == PhpElementKind.METHOD) {
            this.add((Component)this.methodsPanel, "Center");
            this.methodsPanel.setVisible(true);
            this.m_usages.setVisible(!modifiers.contains(Modifier.STATIC));
            ModelElement modelElement = this.usage.getModelElement();
            if (modelElement != null) {
                PhpModifiers phpModifiers = modelElement.getPhpModifiers();
                this.m_overriders.setVisible(!phpModifiers.isFinal() && !phpModifiers.isPrivate() && !phpModifiers.isStatic());
            }
            if (this.methodDeclaringSuperClass != null) {
                this.m_isBaseClass.setVisible(true);
                this.m_isBaseClass.setSelected(true);
            } else {
                this.m_isBaseClass.setVisible(false);
                this.m_isBaseClass.setSelected(false);
            }
        } else if (this.usage.getKind() == PhpElementKind.CLASS) {
            this.add((Component)this.classesPanel, "Center");
            this.classesPanel.setVisible(true);
        } else if (this.usage.getKind() == PhpElementKind.IFACE) {
            this.add((Component)this.classesPanel, "Center");
            this.classesPanel.setVisible(true);
        } else {
            this.remove(this.classesPanel);
            this.remove(this.methodsPanel);
            this.c_subclasses.setVisible(false);
            this.m_usages.setVisible(false);
            this.c_usages.setVisible(false);
            this.c_directOnly.setVisible(false);
        }
        this.validate();
    }

    private void handleElementsCombo(List<ModelElement> elements) {
        this.elementComboBox.setModel(new DefaultComboBoxModel<ModelElement>(new Vector<ModelElement>(elements)));
        this.elementComboBox.setSelectedIndex(0);
        if (elements.size() == 1) {
            this.elementLabel.setVisible(false);
            this.elementComboBox.setVisible(false);
        }
    }

    private String bundleKeyForLabel() {
        String bundleKey = null;
        switch (this.usage.getKind()) {
            case IFACE: {
                bundleKey = "DSC_IfaceUsages";
                break;
            }
            case CLASS: {
                bundleKey = "DSC_ClassUsages";
                break;
            }
            case VARIABLE: {
                bundleKey = "DSC_VariableUsages";
                break;
            }
            case FUNCTION: {
                bundleKey = "DSC_FuncUsages";
                break;
            }
            case FIELD: {
                bundleKey = "DSC_FieldUsages";
                break;
            }
            case METHOD: {
                bundleKey = "DSC_MethodUsages";
                break;
            }
            case CONSTANT: {
                bundleKey = "DSC_ConstantUsages";
                break;
            }
            case TYPE_CONSTANT: {
                bundleKey = "DSC_ClassConstantUsages";
                break;
            }
            case USE_ALIAS: {
                bundleKey = "DSC_UseAliasUsages";
                break;
            }
            case TRAIT: {
                bundleKey = "DSC_TraitUsages";
                break;
            }
            default: {
                assert (false) : this.usage.getKind();
                break;
            }
        }
        return bundleKey;
    }

    public WhereUsedSupport getBaseMethod() {
        return this.usage;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.methodsPanel = new JPanel();
        this.m_isBaseClass = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.m_overriders = new JCheckBox();
        this.m_usages = new JCheckBox();
        this.classesPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.c_subclasses = new JRadioButton();
        this.c_usages = new JRadioButton();
        this.c_directOnly = new JRadioButton();
        this.commentsPanel = new JPanel();
        this.label = new JLabel();
        this.elementLabel = new JLabel();
        this.elementComboBox = new JComboBox();
        this.searchInComments = new JCheckBox();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                return WhereUsedPanel.this.m_isBaseClass;
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                return WhereUsedPanel.this.m_isBaseClass;
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                return WhereUsedPanel.this.m_isBaseClass;
            }

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                if (aComponent == WhereUsedPanel.this.c_subclasses) {
                    return WhereUsedPanel.this.c_directOnly;
                }
                if (aComponent == WhereUsedPanel.this.c_usages) {
                    return WhereUsedPanel.this.c_subclasses;
                }
                if (aComponent == WhereUsedPanel.this.searchInComments) {
                    return WhereUsedPanel.this.c_usages;
                }
                if (aComponent == WhereUsedPanel.this.elementComboBox) {
                    return WhereUsedPanel.this.searchInComments;
                }
                return WhereUsedPanel.this.m_isBaseClass;
            }

            @Override
            public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                if (aComponent == WhereUsedPanel.this.c_directOnly) {
                    return WhereUsedPanel.this.c_subclasses;
                }
                if (aComponent == WhereUsedPanel.this.c_subclasses) {
                    return WhereUsedPanel.this.c_usages;
                }
                if (aComponent == WhereUsedPanel.this.c_usages) {
                    return WhereUsedPanel.this.searchInComments;
                }
                if (aComponent == WhereUsedPanel.this.searchInComments) {
                    return WhereUsedPanel.this.elementComboBox;
                }
                return WhereUsedPanel.this.m_isBaseClass;
            }
        });
        this.setLayout(new BorderLayout());
        this.methodsPanel.setLayout(new GridBagLayout());
        this.m_isBaseClass.setSelected(true);
        this.m_isBaseClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.m_isBaseClassActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_isBaseClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.methodsPanel.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.m_overriders, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindOverridingMethods"));
        this.m_overriders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.m_overridersActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_overriders, gridBagConstraints);
        this.m_overriders.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.m_overriders.AccessibleContext.accessibleName"));
        this.m_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.m_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.m_usages.setMargin(new Insets(10, 2, 2, 2));
        this.m_usages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.m_usagesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_usages, gridBagConstraints);
        this.m_usages.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.m_usages.AccessibleContext.accessibleName"));
        this.add((Component)this.methodsPanel, "Center");
        this.classesPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.classesPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.buttonGroup.add(this.c_subclasses);
        Mnemonics.setLocalizedText((AbstractButton)this.c_subclasses, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindAllSubtypes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_subclasses, gridBagConstraints);
        this.c_subclasses.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.c_subclasses.AccessibleContext.accessibleName"));
        this.c_subclasses.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.c_subclasses.AccessibleContext.accessibleDescription"));
        this.buttonGroup.add(this.c_usages);
        this.c_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.c_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.c_usages.setMargin(new Insets(4, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_usages, gridBagConstraints);
        this.c_usages.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.c_usages.AccessibleContext.accessibleName"));
        this.c_usages.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.c_usages.AccessibleContext.accessibleDescription"));
        this.buttonGroup.add(this.c_directOnly);
        Mnemonics.setLocalizedText((AbstractButton)this.c_directOnly, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindDirectSubtypesOnly"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_directOnly, gridBagConstraints);
        this.c_directOnly.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.c_directOnly.AccessibleContext.accessibleName"));
        this.c_directOnly.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.c_directOnly.AccessibleContext.accessibleDescription"));
        this.add((Component)this.classesPanel, "Center");
        Mnemonics.setLocalizedText((JLabel)this.label, (String)"DUMMY");
        this.elementLabel.setLabelFor(this.elementComboBox);
        this.elementLabel.setText(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FromFile"));
        this.searchInComments.setSelected(NbPreferences.forModule(WhereUsedPanel.class).getBoolean("searchInComments.whereUsed", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)NbBundle.getBundle(WhereUsedPanel.class).getString("LBL_SearchInComents"));
        this.searchInComments.setMargin(new Insets(10, 14, 2, 2));
        this.searchInComments.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WhereUsedPanel.this.searchInCommentsItemStateChanged(evt);
            }
        });
        this.searchInComments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.searchInCommentsActionPerformed(evt);
            }
        });
        GroupLayout commentsPanelLayout = new GroupLayout(this.commentsPanel);
        this.commentsPanel.setLayout(commentsPanelLayout);
        commentsPanelLayout.setHorizontalGroup(commentsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(commentsPanelLayout.createSequentialGroup().addGroup(commentsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchInComments).addComponent(this.label).addGroup(commentsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.elementLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.elementComboBox, 0, 263, Short.MAX_VALUE))).addContainerGap()));
        commentsPanelLayout.setVerticalGroup(commentsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(commentsPanelLayout.createSequentialGroup().addComponent(this.label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(commentsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.elementComboBox, -2, -1, -2).addComponent(this.elementLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchInComments)));
        this.label.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.label.AccessibleContext.accessibleName"));
        this.label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.label.AccessibleContext.accessibleDescription"));
        this.elementLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.elementLabel.AccessibleContext.accessibleName"));
        this.elementLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.elementLabel.AccessibleContext.accessibleDescription"));
        this.elementComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.elementComboBox.AccessibleContext.accessibleName"));
        this.elementComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.elementComboBox.AccessibleContext.accessibleDescription"));
        this.searchInComments.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.searchInComments.AccessibleContext.accessibleName"));
        this.searchInComments.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.searchInComments.AccessibleContext.accessibleDescription"));
        this.add((Component)this.commentsPanel, "North");
        this.commentsPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.commentsPanel.AccessibleContext.accessibleName"));
        this.commentsPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.commentsPanel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WhereUsedPanel.class, (String)"WhereUsedPanel.AccessibleContext.accessibleDescription"));
    }

    private void searchInCommentsItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        NbPreferences.forModule(WhereUsedPanel.class).putBoolean("searchInComments.whereUsed", b);
    }

    private void m_isBaseClassActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    private void m_overridersActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    private void m_usagesActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    private void searchInCommentsActionPerformed(ActionEvent evt) {
    }

    public boolean isMethodFromBaseClass() {
        return this.m_isBaseClass.isSelected();
    }

    public boolean isMethodOverriders() {
        return this.m_overriders.isSelected();
    }

    public boolean isClassSubTypes() {
        return this.c_subclasses.isSelected();
    }

    public boolean isClassSubTypesDirectOnly() {
        return this.c_directOnly.isSelected();
    }

    public boolean isMethodFindUsages() {
        return this.m_usages.isSelected();
    }

    public boolean isClassFindUsages() {
        return this.c_usages.isSelected();
    }

    public ModelElement getElement() {
        return (ModelElement)this.elementComboBox.getSelectedItem();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension orig = super.getPreferredSize();
        return new Dimension(orig.width + 30, orig.height + 80);
    }

    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    public Component getComponent() {
        return this;
    }

    private static final class ModelElementRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private static final long serialVersionUID = 87513687675643214L;

        public ModelElementRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ModelElement) {
                this.setName("ComboBox.listRenderer");
                ModelElement element = (ModelElement)value;
                StringBuilder sb = new StringBuilder();
                if (element instanceof FullyQualifiedElement) {
                    sb.append(((FullyQualifiedElement)element).getFullyQualifiedName().toString());
                } else if (element.getInScope() instanceof FullyQualifiedElement) {
                    sb.append(((FullyQualifiedElement)element.getInScope()).getFullyQualifiedName().toString());
                } else {
                    sb.append(element.getName());
                }
                FileObject fileObject = element.getFileObject();
                if (fileObject != null) {
                    sb.append(" (").append(fileObject.getNameExt()).append(")");
                }
                this.setText(sb.toString());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

