/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.groovy.grails.WrapperProcess;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class RuntimeHelper {
    public static final String GRAILS_HOME_PROPERTY = "GRAILS_HOME";
    public static final String WIN_EXECUTABLE_FILE = "grails.bat";
    public static final String WIN_EXECUTABLE = "\\bin\\grails.bat";
    public static final String WIN_DEBUG_EXECUTABLE = "\\bin\\grails-debug.bat";
    public static final String NIX_EXECUTABLE_FILE = "grails";
    public static final String NIX_EXECUTABLE = "/bin/grails";
    public static final String NIX_DEBUG_EXECUTABLE = "/bin/grails-debug";
    public static final String DEB_EXECUTABLE = "/usr/bin/grails";
    public static final String DEB_DEBUG_EXECUTABLE = "/usr/bin/grails-debug";
    public static final String DEB_START_FILE = "/bin/startGrails";
    public static final String DEB_LOCATION = "/usr/share/grails";
    private static final Logger LOGGER = Logger.getLogger(RuntimeHelper.class.getName());

    private RuntimeHelper() {
    }

    public static boolean isValidRuntime(File grailsBase) {
        String pathToBinary = Utilities.isWindows() ? WIN_EXECUTABLE : NIX_EXECUTABLE;
        return new File(grailsBase, pathToBinary).isFile() || RuntimeHelper.isDebian(grailsBase);
    }

    public static boolean isDebian(File grailsBase) {
        return new File(grailsBase, DEB_START_FILE).isFile() && new File(DEB_EXECUTABLE).isFile() && FileUtil.normalizeFile((File)grailsBase).equals(new File(DEB_LOCATION));
    }

    public static File getGrailsExecutable(File grailsBase, boolean debug) {
        assert (grailsBase != null);
        if (grailsBase == null) {
            return null;
        }
        File grailsExecutable = null;
        grailsExecutable = debug ? (Utilities.isWindows() ? new File(grailsBase, WIN_DEBUG_EXECUTABLE) : (RuntimeHelper.isDebian(grailsBase) ? new File(DEB_DEBUG_EXECUTABLE) : new File(grailsBase, NIX_DEBUG_EXECUTABLE))) : (Utilities.isWindows() ? new File(grailsBase, WIN_EXECUTABLE) : (RuntimeHelper.isDebian(grailsBase) ? new File(DEB_EXECUTABLE) : new File(grailsBase, NIX_EXECUTABLE)));
        return grailsExecutable;
    }

    public static String getRuntimeVersion(File grailsBase) {
        if (!RuntimeHelper.isValidRuntime(grailsBase)) {
            return null;
        }
        String version = RuntimeHelper.getRuntimeVersionFromProperties(grailsBase);
        if (version == null) {
            version = RuntimeHelper.getRuntimeVersionFromInvocation(grailsBase);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRuntimeVersionFromProperties(File grailsBase) {
        Properties props = new Properties();
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(grailsBase, "build.properties")));
            try {
                props.load(is);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
        return props.getProperty("grails.version");
    }

    private static String getRuntimeVersionFromInvocation(File grailsBase) {
        File grailsExecutable = RuntimeHelper.getGrailsExecutable(grailsBase, false);
        NbProcessDescriptor grailsProcessDesc = new NbProcessDescriptor(grailsExecutable.getAbsolutePath(), "--version");
        String[] envp = new String[]{"GRAILS_HOME=" + grailsBase.getAbsolutePath(), "JAVA_HOME=" + System.getProperty("java.home")};
        WrapperProcess process = null;
        String preProcessUUID = UUID.randomUUID().toString();
        try {
            process = new WrapperProcess(grailsProcessDesc.exec(null, envp, true, grailsBase), preProcessUUID);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
        try {
            String line;
            ((Process)process).waitFor();
            InputStream stdout = ((Process)process).getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stdout));
            while ((line = reader.readLine()) != null) {
                if (!line.toLowerCase().contains("grails version:")) continue;
                String version = line.split(":")[1];
                return version.trim();
            }
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return null;
    }
}

