/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class StaticStatement
extends Statement {
    private ArrayList<Expression> expressions = new ArrayList();

    private StaticStatement(int start, int end, Expression[] expressions) {
        super(start, end);
        if (expressions == null) {
            throw new IllegalArgumentException();
        }
        this.expressions.addAll(Arrays.asList(expressions));
    }

    public StaticStatement(int start, int end, List<Exception> expressions) {
        this(start, end, expressions == null ? null : expressions.toArray(new Expression[expressions.size()]));
    }

    public Variable[] getVariables() {
        LinkedList<Variable> vars = new LinkedList<Variable>();
        for (Expression node : this.expressions) {
            if (node instanceof Variable) {
                vars.add((Variable)node);
                continue;
            }
            assert (node instanceof Assignment);
            Assignment ass = (Assignment)node;
            vars.add((Variable)ass.getLeftHandSide());
        }
        return vars.toArray(new Variable[vars.size()]);
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Expression expression : this.getExpressions()) {
            sb.append(expression).append(",");
        }
        return "static " + sb.toString();
    }
}

