/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.spi;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javacard.spi.BrokenCard;
import org.netbeans.modules.javacard.spi.Card;
import org.netbeans.modules.javacard.spi.CardState;
import org.netbeans.modules.javacard.spi.CardStateObserver;
import org.netbeans.modules.javacard.spi.ICardCapability;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.capabilities.CapabilitiesProvider;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.WeakSet;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class AbstractCard
implements Card {
    private CardState state = CardState.NEW;
    private final List<CardStateObserver> observers = Collections.synchronizedList(new LinkedList());
    private final Object stateLock = new Object();
    private final InstanceContent content = new InstanceContent();
    private final Lookup lkp = new ProxyLookup(new Lookup[]{Lookups.singleton((Object)this), new AbstractLookup((AbstractLookup.Content)this.content)});
    private final String systemId;
    private static volatile boolean shutdownHookAdded;
    private static Set<Process> processes;
    private final JavacardPlatform platform;
    private volatile boolean initialized;
    private volatile boolean initializing;
    private static volatile boolean inShutdown;

    protected AbstractCard(JavacardPlatform platform, String systemId) {
        this.platform = platform;
        this.systemId = systemId;
    }

    public static Card createBrokenCard(String name) {
        return new BrokenCard(name);
    }

    @Override
    public boolean isValid() {
        return this.platform != null && this.platform.isValid();
    }

    @Override
    public final JavacardPlatform getPlatform() {
        return this.platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setState(CardState state) {
        CardState old;
        Object object = this.stateLock;
        synchronized (object) {
            old = this.state;
            this.state = state;
        }
        if (old != state) {
            CardState oldState;
            try {
                this.onStateChanged(old, state);
                oldState = old;
            }
            catch (Throwable throwable) {
                CardState oldState2 = old;
                Mutex.EVENT.readAccess(new Runnable(oldState2, state){
                    final /* synthetic */ CardState val$oldState;
                    final /* synthetic */ CardState val$state;
                    {
                        this.val$oldState = cardState;
                        this.val$state = cardState2;
                    }

                    @Override
                    public void run() {
                        CardStateObserver[] l;
                        for (CardStateObserver lis : l = AbstractCard.this.observers.toArray(new CardStateObserver[0])) {
                            lis.onStateChange(AbstractCard.this, this.val$oldState, this.val$state);
                        }
                    }
                });
                throw throwable;
            }
            Mutex.EVENT.readAccess(new /* invalid duplicate definition of identical inner class */);
        }
    }

    protected void onStateChanged(CardState old, CardState nue) {
    }

    @Override
    public final <T extends ICardCapability> T getCapability(Class<T> type) {
        return (T)((ICardCapability)this.getLookup().lookup(type));
    }

    @Override
    public final Set<Class<? extends ICardCapability>> getSupportedCapabilities() {
        CapabilitiesProvider prov = (CapabilitiesProvider)this.getLookup().lookup(CapabilitiesProvider.class);
        if (prov == null) {
            throw new IllegalStateException("No CapabilitiesProvider found in lookup");
        }
        HashSet<Class<? extends ICardCapability>> result = new HashSet<Class<? extends ICardCapability>>();
        result.addAll(prov.getSupportedCapabilityTypes());
        for (Class<ICardCapability> clazz : this.getClass().getInterfaces()) {
            if (!clazz.isAssignableFrom(ICardCapability.class)) continue;
            result.add(clazz);
        }
        return result;
    }

    protected final void initCapabilities(ICardCapability ... capabilities) {
        this.content.set(Arrays.asList(capabilities), null);
    }

    @Override
    public final Set<Class<? extends ICardCapability>> getEnabledCapabilities() {
        HashSet<Class<? extends ICardCapability>> result = new HashSet<Class<? extends ICardCapability>>();
        for (Lookup.Item it : this.lkp.lookupResult(ICardCapability.class).allItems()) {
            result.add(it.getType());
        }
        return result;
    }

    @Override
    public final boolean isCapabilityEnabled(Class<? extends ICardCapability> type) {
        return this.getEnabledCapabilities().contains(type);
    }

    @Override
    public final boolean isCapabilitySupported(Class<? extends ICardCapability> type) {
        return this.getSupportedCapabilities().contains(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CardState getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    @Override
    public final void addCardStateObserver(CardStateObserver obs) {
        this.observers.add(obs);
    }

    @Override
    public final void removeCardStateObserver(CardStateObserver obs) {
        this.observers.remove(obs);
    }

    @Override
    public final String getSystemId() {
        return this.systemId;
    }

    Lookup createPreloadLookup() {
        return Lookup.EMPTY;
    }

    public final Lookup getLookup() {
        if (this.initializing) {
            return this.createPreloadLookup();
        }
        if (!this.initialized) {
            this.initializing = true;
            try {
                this.onBeforeFirstLookup();
                this.initialized = true;
            }
            finally {
                this.initializing = false;
            }
        }
        return this.lkp;
    }

    protected void onBeforeFirstLookup() {
    }

    protected final void addCapability(ICardCapability c) {
        Object old;
        Logger log = Logger.getLogger(AbstractCard.class.getName());
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Add Capability {0} to {1}", new Object[]{c, this});
        }
        this.logAddition(c);
        if (!this.initializing && (old = this.getLookup().lookup(c.getClass())) != null) {
            this.content.remove(old);
        }
        this.content.add((Object)c);
        assert (new HashSet(this.getLookup().lookupAll(c.getClass())).size() == this.getLookup().lookupAll(c.getClass()).size()) : "Lookup should not contain multiple instances of " + c.getClass() + "(" + this.getLookup().lookupAll(c.getClass());
    }

    void logAddition(ICardCapability c) {
    }

    protected final void removeCapability(ICardCapability c) {
        this.content.remove((Object)c);
    }

    protected <T extends Class<? extends ICardCapability>> void removeCapability(T type) {
        Object t = this.getLookup().lookup(type);
        if (t != null) {
            this.content.remove(t);
        }
    }

    protected void registerProcess(Process p) {
        processes.add(p);
        AbstractCard.installShutdownHook();
    }

    private static void installShutdownHook() {
        if (!shutdownHookAdded) {
            shutdownHookAdded = true;
            Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new Shutdown(), "JavaCard Server Process Destroyer Shutdown Hook"));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCard other = (AbstractCard)obj;
        if (this.systemId == null ? other.systemId != null : !this.systemId.equals(other.systemId)) {
            return false;
        }
        return this.platform == other.platform || this.platform != null && ((Object)((Object)this.platform)).equals((Object)other.platform);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.systemId != null ? this.systemId.hashCode() : 0);
        hash = 11 * hash + (this.platform != null ? ((Object)((Object)this.platform)).hashCode() : 0);
        return hash;
    }

    static {
        processes = Collections.synchronizedSet(new WeakSet());
    }

    private static final class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        @Override
        public void run() {
            inShutdown = true;
            for (Process p : processes) {
                if (p == null) continue;
                p.destroy();
            }
        }
    }
}

