/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints;

import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Gen;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.HandlerCommand;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.utils.ListMapItem;

public final class Handler
implements ListMapItem {
    private NativeDebugger debugger;
    private NativeBreakpoint breakpoint;
    private boolean isFired = false;
    private int id;
    private String error;
    private boolean inProgress;

    public Handler(NativeDebugger debugger, NativeBreakpoint breakpoint) {
        assert (breakpoint != null);
        assert (debugger != null);
        this.debugger = debugger;
        this.breakpoint = breakpoint;
        breakpoint.setHandler(this);
        breakpoint.bindTo(debugger);
    }

    private static NativeDebuggerManager manager() {
        return NativeDebuggerManager.get();
    }

    public NativeBreakpoint breakpoint() {
        return this.breakpoint;
    }

    public void setError(String error) {
        this.error = error;
        this.updateAndParent();
    }

    public String getError() {
        return this.error;
    }

    public void setId(int id) {
        this.id = id;
        this.breakpoint.setId(id);
        this.update();
    }

    public int getId() {
        return this.id;
    }

    @Override
    public boolean hasKey() {
        return this.id > 0;
    }

    @Override
    public Object getKey() {
        return this.id;
    }

    public boolean isFired() {
        return this.isFired;
    }

    public void setFired(boolean fired) {
        if (this.isFired == fired) {
            return;
        }
        this.isFired = fired;
        this.updateAndParent();
    }

    public void setDefunct(boolean on) {
        if (on) {
            this.setError("defunct");
        } else {
            this.setError(null);
        }
    }

    public void postEnable(boolean enabled, int routingToken) {
        if (Log.Bpt.enabling) {
            System.out.println(">  H postEnable(" + enabled + ")");
        }
        if (!this.breakpoint().hasHandler()) {
            this.setEnabled(enabled);
        } else {
            this.debugger.bm().provider().postEnableHandler(routingToken, this.getId(), enabled);
        }
    }

    public void setEnabled(boolean enabled) {
        if (Log.Bpt.enabling) {
            System.out.println("<  H setEnabled(" + enabled + ")");
        }
        this.breakpoint.setEnabled(enabled);
    }

    public void setCount(int count) {
        this.breakpoint.setCount(count);
        this.update();
    }

    public void setCountLimit(int limit, boolean b) {
        this.breakpoint.setCountLimit(limit, b);
        this.update();
    }

    public void cleanup() {
        this.breakpoint.cleanup();
        this.breakpoint().setHandler(null);
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    private void update() {
        if (this.id == 0) {
            return;
        }
        this.breakpoint().update();
    }

    private void updateAndParent() {
        if (this.id == 0) {
            return;
        }
        this.breakpoint().updateAndParent();
    }

    public static void postNewHandler(NativeDebugger debugger, NativeBreakpoint newBpt, int routingToken) {
        newBpt.seedToplevelAnnotations();
        if (debugger != null) {
            if (!debugger.isConnected()) {
                return;
            }
            HandlerCommand cmd = debugger.bm().provider().handlerExpert().commandFormNew(newBpt);
            debugger.bm().postCreateHandler(routingToken, cmd, newBpt);
        } else {
            Handler.manager().breakpointBag().add(newBpt);
            Handler.manager().bringDownDialog();
        }
    }

    public static void postChange(NativeDebugger debugger, NativeBreakpoint targetBreakpoint, NativeBreakpoint editedBreakpoint, Gen gen) {
        assert (editedBreakpoint.isEditable()) : "Handler.postChange(): changing a NativeBreakpoint which isn't editable";
        HandlerCommand cmd = debugger.bm().provider().handlerExpert().commandFormCustomize(editedBreakpoint, targetBreakpoint);
        if (targetBreakpoint.isBroken()) {
            debugger.bm().postRepairHandler(editedBreakpoint, cmd, targetBreakpoint, gen);
        } else {
            debugger.bm().postChangeHandler(editedBreakpoint, cmd, targetBreakpoint, gen);
        }
    }
}

