/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.modules.cnd.debugger.common2.debugger.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.FormatOption;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.viewmodel.Models;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class EvaluationWindow
extends TopComponent {
    private static final String preferredID = "EvaluationWindow";
    private static EvaluationWindow DEFAULT;
    private transient JComponent tree = null;
    private String name = Catalog.get("TITLE_EvaluationWindow");
    private String view_name = Catalog.get("TITLE_EvaluationView");
    private volatile NativeDebugger debugger = null;
    private JMenuItem menuItemClear;
    private JPopupMenu popup;
    private JTextArea ta;
    private JScrollPane ta_sp;
    private JPanel hp;
    private JPanel cp;
    private PopupListener popupListener;
    private String expr;
    private JComboBox format_jcb;
    private FormatListener format_listener;
    private FormatOption format;
    private JComboBox exprList;
    private String selected_text = null;

    public static synchronized EvaluationWindow getDefault() {
        if (DEFAULT == null && (DEFAULT = (EvaluationWindow)WindowManager.getDefault().findTopComponent(preferredID)) == null) {
            DEFAULT = new EvaluationWindow();
        }
        return DEFAULT;
    }

    public EvaluationWindow() {
        super.setName(this.name);
        String iconDir = "org/netbeans/modules/cnd/debugger/common2/icons/";
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/debugger/common2/icons/evaluate_expression.png"));
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void requestActive() {
        super.requestActive();
        if (this.exprList != null) {
            this.exprList.requestFocusInWindow();
        }
    }

    protected void componentHidden() {
        if (this.exprList != null) {
            this.exprList.setSelectedIndex(0);
        }
        if (this.debugger != null) {
            this.debugger.registerEvaluationWindow(null);
        }
    }

    public void componentShowing() {
        super.componentShowing();
        boolean update = this.connectToDebugger(NativeDebuggerManager.get().currentDebugger());
        if (update) {
            this.updateWindow();
            this.updateFormats();
        }
    }

    protected void componentClosed() {
        super.componentClosed();
        if (this.debugger != null) {
            this.debugger.registerEvaluationWindow(null);
            this.ta.setText(null);
            this.ta.setCaretPosition(0);
            this.exprList.setSelectedIndex(0);
            this.invalidate();
        }
    }

    private boolean connectToDebugger(NativeDebugger debugger) {
        boolean res = this.debugger != debugger;
        this.debugger = debugger;
        if (debugger != null) {
            debugger.registerEvaluationWindow(this);
        }
        return res;
    }

    private void updateFormats() {
        FormatOption[] evalFormats;
        FormatOption[] formatOptionArray = evalFormats = this.debugger != null ? this.debugger.getEvalFormats() : null;
        if (evalFormats != null) {
            this.format_jcb.setModel(new DefaultComboBoxModel<FormatOption>(evalFormats));
            this.format_jcb.setEnabled(true);
        } else {
            this.format_jcb.setModel(new DefaultComboBoxModel<FormatOption>(new FormatOption[]{FormatOption.EMPTY}));
            this.format_jcb.setEnabled(false);
        }
        this.updateSelectedFormat();
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTipText() {
        return this.view_name;
    }

    private void evaluateTypedExpression() {
        this.exprEval(this.exprList.getEditor().getItem().toString());
    }

    public void exprEval(String expr) {
        this.expr = expr;
        this.format = (FormatOption)this.format_jcb.getSelectedItem();
        if (expr != null && !expr.equals("")) {
            this.debugger.exprEval(this.format == null ? FormatOption.EMPTY : this.format, expr);
        }
    }

    private int exprMap(String expr) {
        for (int i = 0; i < this.exprList.getItemCount(); ++i) {
            if (!expr.equals((String)this.exprList.getItemAt(i))) continue;
            return i;
        }
        return -1;
    }

    public void evalResult(String result) {
        int index;
        int i;
        if (result == null) {
            return;
        }
        if (result.length() == 0) {
            result = " ";
        }
        if ((i = result.indexOf(" =")) == -1) {
            i = result.length() - 1;
        }
        if ((index = this.exprMap(this.expr)) == -1) {
            this.exprList.addItem(this.expr);
        }
        result = result.replace("\\n", "\n");
        this.ta.append(result);
        this.ta.setCaretPosition(this.ta.getDocument().getLength());
        this.updateWindow();
    }

    private void updateWindow() {
        if (this.tree == null) {
            this.ta = new JTextArea();
            this.ta_sp = new JScrollPane(this.ta);
            this.setLayout(new BorderLayout());
            this.tree = Models.createView((Models.CompoundModel)Models.EMPTY_MODEL);
            this.tree.setName(this.view_name);
            this.ta.setEditable(false);
            this.ta.setWrapStyleWord(false);
            Font f = this.ta.getFont();
            this.ta.setFont(new Font("Monospaced", f.getStyle(), f.getSize()));
            this.hp = new JPanel(new BorderLayout());
            this.expr = "";
            this.cp = new JPanel(new GridBagLayout());
            this.cp.setToolTipText("Control panel to specify Expression. Use pop-up menu to specify output format.");
            JLabel cp_text1 = new JLabel(Catalog.get("LBL_Expression"));
            cp_text1.setToolTipText(Catalog.get("HINT_Expression"));
            this.exprList = new JComboBox();
            this.exprList.setMaximumSize(this.cp.getPreferredSize());
            this.exprList.addItem(this.expr);
            this.exprList.setEditable(true);
            this.exprList.setEditor(new ComboBoxEditor(){
                private ExpressionEditorPane pane = new ExpressionEditorPane();

                @Override
                public Component getEditorComponent() {
                    FileObject file = EditorContextDispatcher.getDefault().getMostRecentFile();
                    int line = EditorContextDispatcher.getDefault().getMostRecentLineNumber();
                    if (file != null && line != -1) {
                        DialogBinding.bindComponentToFile((FileObject)file, (int)line, (int)0, (int)0, (JTextComponent)this.pane);
                    }
                    return this.pane;
                }

                @Override
                public void setItem(Object anObject) {
                    if (anObject != null) {
                        this.pane.setText(anObject.toString());
                    } else {
                        this.pane.setText("");
                    }
                }

                @Override
                public Object getItem() {
                    return this.pane.getText();
                }

                @Override
                public void selectAll() {
                    this.pane.selectAll();
                }

                @Override
                public void addActionListener(ActionListener l) {
                    this.pane.addActionListener(l);
                }

                @Override
                public void removeActionListener(ActionListener l) {
                    this.pane.removeActionListener(l);
                }

                class ExpressionEditorPane
                extends JEditorPane {
                    private ArrayList<ActionListener> listeners;

                    public ExpressionEditorPane() {
                        super("text/x-c++", "");
                        this.listeners = new ArrayList();
                        EvaluationWindow.this.restrictEvents(this.getInputMap(), new int[]{10, 27, 9});
                    }

                    @Override
                    protected void processKeyEvent(KeyEvent e) {
                        super.processKeyEvent(e);
                        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
                        if (401 == e.getID() && enter.equals(ks) && !e.isConsumed()) {
                            for (ActionListener actionListener : this.listeners) {
                                actionListener.actionPerformed(new ActionEvent(this, 0, e.toString()));
                            }
                            return;
                        }
                    }

                    public void addActionListener(ActionListener l) {
                        this.listeners.add(l);
                    }

                    public void removeActionListener(ActionListener l) {
                        this.listeners.remove(l);
                    }
                }
            });
            this.exprList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ("comboBoxChanged".equals(e.getActionCommand()) && EvaluationWindow.this.exprList.isPopupVisible()) {
                        EvaluationWindow.this.evaluateTypedExpression();
                    }
                }
            });
            this.exprList.getEditor().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EvaluationWindow.this.evaluateTypedExpression();
                }
            });
            JLabel cp_text3 = new JLabel(Catalog.get("LBL_Format"));
            cp_text3.setToolTipText(Catalog.get("HINT_Output_format"));
            this.format_listener = new FormatListener();
            this.format_jcb = new JComboBox();
            this.updateFormats();
            this.format_jcb.addActionListener(this.format_listener);
            int gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 0, 8, 0);
            this.cp.add((Component)cp_text1, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            gridBagConstraints.weightx = 1.0;
            this.cp.add((Component)this.exprList, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            this.cp.add((Component)cp_text3, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            this.cp.add((Component)this.format_jcb, gridBagConstraints);
            this.tree.add((Component)this.hp, "North");
            this.tree.add((Component)this.ta_sp, "Center");
            this.tree.add((Component)this.cp, "South");
            AccessibleContext ac = this.tree.getAccessibleContext();
            ac.setAccessibleDescription("Window to view  expression");
            ac.setAccessibleName(Catalog.get("TITLE_EvaluationView"));
            this.add(this.tree, "Center");
            this.popup = new JPopupMenu();
            this.popupListener = new PopupListener(this.popup);
            this.menuItemClear = new JMenuItem(new ClearBufferAction());
            this.popup.add(this.menuItemClear);
            this.ta.addMouseListener(this.popupListener);
            this.ta.setText(null);
            this.ta.setCaretPosition(0);
            this.restrictEvents(this.exprList.getInputMap(1), 10, 27, 9);
        }
        this.invalidate();
    }

    private final void restrictEvents(InputMap im, int ... events) {
        String NO_ACTION = "no-action";
        for (int event : events) {
            KeyStroke ks = KeyStroke.getKeyStroke(event, 0);
            im.put(ks, "no-action");
        }
    }

    private void updateSelectedFormat() {
        if (this.format != null) {
            this.format_jcb.setSelectedItem(this.format);
            if (this.format_jcb.getSelectedItem() != null) {
                return;
            }
        }
        this.format_jcb.setSelectedIndex(0);
    }

    protected void FollowSelectedPointer(String s) {
        int i;
        for (i = 0; i < s.length() && (s.charAt(i) == ' ' || s.charAt(i) == '\t'); ++i) {
        }
        if (i > 0 && i < s.length()) {
            s = s.substring(i);
        }
        for (i = 0; i < s.length() && s.charAt(i) != ':' && s.charAt(i) != ';' && s.charAt(i) != ' ' && s.charAt(i) != '\t'; ++i) {
        }
        if (i > 0 && i < s.length()) {
            s = s.substring(0, i);
        }
        if (s.length() > 0) {
            this.expr = s;
        }
        this.evaluateTypedExpression();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(preferredID);
    }

    class FollowSelectedPointerAction
    extends AbstractAction {
        public FollowSelectedPointerAction() {
            super("Follow Selected Pointer", new ImageIcon("paste.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            EvaluationWindow.this.FollowSelectedPointer(EvaluationWindow.this.selected_text);
        }
    }

    class ClearBufferAction
    extends AbstractAction {
        public ClearBufferAction() {
            super("Clear", new ImageIcon("org/netbeans/modules/cnd/debugger/common2/icons/Pointers.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            EvaluationWindow.this.ta.setText(null);
            EvaluationWindow.this.ta.setCaretPosition(0);
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                EvaluationWindow.this.menuItemClear.setEnabled(true);
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class FormatListener
    implements ActionListener {
        private FormatListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            String ac = ev.getActionCommand();
            if (ac.equals("comboBoxChanged")) {
                EvaluationWindow.this.evaluateTypedExpression();
            }
        }
    }
}

