/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import org.netbeans.lib.nbjavac.services.NBParserFactory;

class TranslatePositionsVisitor
extends TreeScanner<Void, Void> {
    private final MethodTree changedMethod;
    private final EndPosTable endPos;
    private final int delta;
    boolean active;
    boolean inMethod;

    public TranslatePositionsVisitor(MethodTree changedMethod, EndPosTable endPos, int delta) {
        assert (changedMethod != null);
        assert (endPos != null);
        this.changedMethod = changedMethod;
        this.endPos = endPos;
        this.delta = delta;
    }

    @Override
    public Void scan(Tree node, Void p) {
        Integer pos;
        if (this.active && node != null && ((JCTree)node).pos >= 0) {
            ((JCTree)node).pos += this.delta;
        }
        Void result = (Void)super.scan(node, p);
        if (this.inMethod && node != null) {
            this.endPos.replaceTree((JCTree)node, null);
        }
        if (this.active && node != null && (pos = Integer.valueOf(this.endPos.replaceTree((JCTree)node, null))) != null) {
            int newPos = pos < 0 ? pos : pos + this.delta;
            ((NBParserFactory.NBJavacParser.EndPosTableImpl)this.endPos).storeEnd((JCTree)node, newPos);
        }
        return result;
    }

    @Override
    public Void visitCompilationUnit(CompilationUnitTree node, Void p) {
        return (Void)this.scan(node.getTypeDecls(), p);
    }

    @Override
    public Void visitMethod(MethodTree node, Void p) {
        if (this.active || this.inMethod) {
            this.scan((Tree)node.getModifiers(), p);
            this.scan(node.getReturnType(), p);
            this.scan(node.getTypeParameters(), p);
            this.scan(node.getParameters(), p);
            this.scan(node.getThrows(), p);
        }
        if (node == this.changedMethod) {
            this.inMethod = true;
        }
        if (this.active || this.inMethod) {
            this.scan((Tree)node.getBody(), p);
        }
        if (this.inMethod) {
            this.active = this.inMethod;
            this.inMethod = false;
        }
        if (this.active || this.inMethod) {
            this.scan(node.getDefaultValue(), p);
        }
        return null;
    }

    @Override
    public Void visitVariable(VariableTree node, Void p) {
        JCTree.JCVariableDecl varDecl = (JCTree.JCVariableDecl)node;
        if (varDecl.sym != null && this.active && varDecl.sym.pos >= 0) {
            varDecl.sym.pos += this.delta;
        }
        return (Void)super.visitVariable(node, p);
    }
}

