/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GestureSubmitter {
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.profiler");

    public static void logProfileApp(Lookup.Provider p, ProfilingSettings ps) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        GestureSubmitter.fillProjectParam(p, paramList);
        GestureSubmitter.fillParamsForProfiling(ps, paramList);
        GestureSubmitter.logUsage("PROFILE_APP", paramList);
    }

    public static void logAttachApp(Lookup.Provider p, ProfilingSettings ps, AttachSettings as) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        GestureSubmitter.fillProjectParam(p, paramList);
        GestureSubmitter.fillParamsForProfiling(ps, paramList);
        GestureSubmitter.fillParamsForAttach(as, paramList);
        GestureSubmitter.logUsage("ATTACH_APP", paramList);
    }

    public static void logAttachExternal(ProfilingSettings ps, AttachSettings as) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        GestureSubmitter.fillParamsForProfiling(ps, paramList);
        GestureSubmitter.fillParamsForAttach(as, paramList);
        GestureSubmitter.logUsage("ATTACH_EXT", paramList);
    }

    private static void fillProjectParam(Lookup.Provider profiledProject, List<Object> paramList) {
        String param = "";
        if (profiledProject != null) {
            param = profiledProject.getClass().getName();
        }
        paramList.add(0, param);
    }

    private static void fillParamsForAttach(AttachSettings as, List<Object> paramList) {
        paramList.add(as.isDirect() ? "ATTACH_DIRECT" : "ATTACH_DYNAMIC");
        paramList.add(as.isRemote() ? "ATTACH_REMOTE" : "ATTACH_LOCAL");
    }

    private static void fillParamsForProfiling(ProfilingSettings ps, List<Object> paramList) {
        switch (ps.getProfilingType()) {
            case 8: {
                paramList.add("TYPE_CPU_ENTIRE");
                break;
            }
            case 16: {
                paramList.add("TYPE_CPU_PART");
                break;
            }
            case 256: {
                paramList.add("TYPE_CPU_JDBC");
                break;
            }
            case 64: {
                paramList.add("TYPE_CPU_SAMPLING");
                break;
            }
            case 32: {
                paramList.add("TYPE_CPU_STOPWATCH");
                break;
            }
            case 2: {
                paramList.add("TYPE_MEM_ALLOC");
                break;
            }
            case 4: {
                paramList.add("TYPE_MEM_LIVENESS");
                break;
            }
            case 128: {
                paramList.add("TYPE_MEM_SAMPLING");
                break;
            }
            case 1: {
                paramList.add("TYPE_MONITOR");
            }
        }
        if (ps.getThreadsMonitoringEnabled()) {
            paramList.add("TYPE_THREADS");
        }
        if (ps.getLockContentionMonitoringEnabled()) {
            paramList.add("TYPE_LOCKS");
        }
    }

    private static void logUsage(String startType, List<Object> params) {
        LogRecord record = new LogRecord(Level.INFO, "USG_PROFILER_" + startType);
        record.setResourceBundle(NbBundle.getBundle(GestureSubmitter.class));
        record.setResourceBundleName(GestureSubmitter.class.getPackage().getName() + ".Bundle");
        record.setLoggerName(USG_LOGGER.getName());
        record.setParameters(params.toArray(new Object[0]));
        USG_LOGGER.log(record);
    }
}

