/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.composer.commands.Composer;
import org.netbeans.modules.php.composer.output.model.ComposerPackage;
import org.netbeans.modules.php.composer.output.model.SearchResult;
import org.netbeans.modules.php.composer.ui.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class DependenciesPanel
extends JPanel {
    private static final long serialVersionUID = -54676446789654L;
    private static final SearchResult SEARCHING_SEARCH_RESULT = new SearchResult(null, null);
    private static final SearchResult NO_RESULTS_SEARCH_RESULT = new SearchResult(null, null);
    private final PhpModule phpModule;
    private final List<SearchResult> searchResults = Collections.synchronizedList(new ArrayList());
    private final ResultsListModel resultsModel = new ResultsListModel(this.searchResults);
    private final ConcurrentMap<String, String> resultDetails = new ConcurrentHashMap<String, String>();
    private final VersionComboBoxModel versionsModel = new VersionComboBoxModel();
    private final RequestProcessor postSearchRequestProcessor = new RequestProcessor(DependenciesPanel.class.getName() + " (POST SEARCH)");
    private final RequestProcessor postShowRequestProcessor = new RequestProcessor(DependenciesPanel.class.getName() + " (POST SHOW)");
    private final List<Future<Integer>> searchTasks = new CopyOnWriteArrayList<Future<Integer>>();
    private final List<Future<Integer>> showTasks = new CopyOnWriteArrayList<Future<Integer>>();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JScrollPane detailsScrollPane;
    private JTextPane detailsTextPane;
    private JCheckBox onlyNameCheckBox;
    private JSplitPane outputSplitPane;
    private JLabel packagesLabel;
    private JList<SearchResult> resultsList;
    private JScrollPane resultsScrollPane;
    private JButton searchButton;
    private JLabel tokenLabel;
    private JTextField tokenTextField;
    private JComboBox<String> versionComboBox;
    private JLabel versionLabel;

    private DependenciesPanel(@NullAllowed PhpModule phpModule) {
        this.phpModule = phpModule;
        this.initComponents();
        this.init();
    }

    public static DependenciesPanel create() {
        return DependenciesPanel.create(null);
    }

    public static DependenciesPanel create(PhpModule phpModule) {
        return new DependenciesPanel(phpModule);
    }

    public void setDefaultAction(Dialog dialog, final Runnable defaultResultsListTask) {
        if (!(dialog instanceof JDialog)) {
            return;
        }
        JRootPane rootPane = ((JDialog)dialog).getRootPane();
        rootPane.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "enter");
        rootPane.getActionMap().put("enter", new AbstractAction(){
            private static final long serialVersionUID = -687845132165467L;

            @Override
            public void actionPerformed(ActionEvent e) {
                assert (EventQueue.isDispatchThread());
                if (DependenciesPanel.this.tokenTextField.hasFocus()) {
                    if (DependenciesPanel.this.searchButton.isEnabled()) {
                        DependenciesPanel.this.searchButton.doClick();
                    }
                } else if (DependenciesPanel.this.resultsList.hasFocus()) {
                    defaultResultsListTask.run();
                }
            }
        });
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @CheckForNull
    public ComposerPackage getComposerPackage() {
        SearchResult selectedSearchResult = this.getSelectedSearchResult();
        String selectedVersion = this.getSelectedResultVersion();
        if (selectedSearchResult == null || selectedVersion == null) {
            return null;
        }
        return new ComposerPackage(selectedSearchResult.getName(), selectedVersion);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.cleanUp();
    }

    private void init() {
        this.initSearch();
        this.initResults();
        this.initVersions();
    }

    private void initSearch() {
        this.enableSearchButton();
        this.tokenTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processChange();
            }

            private void processChange() {
                DependenciesPanel.this.enableSearchButton();
            }
        });
    }

    private void initResults() {
        this.outputSplitPane.setDividerLocation(0.5);
        this.resultsList.setModel(this.resultsModel);
        this.resultsList.setCellRenderer(new ResultListCellRenderer());
        this.updateResultDetailsAndVersions(false);
        this.resultsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DependenciesPanel.this.resultsChanged();
            }
        });
        this.resultsModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.processChange();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.processChange();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                this.processChange();
            }

            private void processChange() {
                DependenciesPanel.this.resultsChanged();
            }
        });
    }

    private void initVersions() {
        this.versionComboBox.setModel(this.versionsModel);
        this.versionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DependenciesPanel.this.versionChanged();
            }
        });
        this.versionsModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.processChange();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.processChange();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                this.processChange();
            }

            private void processChange() {
                DependenciesPanel.this.versionChanged();
            }
        });
    }

    void resultsChanged() {
        this.updateResultDetailsAndVersions(false);
        this.fireChange();
    }

    void versionChanged() {
        this.fireChange();
    }

    void enableSearchButton() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                DependenciesPanel.this.searchButton.setEnabled(StringUtils.hasText((String)DependenciesPanel.this.tokenTextField.getText()));
            }
        });
    }

    void clearSearchResults() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                DependenciesPanel.this.searchResults.clear();
                DependenciesPanel.this.resultsModel.fireContentsChanged();
            }
        });
    }

    void addSearchResult(SearchResult searchResult) {
        this.addSearchResult(searchResult, false);
    }

    void addSearchResult(final SearchResult searchResult, final boolean select) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                DependenciesPanel.this.searchResults.add(searchResult);
                DependenciesPanel.this.resultsModel.fireContentsChanged();
                if (select) {
                    DependenciesPanel.this.resultsList.setSelectedValue(searchResult, true);
                }
            }
        });
    }

    void removeSearchResult(final SearchResult searchResult) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                if (DependenciesPanel.this.searchResults.remove(searchResult)) {
                    DependenciesPanel.this.resultsModel.fireContentsChanged();
                }
            }
        });
    }

    void updateResultDetailsAndVersions(boolean fetchDetails) {
        assert (EventQueue.isDispatchThread());
        String msg = "";
        List<String> versions = null;
        SearchResult selectedSearchResult = this.getSelectedSearchResult();
        if (selectedSearchResult != null) {
            String name = selectedSearchResult.getName();
            String details = this.getResultsDetails(name, fetchDetails);
            if (details != null) {
                msg = details;
            }
            versions = this.getResultVersions(name);
        }
        this.detailsTextPane.setText(msg);
        this.detailsTextPane.setCaretPosition(0);
        if (versions == null) {
            this.versionsModel.setNoVersions();
        } else {
            this.versionsModel.setVersions(versions);
        }
    }

    private String getResultsDetails(final String resultName, boolean fetchDetails) {
        if (resultName == null) {
            return null;
        }
        String details = (String)this.resultDetails.get(resultName);
        if (details != null) {
            return details;
        }
        if (!fetchDetails) {
            return null;
        }
        final Composer composer = this.getComposer();
        if (composer == null) {
            return null;
        }
        String loading = Bundle.DependenciesPanel_details_loading();
        String prev = this.resultDetails.putIfAbsent(resultName, loading);
        assert (prev == null) : "Previous message found?!: " + prev;
        this.postShowRequestProcessor.post(new Runnable(){

            @Override
            public void run() {
                final StringBuffer buffer = new StringBuffer(200);
                Future<Integer> task = composer.show(DependenciesPanel.this.phpModule, resultName, new Composer.OutputProcessor<String>(){

                    @Override
                    public void process(String chunk) {
                        buffer.append(chunk);
                    }
                });
                if (task == null) {
                    DependenciesPanel.this.resultDetails.remove(resultName);
                } else {
                    DependenciesPanel.this.showTasks.add(task);
                    DependenciesPanel.this.runWhenTaskFinish(task, null, new Runnable(){

                        @Override
                        public void run() {
                            if (buffer.length() == 0) {
                                DependenciesPanel.this.resultDetails.remove(resultName);
                            } else {
                                DependenciesPanel.this.resultDetails.put(resultName, buffer.toString());
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DependenciesPanel.this.updateResultDetailsAndVersions(false);
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
        return loading;
    }

    @CheckForNull
    private List<String> getResultVersions(String resultName) {
        if (resultName == null) {
            return null;
        }
        String details = (String)this.resultDetails.get(resultName);
        if (details == null) {
            return null;
        }
        return VersionsParser.parse(details);
    }

    @CheckForNull
    SearchResult getSelectedSearchResult() {
        assert (EventQueue.isDispatchThread());
        SearchResult selectedValue = this.resultsList.getSelectedValue();
        if (selectedValue == null || selectedValue == SEARCHING_SEARCH_RESULT || selectedValue == NO_RESULTS_SEARCH_RESULT) {
            return null;
        }
        return selectedValue;
    }

    @CheckForNull
    private String getSelectedResultVersion() {
        assert (EventQueue.isDispatchThread());
        Object selectedVersion = this.versionsModel.getSelectedItem();
        if (selectedVersion == VersionComboBoxModel.NO_VERSIONS_AVAILABLE) {
            return null;
        }
        return (String)selectedVersion;
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    @CheckForNull
    Composer getComposer() {
        try {
            return Composer.getDefault();
        }
        catch (InvalidPhpExecutableException ex) {
            UiUtils.invalidScriptProvided((String)Bundle.DependenciesPanel_error_composer_notValid(), (String)"FrameworksAndTools/Composer");
            return null;
        }
    }

    private void cleanUp() {
        this.postSearchRequestProcessor.shutdownNow();
        this.postShowRequestProcessor.shutdownNow();
        this.cancelTasks(this.searchTasks);
        this.cancelTasks(this.showTasks);
    }

    private void cancelTasks(List<Future<Integer>> tasks) {
        ArrayList<Future<Integer>> tasksCopy = new ArrayList<Future<Integer>>(tasks);
        for (Future<Integer> task : tasksCopy) {
            assert (task != null);
            task.cancel(true);
        }
        tasks.removeAll(tasksCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runWhenTaskFinish(Future<Integer> task, @NullAllowed Runnable postTask, @NullAllowed Runnable finalTask) {
        try {
            task.get(3L, TimeUnit.MINUTES);
            if (postTask != null) {
                postTask.run();
            }
        }
        catch (TimeoutException ex) {
            task.cancel(true);
        }
        catch (CancellationException ex) {
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)"FrameworksAndTools/Composer");
        }
        finally {
            if (finalTask != null) {
                finalTask.run();
            }
        }
    }

    private void initComponents() {
        this.tokenLabel = new JLabel();
        this.tokenTextField = new JTextField();
        this.onlyNameCheckBox = new JCheckBox();
        this.searchButton = new JButton();
        this.packagesLabel = new JLabel();
        this.outputSplitPane = new JSplitPane();
        this.resultsScrollPane = new JScrollPane();
        this.resultsList = new JList();
        this.detailsScrollPane = new JScrollPane();
        this.detailsTextPane = new JTextPane();
        this.versionLabel = new JLabel();
        this.versionComboBox = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.tokenLabel, (String)NbBundle.getMessage(DependenciesPanel.class, (String)"DependenciesPanel.tokenLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.onlyNameCheckBox, (String)NbBundle.getMessage(DependenciesPanel.class, (String)"DependenciesPanel.onlyNameCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(DependenciesPanel.class, (String)"DependenciesPanel.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DependenciesPanel.this.searchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.packagesLabel, (String)NbBundle.getMessage(DependenciesPanel.class, (String)"DependenciesPanel.packagesLabel.text"));
        this.outputSplitPane.setOrientation(0);
        this.outputSplitPane.setResizeWeight(0.5);
        this.resultsList.setSelectionMode(0);
        this.resultsList.setMinimumSize(new Dimension(100, 50));
        this.resultsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DependenciesPanel.this.resultsListMouseClicked(evt);
            }
        });
        this.resultsScrollPane.setViewportView(this.resultsList);
        this.outputSplitPane.setLeftComponent(this.resultsScrollPane);
        this.detailsTextPane.setEditable(false);
        this.detailsTextPane.setFont(new Font("Monospaced", 0, 12));
        this.detailsTextPane.setMinimumSize(new Dimension(100, 50));
        this.detailsScrollPane.setViewportView(this.detailsTextPane);
        this.outputSplitPane.setBottomComponent(this.detailsScrollPane);
        this.versionLabel.setLabelFor(this.versionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage(DependenciesPanel.class, (String)"DependenciesPanel.versionLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputSplitPane).addGroup(layout.createSequentialGroup().addComponent(this.tokenLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.onlyNameCheckBox).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.tokenTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.packagesLabel).addGroup(layout.createSequentialGroup().addComponent(this.versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionComboBox, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tokenLabel).addComponent(this.tokenTextField, -2, -1, -2).addComponent(this.searchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.onlyNameCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.packagesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputSplitPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionLabel).addComponent(this.versionComboBox, -2, -1, -2)).addGap(0, 0, 0)));
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        Composer composer = this.getComposer();
        if (composer == null) {
            return;
        }
        this.cancelTasks(this.searchTasks);
        this.cancelTasks(this.showTasks);
        this.searchButton.setEnabled(false);
        this.clearSearchResults();
        this.addSearchResult(SEARCHING_SEARCH_RESULT);
        String token = this.tokenTextField.getText();
        boolean onlyName = this.onlyNameCheckBox.isSelected();
        final Future<Integer> task = composer.search(this.phpModule, token, onlyName, new Composer.OutputProcessor<SearchResult>(){
            private boolean first = true;

            @Override
            public void process(SearchResult item) {
                if (this.first) {
                    this.first = false;
                    DependenciesPanel.this.clearSearchResults();
                    DependenciesPanel.this.addSearchResult(item, true);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DependenciesPanel.this.updateResultDetailsAndVersions(true);
                        }
                    });
                } else {
                    DependenciesPanel.this.addSearchResult(item);
                }
            }
        });
        if (task == null) {
            this.enableSearchButton();
        } else {
            this.searchTasks.add(task);
            this.postSearchRequestProcessor.post(new Runnable(){

                @Override
                public void run() {
                    DependenciesPanel.this.runWhenTaskFinish(task, new Runnable(){

                        @Override
                        public void run() {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DependenciesPanel.this.removeSearchResult(SEARCHING_SEARCH_RESULT);
                                    if (DependenciesPanel.this.searchResults.isEmpty()) {
                                        DependenciesPanel.this.addSearchResult(NO_RESULTS_SEARCH_RESULT);
                                    }
                                }
                            });
                        }
                    }, new Runnable(){

                        @Override
                        public void run() {
                            DependenciesPanel.this.enableSearchButton();
                        }
                    });
                }
            });
        }
    }

    private void resultsListMouseClicked(MouseEvent evt) {
        this.updateResultDetailsAndVersions(true);
    }

    private static final class VersionsParser {
        private static final String VERSIONS_PREFIX = "versions : ";
        private static final String VERSIONS_DELIMITER = ", ";

        private VersionsParser() {
        }

        @CheckForNull
        public static List<String> parse(String details) {
            String versionsLine = VersionsParser.getVersionLine(details);
            if (versionsLine == null) {
                return null;
            }
            return VersionsParser.getVersions(versionsLine);
        }

        @CheckForNull
        private static String getVersionLine(String details) {
            for (String line : details.split("\n")) {
                if (!(line = line.trim()).startsWith(VERSIONS_PREFIX)) continue;
                return line.substring(VERSIONS_PREFIX.length());
            }
            return null;
        }

        private static List<String> getVersions(String versionsLine) {
            ArrayList<String> versions = new ArrayList<String>(StringUtils.explode((String)versionsLine, (String)VERSIONS_DELIMITER));
            versions.add("*");
            return versions;
        }
    }

    private static final class VersionComboBoxModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        private static final long serialVersionUID = -7546812657897987L;
        static final String NO_VERSIONS_AVAILABLE = Bundle.VersionComboBoxModel_noVersions();
        private final List<String> versions = new ArrayList<String>();
        private volatile String selectedVersion = null;

        public VersionComboBoxModel() {
            this.setNoVersions();
        }

        @Override
        public int getSize() {
            assert (EventQueue.isDispatchThread());
            return this.versions.size();
        }

        @Override
        public String getElementAt(int index) {
            assert (EventQueue.isDispatchThread());
            return this.versions.get(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedVersion = (String)anItem;
            this.fireContentsChanged();
        }

        @Override
        @CheckForNull
        public Object getSelectedItem() {
            return this.selectedVersion;
        }

        public void setNoVersions() {
            assert (EventQueue.isDispatchThread());
            this.versions.clear();
            this.versions.add(NO_VERSIONS_AVAILABLE);
            this.selectedVersion = NO_VERSIONS_AVAILABLE;
            this.fireContentsChanged();
        }

        public void setVersions(List<String> versions) {
            assert (EventQueue.isDispatchThread());
            this.versions.clear();
            this.versions.addAll(versions);
            if (!versions.isEmpty()) {
                this.selectedVersion = versions.get(0);
            }
            this.fireContentsChanged();
        }

        private void fireContentsChanged() {
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }
    }

    private static final class ResultListCellRenderer
    implements ListCellRenderer<SearchResult> {
        private final ListCellRenderer<Object> defaultRenderer = new DefaultListCellRenderer();

        private ResultListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SearchResult> list, SearchResult value, int index, boolean isSelected, boolean cellHasFocus) {
            SearchResult result = value;
            String label = result == SEARCHING_SEARCH_RESULT ? Bundle.DependenciesPanel_results_searching() : (result == NO_RESULTS_SEARCH_RESULT ? Bundle.DependenciesPanel_results_noResults() : Bundle.DependenciesPanel_results_result(result.getName(), result.getDescription()));
            return this.defaultRenderer.getListCellRendererComponent(list, label, index, isSelected, cellHasFocus);
        }
    }

    private static final class ResultsListModel
    extends AbstractListModel<SearchResult> {
        private static final long serialVersionUID = -897454654321324564L;
        private final List<SearchResult> searchResults;

        public ResultsListModel(List<SearchResult> searchResults) {
            assert (EventQueue.isDispatchThread());
            this.searchResults = searchResults;
        }

        @Override
        public int getSize() {
            assert (EventQueue.isDispatchThread());
            return this.searchResults.size();
        }

        @Override
        public SearchResult getElementAt(int index) {
            assert (EventQueue.isDispatchThread());
            try {
                return this.searchResults.get(index);
            }
            catch (IndexOutOfBoundsException ex) {
                return null;
            }
        }

        public void fireContentsChanged() {
            assert (EventQueue.isDispatchThread());
            this.fireContentsChanged(this, 0, this.searchResults.size());
        }
    }
}

